/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugins.scripting.AbstractScriptEvaluator;
import org.apache.maven.plugins.scripting.UnsupportedScriptEngineException;

public class FileScriptEvaluator
extends AbstractScriptEvaluator {
    private final File scriptFile;
    private final String engineName;

    public FileScriptEvaluator(String engineName, File scriptFile) {
        this.scriptFile = scriptFile;
        this.engineName = engineName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object eval(ScriptEngine engine, ScriptContext context) throws ScriptException {
        try (FileReader reader = new FileReader(this.scriptFile);){
            Object object = engine.eval((Reader)reader, context);
            return object;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(this.scriptFile + " caused:", ex);
        }
    }

    @Override
    protected ScriptEngine getEngine(ScriptEngineManager manager) throws UnsupportedScriptEngineException {
        ScriptEngine result;
        if (this.engineName != null && !this.engineName.isEmpty()) {
            result = manager.getEngineByName(this.engineName);
            if (result == null) {
                throw new UnsupportedScriptEngineException("No engine found by name \"" + this.engineName + "\n");
            }
        } else {
            String extension = this.scriptFile.getName();
            int position = extension.indexOf(".");
            if (position >= 0) {
                extension = extension.substring(position + 1);
            }
            if ((result = manager.getEngineByExtension(extension)) == null) {
                throw new UnsupportedScriptEngineException("No engine found by extension \"" + extension + "\n");
            }
        }
        return result;
    }
}

