/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public abstract class AbstractScmMojo
extends AbstractMojo {
    protected static final String VERSION_TYPE_BRANCH = "branch";
    protected static final String VERSION_TYPE_REVISION = "revision";
    protected static final String VERSION_TYPE_TAG = "tag";
    protected static final String[] VALID_VERSION_TYPES = new String[]{"branch", "revision", "tag"};
    @Parameter(property="connectionUrl", defaultValue="${project.scm.connection}")
    private String connectionUrl;
    @Parameter(property="developerConnectionUrl", defaultValue="${project.scm.developerConnection}")
    private String developerConnectionUrl;
    @Parameter(property="connectionType", defaultValue="connection")
    private String connectionType;
    @Parameter(property="workingDirectory")
    private File workingDirectory;
    @Parameter(property="username")
    private String username;
    @Parameter(property="password")
    private String password;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="passphrase")
    private String passphrase;
    @Parameter(property="tagBase")
    private String tagBase;
    @Parameter(property="includes")
    private String includes;
    @Parameter(property="excludes")
    private String excludes;
    @Component
    private ScmManager manager;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Parameter(property="basedir", required=true)
    private File basedir;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter
    private Properties systemProperties;
    @Parameter
    private Map<String, String> providerImplementations;
    @Parameter(property="pushChanges", defaultValue="true")
    private boolean pushChanges;
    @Deprecated
    @Parameter(property="workItem")
    private String workItem;

    public void execute() throws MojoExecutionException {
        if (this.systemProperties != null) {
            for (String string : this.systemProperties.keySet()) {
                String value = this.systemProperties.getProperty(string);
                System.setProperty(string, value);
            }
        }
        if (this.providerImplementations != null && !this.providerImplementations.isEmpty()) {
            for (Map.Entry<String, String> entry : this.providerImplementations.entrySet()) {
                String providerType = entry.getKey();
                String providerImplementation = entry.getValue();
                this.getLog().info((CharSequence)("Change the default '" + providerType + "' provider implementation to '" + providerImplementation + "'."));
                this.getScmManager().setScmProviderImplementation(providerType, providerImplementation);
            }
        }
    }

    protected void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionUrl() {
        boolean requireDeveloperConnection;
        boolean bl = requireDeveloperConnection = !"connection".equals(this.connectionType.toLowerCase());
        if (this.connectionUrl != null && !this.connectionUrl.isEmpty() && !requireDeveloperConnection) {
            return this.connectionUrl;
        }
        if (this.developerConnectionUrl != null && !this.developerConnectionUrl.isEmpty()) {
            return this.developerConnectionUrl;
        }
        if (requireDeveloperConnection) {
            throw new NullPointerException("You need to define a developerConnectionUrl parameter");
        }
        throw new NullPointerException("You need to define a connectionUrl parameter");
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            return this.basedir;
        }
        return this.workingDirectory;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public ScmManager getScmManager() {
        return this.manager;
    }

    public ScmFileSet getFileSet() throws IOException {
        if (this.includes != null || this.excludes != null) {
            return new ScmFileSet(this.getWorkingDirectory(), this.includes, this.excludes);
        }
        return new ScmFileSet(this.getWorkingDirectory());
    }

    public ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(this.getConnectionUrl());
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            providerRepo.setPushChanges(this.pushChanges);
            if (this.workItem != null && !this.workItem.isEmpty()) {
                providerRepo.setWorkItem(this.workItem);
            }
            if (this.username != null && !this.username.isEmpty()) {
                providerRepo.setUser(this.username);
            }
            if (this.password != null && !this.password.isEmpty()) {
                providerRepo.setPassword(this.password);
            }
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.loadInfosFromSettings(repo);
                if (this.username != null && !this.username.isEmpty()) {
                    repo.setUser(this.username);
                }
                if (this.password != null && !this.password.isEmpty()) {
                    repo.setPassword(this.password);
                }
                if (this.privateKey != null && !this.privateKey.isEmpty()) {
                    repo.setPrivateKey(this.privateKey);
                }
                if (this.passphrase != null && !this.passphrase.isEmpty()) {
                    repo.setPassphrase(this.passphrase);
                }
            }
            if (this.tagBase != null && !this.tagBase.isEmpty() && repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                svnRepo.setTagBase(this.tagBase);
            }
        }
        catch (ScmRepositoryException e) {
            if (!e.getValidationMessages().isEmpty()) {
                for (String message : e.getValidationMessages()) {
                    this.getLog().error((CharSequence)message);
                }
            }
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                server = this.decrypt(server);
                if (this.username == null) {
                    this.username = server.getUsername();
                }
                if (this.password == null) {
                    this.password = server.getPassword();
                }
                if (this.privateKey == null) {
                    this.privateKey = server.getPrivateKey();
                }
                if (this.passphrase == null) {
                    this.passphrase = server.getPassphrase();
                }
            }
        }
    }

    private Server decrypt(Server server) {
        SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
        for (SettingsProblem problem : result.getProblems()) {
            this.getLog().error((CharSequence)problem.getMessage(), (Throwable)problem.getException());
        }
        return result.getServer();
    }

    public void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed: " + Objects.toString(result.getProviderMessage()));
        }
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public ScmVersion getScmVersion(String versionType, String version) throws MojoExecutionException {
        if ((versionType == null || versionType.isEmpty()) && version != null && !version.isEmpty()) {
            throw new MojoExecutionException("You must specify the version type.");
        }
        if (version == null || version.isEmpty()) {
            return null;
        }
        if (VERSION_TYPE_BRANCH.equals(versionType)) {
            return new ScmBranch(version);
        }
        if (VERSION_TYPE_TAG.equals(versionType)) {
            return new ScmTag(version);
        }
        if (VERSION_TYPE_REVISION.equals(versionType)) {
            return new ScmRevision(version);
        }
        throw new MojoExecutionException("Unknown '" + versionType + "' version type.");
    }

    protected void handleExcludesIncludesAfterCheckoutAndExport(File checkoutDirectory) throws MojoExecutionException {
        ArrayList<String> includes = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)this.getIncludes())) {
            String[] tokens = StringUtils.split((String)this.getIncludes(), (String)",");
            for (int i = 0; i < tokens.length; ++i) {
                includes.add(tokens[i]);
            }
        }
        ArrayList<String> excludes = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)this.getExcludes())) {
            String[] tokens = StringUtils.split((String)this.getExcludes(), (String)",");
            for (int i = 0; i < tokens.length; ++i) {
                excludes.add(tokens[i]);
            }
        }
        if (includes.isEmpty() && excludes.isEmpty()) {
            return;
        }
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fileset = new FileSet();
        fileset.setDirectory(checkoutDirectory.getAbsolutePath());
        fileset.setIncludes(excludes);
        fileset.setExcludes(includes);
        fileset.setUseDefaultExcludes(false);
        try {
            fileSetManager.delete(fileset);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error found while cleaning up output directory base on excludes/includes configurations.", (Exception)e);
        }
    }
}

