/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="list", aggregator=true)
public class ListMojo
extends AbstractScmMojo {
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive = true;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            ListScmResult result = this.getScmManager().list(repository, this.getFileSet(), this.recursive, this.getScmVersion(this.scmVersionType, this.scmVersion));
            this.checkResult((ScmResult)result);
            if (result.getFiles() != null) {
                for (ScmFile scmFile : result.getFiles()) {
                    this.getLog().info((CharSequence)scmFile.getPath());
                }
            }
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run list command : ", (Exception)e);
        }
    }

    @Override
    public ScmFileSet getFileSet() throws IOException {
        if (this.getIncludes() != null || this.getExcludes() != null) {
            return new ScmFileSet(this.getWorkingDirectory(), this.getIncludes(), this.getExcludes());
        }
        return new ScmFileSet(this.getWorkingDirectory(), new File("."));
    }
}

