/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;

public abstract class AbstractScmReadReleaseMojo
extends AbstractReleaseMojo {
    @Parameter(property="project.scm.id", defaultValue="${project.scm.id}")
    private String serverId;
    @Parameter(property="username")
    private String username;
    @Parameter(property="password")
    private String password;
    @Parameter(property="privateKey")
    private File privateKey;
    @Parameter
    private Map<String, String> providerImplementations;
    @Parameter(defaultValue="true", property="scmShallowClone")
    private boolean scmShallowClone = true;
    private final ScmManager scmManager;

    protected AbstractScmReadReleaseMojo(ReleaseManager releaseManager, ScmManager scmManager) {
        super(releaseManager);
        this.scmManager = scmManager;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> providerEntry : this.providerImplementations.entrySet()) {
                this.getLog().info((CharSequence)("Change the default '" + providerEntry.getKey() + "' provider implementation to '" + providerEntry.getValue() + "'."));
                this.scmManager.setScmProviderImplementation(providerEntry.getKey(), providerEntry.getValue());
            }
        }
    }

    @Override
    protected ReleaseDescriptorBuilder createReleaseDescriptor() {
        ReleaseDescriptorBuilder descriptor = super.createReleaseDescriptor();
        if (this.privateKey != null) {
            descriptor.setScmPrivateKey(this.privateKey.getAbsolutePath());
        }
        descriptor.setScmPassword(this.password);
        descriptor.setScmUsername(this.username);
        descriptor.setScmShallowClone(this.scmShallowClone);
        if (this.project.getScm() != null) {
            if (this.project.getScm().getDeveloperConnection() != null) {
                descriptor.setScmSourceUrl(this.project.getScm().getDeveloperConnection());
            } else if (this.project.getScm().getConnection() != null) {
                descriptor.setScmSourceUrl(this.project.getScm().getConnection());
            }
        }
        descriptor.setScmId(this.serverId);
        for (MavenProject reactorProject : this.session.getProjects()) {
            if (reactorProject.getOriginalModel() == null || reactorProject.getOriginalModel().getScm() == null) continue;
            String projectId = ArtifactUtils.versionlessKey((String)reactorProject.getGroupId(), (String)reactorProject.getArtifactId());
            descriptor.addOriginalScmInfo(projectId, this.buildScm(reactorProject));
        }
        return descriptor;
    }

    protected Scm buildScm(MavenProject project) {
        Scm scm;
        if (project.getOriginalModel().getScm() == null) {
            scm = null;
        } else {
            scm = new Scm();
            scm.setConnection(project.getOriginalModel().getScm().getConnection());
            scm.setDeveloperConnection(project.getOriginalModel().getScm().getDeveloperConnection());
            scm.setTag(project.getOriginalModel().getScm().getTag());
            scm.setUrl(project.getOriginalModel().getScm().getUrl());
        }
        return scm;
    }
}

