/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import javax.inject.Inject;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.DefaultReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseUpdateVersionsRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.codehaus.plexus.configuration.PlexusConfiguration;

@Mojo(name="update-versions", aggregator=true)
public class UpdateVersionsMojo
extends AbstractReleaseMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules;
    @Parameter(defaultValue="true", property="addSchema")
    private boolean addSchema;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="useEditMode")
    private boolean useEditMode;
    @Parameter(defaultValue="default", property="projectVersionPolicyId")
    private String projectVersionPolicyId;
    @Parameter(property="projectVersionPolicyConfig")
    private PlexusConfiguration projectVersionPolicyConfig;

    @Inject
    public UpdateVersionsMojo(ReleaseManager releaseManager) {
        super(releaseManager);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseDescriptorBuilder config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setScmUseEditMode(this.useEditMode);
        config.setUpdateDependencies(this.updateDependencies);
        config.setProjectVersionPolicyId(this.projectVersionPolicyId);
        if (this.projectVersionPolicyConfig != null) {
            config.setProjectVersionPolicyConfig(this.projectVersionPolicyConfig.toString());
        }
        config.addOriginalScmInfo(ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId()), this.project.getScm());
        try {
            ReleaseUpdateVersionsRequest updateVersionsRequest = new ReleaseUpdateVersionsRequest();
            updateVersionsRequest.setReleaseDescriptorBuilder(config);
            updateVersionsRequest.setReleaseEnvironment(this.getReleaseEnvironment());
            updateVersionsRequest.setReactorProjects(this.getReactorProjects());
            updateVersionsRequest.setReleaseManagerListener((ReleaseManagerListener)new DefaultReleaseManagerListener(this.getLog()));
            updateVersionsRequest.setUserProperties(this.session.getUserProperties());
            this.releaseManager.updateVersions(updateVersionsRequest);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

