/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.HashMap;
import java.util.Properties;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseUtils;

@Mojo(name="update-versions", aggregator=true)
public class UpdateVersionsMojo
extends AbstractReleaseMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules;
    @Parameter(defaultValue="true", property="addSchema")
    private boolean addSchema;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies;
    @Parameter(defaultValue="false", property="useEditMode")
    private boolean useEditMode;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setScmUseEditMode(this.useEditMode);
        config.setUpdateDependencies(this.updateDependencies);
        HashMap<String, Scm> originalScmInfo = new HashMap<String, Scm>();
        originalScmInfo.put(ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId()), this.project.getScm());
        config.setOriginalScmInfo(originalScmInfo);
        ReleaseDescriptor sysPropertiesConfig = ReleaseUtils.copyPropertiesToReleaseDescriptor((Properties)this.session.getExecutionProperties());
        this.mergeCommandLineConfig(config, sysPropertiesConfig);
        try {
            this.releaseManager.updateVersions(config, this.getReleaseEnvironment(), this.getReactorProjects());
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

