/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.StringUtils;

public class BranchReleaseMojo
extends AbstractReleaseMojo {
    private String branchName;
    private boolean updateBranchVersions;
    private boolean updateWorkingCopyVersions;
    private boolean updateVersionsToSnapshot;
    private boolean useEditMode;
    private boolean updateDependencies;
    private boolean autoVersionSubmodules;
    private boolean dryRun;
    private boolean addSchema;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (StringUtils.isEmpty((String)this.branchName)) {
            throw new MojoExecutionException("The branch name is required.");
        }
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setScmUseEditMode(this.useEditMode);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setScmReleaseLabel(this.branchName);
        config.setBranchCreation(true);
        config.setUpdateBranchVersions(this.updateBranchVersions);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setUpdateVersionsToSnapshot(this.updateVersionsToSnapshot);
        try {
            this.releaseManager.branch(config, this.getReleaseEnvironment(), this.reactorProjects, this.dryRun);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            e.printStackTrace();
            throw new MojoFailureException(e.getMessage());
        }
    }
}

