/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.ConfigurationService;
import org.apache.maven.plugins.pmd.PmdReportRenderer;
import org.apache.maven.plugins.pmd.exec.PmdExecutor;
import org.apache.maven.plugins.pmd.exec.PmdRequest;
import org.apache.maven.plugins.pmd.exec.PmdResult;
import org.apache.maven.plugins.pmd.exec.PmdServiceExecutor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="pmd", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class PmdReport
extends AbstractPmdReport {
    @Parameter(property="targetJdk", defaultValue="${maven.compiler.source}")
    private String targetJdk;
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumPriority", defaultValue="5")
    private int minimumPriority = 5;
    @Parameter(property="pmd.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    String[] rulesets = new String[]{"/rulesets/java/maven-pmd-plugin-default.xml"};
    @Parameter(property="pmd.typeResolution", defaultValue="true")
    private boolean typeResolution;
    @Parameter(property="pmd.benchmark", defaultValue="false")
    private boolean benchmark;
    @Parameter(property="pmd.benchmarkOutputFilename", defaultValue="${project.build.directory}/pmd-benchmark.txt")
    private String benchmarkOutputFilename;
    @Parameter(property="pmd.suppressMarker")
    private String suppressMarker;
    @Parameter(property="pmd.skipPmdError", defaultValue="true")
    private boolean skipPmdError;
    @Parameter(property="pmd.analysisCache", defaultValue="false")
    private boolean analysisCache;
    @Parameter(property="pmd.analysisCacheLocation", defaultValue="${project.build.directory}/pmd/pmd.cache")
    private String analysisCacheLocation;
    @Parameter(property="pmd.renderProcessingErrors", defaultValue="true")
    private boolean renderProcessingErrors = true;
    @Parameter(property="pmd.renderRuleViolationPriority", defaultValue="true")
    private boolean renderRuleViolationPriority = true;
    @Parameter(property="pmd.renderViolationsByPriority", defaultValue="true")
    private boolean renderViolationsByPriority = true;
    @Parameter(property="pmd.renderSuppressedViolations", defaultValue="true")
    private boolean renderSuppressedViolations = true;
    @Parameter(property="pmd.rulesetsTargetDirectory", defaultValue="${project.build.directory}/pmd/rulesets")
    private File rulesetsTargetDirectory;
    private final ResourceManager locator;
    private final I18N i18n;
    private final PmdServiceExecutor serviceExecutor;
    private final ConfigurationService configurationService;
    private PmdResult pmdResult;

    @Inject
    public PmdReport(ResourceManager locator, ConfigurationService configurationService, I18N i18n, PmdServiceExecutor serviceExecutor) {
        this.locator = locator;
        this.configurationService = configurationService;
        this.i18n = i18n;
        this.serviceExecutor = serviceExecutor;
    }

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    protected String getI18nString(Locale locale, String key) {
        return this.i18n.getString("pmd-report", locale, "report.pmd." + key);
    }

    public void setRulesets(String[] rulesets) {
        this.rulesets = Arrays.copyOf(rulesets, rulesets.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            PmdReportRenderer renderer = new PmdReportRenderer(this.getLog(), this.getSink(), this.i18n, locale, this.filesToProcess, this.pmdResult.getViolations(), this.renderRuleViolationPriority, this.renderViolationsByPriority, this.isAggregator());
            if (this.renderSuppressedViolations) {
                renderer.setSuppressedViolations(this.pmdResult.getSuppressedViolations());
            }
            if (this.renderProcessingErrors) {
                renderer.setProcessingErrors(this.pmdResult.getErrors());
            }
            renderer.render();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    public boolean canGenerateReport() throws MavenReportException {
        if (this.skip) {
            return false;
        }
        boolean result = this.canGenerateReportInternal();
        if (result) {
            this.executePmd();
            if (this.skipEmptyReport) {
                result = this.pmdResult.hasViolations();
            }
        }
        return result;
    }

    private void executePmd() throws MavenReportException {
        if (this.pmdResult != null) {
            this.getLog().debug((CharSequence)"PMD has already been run - skipping redundant execution.");
            return;
        }
        try {
            this.filesToProcess = this.getFilesToProcess();
            if (this.filesToProcess.isEmpty() && !"java".equals(this.language)) {
                this.getLog().warn((CharSequence)"No files found to process. Did you forget to add additional source directories? (see also build-helper-maven-plugin)");
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Can't get file list", (Exception)e);
        }
        PmdRequest request = new PmdRequest();
        request.setLanguageAndVersion(this.language, this.targetJdk);
        request.setRulesets(this.resolveRulesets());
        request.setAuxClasspath(this.typeResolution ? this.determineAuxClasspath() : null);
        request.setSourceEncoding(this.getInputEncoding());
        request.addFiles(this.filesToProcess.keySet());
        request.setMinimumPriority(this.minimumPriority);
        request.setSuppressMarker(this.suppressMarker);
        request.setBenchmarkOutputLocation(this.benchmark ? this.benchmarkOutputFilename : null);
        request.setAnalysisCacheLocation(this.analysisCache ? this.analysisCacheLocation : null);
        request.setExcludeFromFailureFile(this.excludeFromFailureFile);
        request.setTargetDirectory(this.targetDirectory.getAbsolutePath());
        request.setOutputEncoding(this.getOutputEncoding());
        request.setFormat(this.format);
        request.setSkipPmdError(this.skipPmdError);
        request.setIncludeXmlInReports(this.includeXmlInReports);
        request.setReportOutputDirectory(this.getReportOutputDirectory().getAbsolutePath());
        request.setJdkToolchain(this.getJdkToolchain());
        this.getLog().info((CharSequence)("PMD version: " + AbstractPmdReport.getPmdVersion()));
        this.pmdResult = this.serviceExecutor.execute(request);
    }

    private List<String> resolveRulesets() throws MavenReportException {
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("file", this.project.getBasedir().getAbsolutePath());
        this.locator.addSearchPath("file", this.session.getRequest().getBaseDirectory());
        this.locator.setOutputDirectory(this.rulesetsTargetDirectory);
        String[] sets = new String[this.rulesets.length];
        try {
            for (int idx = 0; idx < this.rulesets.length; ++idx) {
                String set = this.rulesets[idx];
                this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                String rulesetFilename = this.determineRulesetFilename(set);
                File ruleset = this.locator.getResourceAsFile(rulesetFilename, this.getLocationTemp(set, idx + 1));
                if (null == ruleset) {
                    throw new MavenReportException("Could not resolve " + set);
                }
                sets[idx] = ruleset.getAbsolutePath();
            }
        }
        catch (FileResourceCreationException | ResourceNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        return Arrays.asList(sets);
    }

    private String determineRulesetFilename(String ruleset) {
        String rulesetFilename;
        String result = ruleset.trim();
        String lowercase = result.toLowerCase(Locale.ROOT);
        if (lowercase.startsWith("http://") || lowercase.startsWith("https://") || lowercase.endsWith(".xml")) {
            return result;
        }
        if (result.indexOf(47) > -1 && (rulesetFilename = result.substring(0, result.lastIndexOf(47))).toLowerCase(Locale.ROOT).endsWith(".xml")) {
            return rulesetFilename;
        }
        int dashIndex = lowercase.indexOf(45);
        if (dashIndex > -1 && lowercase.indexOf(45, dashIndex + 1) == -1) {
            String language = result.substring(0, dashIndex);
            String rulesetName = result.substring(dashIndex + 1);
            return "rulesets/" + language + "/" + rulesetName + ".xml";
        }
        return result;
    }

    protected String getLocationTemp(String name, int position) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        if ((loc = loc.replaceAll("[\\?\\:\\&\\=\\%]", "_")).endsWith(".xml")) {
            loc = loc.substring(0, loc.length() - 4);
        }
        loc = String.format("%03d-%s.xml", position, loc);
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    private String determineAuxClasspath() throws MavenReportException {
        try {
            ArrayList classpath = new ArrayList();
            if (this.isAggregator()) {
                ArrayList dependencies = new ArrayList();
                Collection<MavenProject> aggregatedProjects = this.getAggregatedProjects();
                for (MavenProject localProject : aggregatedProjects) {
                    this.configurationService.resolveDependenciesAsFile(localProject, aggregatedProjects, this.includeTests).forEach(file -> dependencies.add(file.getAbsolutePath()));
                    classpath.addAll(this.includeTests ? localProject.getTestClasspathElements() : localProject.getCompileClasspathElements());
                }
                classpath.addAll(dependencies);
                this.getLog().debug((CharSequence)("Using aggregated aux classpath: " + classpath));
            } else {
                classpath.addAll(this.includeTests ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements());
                this.getLog().debug((CharSequence)("Using aux classpath: " + classpath));
            }
            return StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    @Deprecated
    public String getOutputName() {
        return "pmd";
    }

    public String getOutputPath() {
        return "pmd";
    }

    @Deprecated
    public final Renderer createRenderer() throws MavenReportException {
        return PmdExecutor.createRenderer(this.format, this.getOutputEncoding());
    }
}

