/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.RulePriority;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.PmdFileInfo;
import org.apache.maven.plugins.pmd.model.ProcessingError;
import org.apache.maven.plugins.pmd.model.SuppressedViolation;
import org.apache.maven.plugins.pmd.model.Violation;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class PmdReportRenderer
extends AbstractMavenReportRenderer {
    private final Log log;
    private final I18N i18n;
    private final Locale locale;
    private final Map<File, PmdFileInfo> files;
    private String currentFilename;
    private final Collection<Violation> violations;
    private boolean renderRuleViolationPriority;
    private final boolean renderViolationsByPriority;
    private final boolean aggregate;
    private Collection<SuppressedViolation> suppressedViolations = new ArrayList<SuppressedViolation>();
    private Collection<ProcessingError> processingErrors = new ArrayList<ProcessingError>();

    public PmdReportRenderer(Log log, Sink sink, I18N i18n, Locale locale, Map<File, PmdFileInfo> files, Collection<Violation> violations, boolean renderRuleViolationPriority, boolean renderViolationsByPriority, boolean aggregate) {
        super(sink);
        this.log = log;
        this.i18n = i18n;
        this.locale = locale;
        this.files = files;
        this.violations = violations;
        this.renderRuleViolationPriority = renderRuleViolationPriority;
        this.renderViolationsByPriority = renderViolationsByPriority;
        this.aggregate = aggregate;
    }

    public void setSuppressedViolations(Collection<SuppressedViolation> suppressedViolations) {
        this.suppressedViolations = suppressedViolations;
    }

    public void setProcessingErrors(Collection<ProcessingError> processingErrors) {
        this.processingErrors = processingErrors;
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    private String getI18nString(String key) {
        return this.i18n.getString("pmd-report", this.locale, "report.pmd." + key);
    }

    public void renderBody() {
        this.startSection(this.getTitle());
        this.sink.paragraph();
        this.sink.text(this.getI18nString("pmdlink") + " ");
        this.link("https://pmd.github.io", "PMD");
        this.sink.text(" " + AbstractPmdReport.getPmdVersion() + ".");
        this.sink.paragraph_();
        if (!this.violations.isEmpty()) {
            this.renderViolationsByPriority();
            this.renderViolations();
        } else {
            this.paragraph(this.getI18nString("noProblems"));
        }
        this.renderSuppressedViolations();
        this.renderProcessingErrors();
        this.endSection();
    }

    private void startFileSection(String currentFilename, PmdFileInfo fileInfo) {
        this.currentFilename = this.shortenFilename(currentFilename, fileInfo);
        this.startSection(this.makeFileSectionName(this.currentFilename, fileInfo));
        this.startTable();
        this.sink.tableRow();
        this.tableHeaderCell(this.getI18nString("column.rule"));
        this.tableHeaderCell(this.getI18nString("column.violation"));
        if (this.renderRuleViolationPriority) {
            this.tableHeaderCell(this.getI18nString("column.priority"));
        }
        this.tableHeaderCell(this.getI18nString("column.line"));
        this.sink.tableRow_();
    }

    private void endFileSection() {
        this.endTable();
        this.endSection();
    }

    private void addRuleName(Violation ruleViolation) {
        boolean hasUrl = StringUtils.isNotBlank((String)ruleViolation.getExternalInfoUrl());
        if (hasUrl) {
            this.sink.link(ruleViolation.getExternalInfoUrl());
        }
        this.sink.text(ruleViolation.getRule());
        if (hasUrl) {
            this.sink.link_();
        }
    }

    private void renderSingleRuleViolation(Violation ruleViolation, PmdFileInfo fileInfo) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.addRuleName(ruleViolation);
        this.sink.tableCell_();
        this.tableCell(ruleViolation.getText());
        if (this.renderRuleViolationPriority) {
            this.tableCell(String.valueOf(RulePriority.valueOf((int)ruleViolation.getPriority()).getPriority()));
        }
        this.sink.tableCell();
        int beginLine = ruleViolation.getBeginline();
        this.outputLineLink(beginLine, fileInfo);
        int endLine = ruleViolation.getEndline();
        if (endLine != beginLine) {
            this.sink.text("&#x2013;");
            this.outputLineLink(endLine, fileInfo);
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderViolations() {
        this.startSection(this.getI18nString("files"));
        this.renderViolationsTable(this.violations);
        this.endSection();
    }

    private void renderViolationsByPriority() {
        if (!this.renderViolationsByPriority) {
            return;
        }
        boolean oldPriorityColumn = this.renderRuleViolationPriority;
        this.renderRuleViolationPriority = false;
        this.startSection(this.getI18nString("violationsByPriority"));
        HashMap<RulePriority, ArrayList<Violation>> violationsByPriority = new HashMap<RulePriority, ArrayList<Violation>>();
        for (Violation violation : this.violations) {
            RulePriority priority = RulePriority.valueOf((int)violation.getPriority());
            ArrayList<Violation> violationSegment = (ArrayList<Violation>)violationsByPriority.get(priority);
            if (violationSegment == null) {
                violationSegment = new ArrayList<Violation>();
                violationsByPriority.put(priority, violationSegment);
            }
            violationSegment.add(violation);
        }
        for (RulePriority priority : RulePriority.values()) {
            List violationsWithPriority = (List)violationsByPriority.get(priority);
            if (violationsWithPriority == null || violationsWithPriority.isEmpty()) continue;
            this.startSection(this.getI18nString("priority") + " " + priority.getPriority());
            this.renderViolationsTable(violationsWithPriority);
            this.endSection();
        }
        if (this.violations.isEmpty()) {
            this.paragraph(this.getI18nString("noProblems"));
        }
        this.endSection();
        this.renderRuleViolationPriority = oldPriorityColumn;
    }

    private void renderViolationsTable(Collection<Violation> violationSegment) {
        ArrayList<Violation> violationSegmentCopy = new ArrayList<Violation>(violationSegment);
        Collections.sort(violationSegmentCopy, new Comparator<Violation>(){

            @Override
            public int compare(Violation o1, Violation o2) {
                int filenames = o1.getFileName().compareTo(o2.getFileName());
                if (filenames == 0) {
                    return o1.getBeginline() - o2.getBeginline();
                }
                return filenames;
            }
        });
        boolean fileSectionStarted = false;
        String previousFilename = null;
        for (Violation ruleViolation : violationSegmentCopy) {
            String currentFn = ruleViolation.getFileName();
            PmdFileInfo fileInfo = this.determineFileInfo(currentFn);
            if (!currentFn.equalsIgnoreCase(previousFilename) && fileSectionStarted) {
                this.endFileSection();
                fileSectionStarted = false;
            }
            if (!fileSectionStarted) {
                this.startFileSection(currentFn, fileInfo);
                fileSectionStarted = true;
            }
            this.renderSingleRuleViolation(ruleViolation, fileInfo);
            previousFilename = currentFn;
        }
        if (fileSectionStarted) {
            this.endFileSection();
        }
    }

    private void outputLineLink(int line, PmdFileInfo fileInfo) {
        String xrefLocation = null;
        if (fileInfo != null) {
            xrefLocation = fileInfo.getXrefLocation();
        }
        if (xrefLocation != null) {
            this.sink.link(xrefLocation + "/" + this.currentFilename.replaceAll("\\.java$", ".html") + "#L" + line);
        }
        this.sink.text(String.valueOf(line));
        if (xrefLocation != null) {
            this.sink.link_();
        }
    }

    private void renderSuppressedViolations() {
        if (this.suppressedViolations.isEmpty()) {
            return;
        }
        this.startSection(this.getI18nString("suppressedViolations.title"));
        ArrayList<SuppressedViolation> suppressedViolationsCopy = new ArrayList<SuppressedViolation>(this.suppressedViolations);
        Collections.sort(suppressedViolationsCopy, new Comparator<SuppressedViolation>(){

            @Override
            public int compare(SuppressedViolation o1, SuppressedViolation o2) {
                return o1.getFilename().compareTo(o2.getFilename());
            }
        });
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("suppressedViolations.column.filename"), this.getI18nString("suppressedViolations.column.ruleMessage"), this.getI18nString("suppressedViolations.column.suppressionType"), this.getI18nString("suppressedViolations.column.userMessage")});
        for (SuppressedViolation suppressedViolation : suppressedViolationsCopy) {
            String filename = suppressedViolation.getFilename();
            PmdFileInfo fileInfo = this.determineFileInfo(filename);
            filename = this.shortenFilename(filename, fileInfo);
            this.tableRow(new String[]{filename, suppressedViolation.getRuleMessage(), suppressedViolation.getSuppressionType(), suppressedViolation.getUserMessage()});
        }
        this.endTable();
        this.endSection();
    }

    private void renderProcessingErrors() {
        if (this.processingErrors.isEmpty()) {
            return;
        }
        ArrayList<ProcessingError> processingErrorsCopy = new ArrayList<ProcessingError>(this.processingErrors);
        Collections.sort(processingErrorsCopy, new Comparator<ProcessingError>(){

            @Override
            public int compare(ProcessingError e1, ProcessingError e2) {
                return e1.getFilename().compareTo(e2.getFilename());
            }
        });
        this.startSection(this.getI18nString("processingErrors.title"));
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("processingErrors.column.filename"), this.getI18nString("processingErrors.column.problem")});
        for (ProcessingError error : processingErrorsCopy) {
            this.renderSingleProcessingError(error);
        }
        this.endTable();
        this.endSection();
    }

    private void renderSingleProcessingError(ProcessingError error) {
        String filename = error.getFilename();
        PmdFileInfo fileInfo = this.determineFileInfo(filename);
        filename = this.makeFileSectionName(this.shortenFilename(filename, fileInfo), fileInfo);
        this.sink.tableRow();
        this.tableCell(filename);
        this.sink.tableCell();
        this.sink.text(error.getMsg());
        this.sink.verbatim(null);
        this.sink.rawText(error.getDetail());
        this.sink.verbatim_();
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private String shortenFilename(String filename, PmdFileInfo fileInfo) {
        String result = filename;
        if (fileInfo != null && fileInfo.getSourceDirectory() != null) {
            result = StringUtils.substring((String)result, (int)(fileInfo.getSourceDirectory().getAbsolutePath().length() + 1));
        }
        return StringUtils.replace((String)result, (String)"\\", (String)"/");
    }

    private String makeFileSectionName(String filename, PmdFileInfo fileInfo) {
        if (this.aggregate && fileInfo != null && fileInfo.getProject() != null) {
            return fileInfo.getProject().getName() + " - " + filename;
        }
        return filename;
    }

    private PmdFileInfo determineFileInfo(String filename) {
        try {
            File canonicalFilename = new File(filename).getCanonicalFile();
            PmdFileInfo fileInfo = this.files.get(canonicalFilename);
            if (fileInfo == null) {
                this.log.warn((CharSequence)("Couldn't determine PmdFileInfo for file " + filename + " (canonical: " + canonicalFilename + "). XRef links won't be available."));
            }
            return fileInfo;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

