/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.benchmark.TextReport;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.PmdReportGenerator;
import org.apache.maven.plugin.pmd.PmdReportListener;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="pmd", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class PmdReport
extends AbstractPmdReport {
    @Parameter(property="targetJdk")
    private String targetJdk;
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumPriority", defaultValue="5")
    private int minimumPriority = 5;
    @Parameter(property="pmd.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] rulesets = new String[]{"java-basic", "java-unusedcode", "java-imports"};
    @Parameter(property="pmd.typeResolution", defaultValue="false")
    private boolean typeResolution;
    @Parameter(property="pmd.benchmark", defaultValue="false")
    private boolean benchmark;
    @Parameter(property="pmd.benchmarkOutputFilename", defaultValue="${project.build.directory}/pmd-benchmark.txt")
    private String benchmarkOutputFilename;
    @Component
    private ResourceManager locator;
    private PmdReportListener reportListener;
    @Parameter(property="pmd.skipPmdError", defaultValue="true")
    private boolean skipPmdError;

    public String getName(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.name");
    }

    public String getDescription(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.description");
    }

    public void setRulesets(String[] rules) {
        this.rulesets = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(locale);
        }
        finally {
            if (this.getSink() != null) {
                this.getSink().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Locale locale) throws MavenReportException {
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Report report = this.generateReport(locale);
                if (!this.isHtml() && !this.isXml()) {
                    this.writeNonHtml(report);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executePmdWithClassloader();
                if (this.skipEmptyReport && (result = this.reportListener.hasViolations())) {
                    this.getLog().debug((CharSequence)"Skipping Report as skipEmptyReport is true and there are no PMD violations.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePmdWithClassloader() throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.executePmd();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePmd() throws MavenReportException {
        String[] stringArray;
        if (this.reportListener != null) {
            this.getLog().debug((CharSequence)"PMD has already been run - skipping redundant execution.");
            return;
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(this.targetDirectory);
        this.reportListener = new PmdReportListener();
        PMDConfiguration pmdConfiguration = this.getPMDConfiguration();
        RuleContext ruleContext = new RuleContext();
        ruleContext.getReport().addListener((ReportListener)this.reportListener);
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        ruleSetFactory.setMinimumPriority(RulePriority.valueOf((int)this.minimumPriority));
        if (this.rulesets.length > 0) {
            stringArray = this.rulesets;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/rulesets/dummy.xml";
        }
        String[] presentRulesets = stringArray;
        Object[] sets = new String[presentRulesets.length];
        try {
            for (int idx = 0; idx < presentRulesets.length; ++idx) {
                String set = presentRulesets[idx];
                this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                RuleSetReferenceId id = new RuleSetReferenceId(set);
                File ruleset = this.locator.getResourceAsFile(id.getRuleSetFileName(), this.getLocationTemp(set));
                if (null == ruleset) {
                    throw new MavenReportException("Could not resolve " + set);
                }
                sets[idx] = ruleset.getAbsolutePath();
            }
        }
        catch (ResourceNotFoundException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (FileResourceCreationException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        pmdConfiguration.setRuleSets(StringUtils.join((Object[])sets, (String)","));
        try {
            if (this.filesToProcess == null) {
                this.filesToProcess = this.getFilesToProcess();
            }
            if (this.filesToProcess.isEmpty() && !"java".equals(this.language)) {
                this.getLog().warn((CharSequence)"No files found to process. Did you add your additional source folders like javascript? (see also build-helper-maven-plugin)");
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Can't get file list", (Exception)e);
        }
        String encoding = this.getSourceEncoding();
        if (StringUtils.isEmpty((String)encoding) && !this.filesToProcess.isEmpty()) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            encoding = ReaderFactory.FILE_ENCODING;
        }
        pmdConfiguration.setSourceEncoding(encoding);
        ArrayList<FileDataSource> dataSources = new ArrayList<FileDataSource>(this.filesToProcess.size());
        for (File f : this.filesToProcess.keySet()) {
            dataSources.add(new FileDataSource(f));
        }
        try {
            this.getLog().debug((CharSequence)"Executing PMD...");
            PMD.processFiles((PMDConfiguration)pmdConfiguration, (RuleSetFactory)ruleSetFactory, dataSources, (RuleContext)ruleContext, Collections.emptyList());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("PMD finished. Found " + this.reportListener.getViolations().size() + " violations."));
            }
        }
        catch (Exception e) {
            String message = "Failure executing PMD: " + e.getLocalizedMessage();
            if (!this.skipPmdError) {
                throw new MavenReportException(message, e);
            }
            this.getLog().warn((CharSequence)message, (Throwable)e);
        }
        if (this.isXml() && this.reportListener != null) {
            this.writeNonHtml(this.reportListener.asReport());
        }
        if (this.benchmark) {
            PrintStream benchmarkFileStream = null;
            try {
                benchmarkFileStream = new PrintStream(this.benchmarkOutputFilename);
                new TextReport().generate(Benchmarker.values(), benchmarkFileStream);
            }
            catch (FileNotFoundException fnfe) {
                this.getLog().error((CharSequence)("Unable to generate benchmark file: " + this.benchmarkOutputFilename), (Throwable)fnfe);
            }
            finally {
                if (null != benchmarkFileStream) {
                    benchmarkFileStream.close();
                }
            }
        }
    }

    private Report generateReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        PmdReportGenerator renderer = new PmdReportGenerator(this.getLog(), sink, PmdReport.getBundle(locale), this.aggregate);
        renderer.setFiles(this.filesToProcess);
        renderer.setViolations(this.reportListener.getViolations());
        try {
            renderer.beginDocument();
            renderer.render();
            renderer.endDocument();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failure creating the report: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return this.reportListener.asReport();
    }

    protected String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        if (!(loc = loc.replaceAll("[\\?\\:\\&\\=\\%]", "_")).endsWith(".xml")) {
            loc = loc + ".xml";
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    private void writeNonHtml(Report report) throws MavenReportException {
        Renderer r = this.createRenderer();
        if (r == null) {
            return;
        }
        OutputStreamWriter writer = null;
        FileOutputStream tStream = null;
        try {
            this.targetDirectory.mkdirs();
            File targetFile = new File(this.targetDirectory, "pmd." + this.format);
            tStream = new FileOutputStream(targetFile);
            writer = new OutputStreamWriter((OutputStream)tStream, this.getOutputEncoding());
            r.setWriter((Writer)writer);
            r.start();
            r.renderFileReport(report);
            r.end();
            ((Writer)writer).close();
            if (this.includeXmlInSite) {
                File siteDir = this.getReportOutputDirectory();
                siteDir.mkdirs();
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "pmd." + this.format));
            }
        }
        catch (IOException ioe) {
            try {
                throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                IOUtil.close(tStream);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        IOUtil.close((OutputStream)tStream);
    }

    public PMDConfiguration getPMDConfiguration() throws MavenReportException {
        PMDConfiguration configuration = new PMDConfiguration();
        LanguageVersion languageVersion = null;
        if (null != this.targetJdk) {
            languageVersion = LanguageVersion.findByTerseName((String)("java " + this.targetJdk));
            if (languageVersion == null) {
                throw new MavenReportException("Unsupported targetJdk value '" + this.targetJdk + "'.");
            }
        } else if ("javascript".equals(this.language) || "ecmascript".equals(this.language)) {
            languageVersion = LanguageVersion.ECMASCRIPT;
        }
        if (languageVersion != null) {
            this.getLog().debug((CharSequence)("Using language " + languageVersion));
            configuration.setDefaultLanguageVersion(languageVersion);
        }
        if (this.typeResolution) {
            try {
                List classpath = this.includeTests ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
                this.getLog().debug((CharSequence)("Using aux classpath: " + classpath));
                configuration.prependClasspath(StringUtils.join(classpath.iterator(), (String)File.pathSeparator));
            }
            catch (Exception e) {
                throw new MavenReportException(e.getMessage(), e);
            }
        }
        configuration.setBenchmark(this.benchmark);
        return configuration;
    }

    public String getOutputName() {
        return "pmd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pmd-report", locale, PmdReport.class.getClassLoader());
    }

    public final Renderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer(this.getOutputEncoding());
        } else if ("txt".equals(this.format)) {
            renderer = new TextRenderer();
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if ("html".equals(this.format)) {
            renderer = new HTMLRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).getConstructor(Properties.class).newInstance(new Properties());
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find PMD custom format " + this.format + ": " + e.getClass().getName(), e);
            }
        }
        return renderer;
    }
}

