/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.ViolationDetails;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPmdViolationCheckMojo<D>
extends AbstractMojo {
    private File targetDirectory;
    private boolean failOnViolation;
    private String language;
    protected boolean aggregate;
    private boolean verbose;
    protected MavenProject project;

    protected void executeCheck(String filename, String tagName, String key, int failurePriority) throws MojoFailureException, MojoExecutionException {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return;
        }
        if ("java".equals(this.language) || this.aggregate) {
            File outputFile = new File(this.targetDirectory, filename);
            if (outputFile.exists()) {
                Reader reader = null;
                try {
                    ViolationDetails<D> violations = this.getViolations(outputFile, failurePriority);
                    List<D> failures = violations.getFailureDetails();
                    List<D> warnings = violations.getWarningDetails();
                    if (this.verbose) {
                        this.printErrors(failures, warnings);
                    }
                    int failureCount = failures.size();
                    int warningCount = warnings.size();
                    String message = this.getMessage(failureCount, warningCount, key, outputFile);
                    if (failureCount > 0 && this.failOnViolation) {
                        throw new MojoFailureException(message);
                    }
                    this.getLog().info((CharSequence)message);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)((Object)e));
                }
                finally {
                    IOUtil.close(reader);
                }
            } else {
                throw new MojoFailureException("Unable to perform check, unable to find " + outputFile);
            }
        }
    }

    private ViolationDetails<D> getViolations(File analysisFile, int failurePriority) throws XmlPullParserException, IOException {
        ArrayList<D> failures = new ArrayList<D>();
        ArrayList<D> warnings = new ArrayList<D>();
        List<D> violations = this.getErrorDetails(analysisFile);
        for (D violation : violations) {
            int priority = this.getPriority(violation);
            if (priority <= failurePriority) {
                failures.add(violation);
                continue;
            }
            warnings.add(violation);
        }
        ViolationDetails details = this.newViolationDetailsInstance();
        details.setFailureDetails(failures);
        details.setWarningDetails(warnings);
        return details;
    }

    protected abstract int getPriority(D var1);

    protected abstract ViolationDetails<D> newViolationDetailsInstance();

    protected void printErrors(List<D> failures, List<D> warnings) {
        for (D warning : warnings) {
            this.printError(warning, "Warning");
        }
        for (D failure : failures) {
            this.printError(failure, "Failure");
        }
    }

    private String getMessage(int failureCount, int warningCount, String key, File outputFile) {
        StringBuffer message = new StringBuffer();
        if (failureCount > 0 || warningCount > 0) {
            if (failureCount > 0) {
                message.append("You have " + failureCount + " " + key + (failureCount > 1 ? "s" : ""));
            }
            if (warningCount > 0) {
                if (failureCount > 0) {
                    message.append(" and ");
                } else {
                    message.append("You have ");
                }
                message.append(warningCount + " warning" + (warningCount > 1 ? "s" : ""));
            }
            message.append(". For more details see:").append(outputFile.getAbsolutePath());
        }
        return message.toString();
    }

    protected abstract void printError(D var1, String var2);

    protected abstract List<D> getErrorDetails(File var1) throws XmlPullParserException, IOException;
}

