/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.AbstractPmdViolationCheckMojo;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CpdViolationCheckMojo
extends AbstractPmdViolationCheckMojo {
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.executeCheck("cpd.xml", "duplication", "CPD duplication", 10);
        }
    }

    protected void printError(Map item, String severity) {
        String lines = (String)item.get("lines");
        StringBuffer buff = new StringBuffer(100);
        buff.append("CPD " + severity + ": Found ");
        buff.append(lines).append(" lines of duplicated code at locations:");
        this.getLog().info((CharSequence)buff.toString());
        buff.setLength(0);
        buff.append("    ");
        Map file = (Map)item.get("file");
        buff.append(file.get("path"));
        buff.append(" line ").append(file.get("line"));
        this.getLog().info((CharSequence)buff.toString());
        buff.setLength(0);
        buff.append("    ");
        file = (Map)item.get("file1");
        buff.append(file.get("path"));
        buff.append(" line ").append(file.get("line"));
        this.getLog().info((CharSequence)buff.toString());
        Map codefrag = (Map)item.get("codefragment");
        String codefragstr = (String)codefrag.get("text");
        this.getLog().debug((CharSequence)("CPD " + severity + ": Code Fragment "));
        this.getLog().debug((CharSequence)codefragstr);
    }

    protected Map getErrorDetails(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int attributeCount = 0;
        HashMap<String, Object> msgs = new HashMap<String, Object>();
        attributeCount = xpp.getAttributeCount();
        for (int index = 0; index < attributeCount; ++index) {
            msgs.put(xpp.getAttributeName(index), xpp.getAttributeValue(index));
        }
        int tp = xpp.next();
        while (tp != 3) {
            switch (tp) {
                case 4: {
                    msgs.put("text", xpp.getText().trim());
                    break;
                }
                case 2: {
                    String nm = xpp.getName();
                    if (msgs.containsKey(nm)) {
                        int cnt = 1;
                        while (msgs.containsKey(nm + cnt)) {
                            ++cnt;
                        }
                        nm = nm + cnt;
                    }
                    msgs.put(nm, this.getErrorDetails(xpp));
                    break;
                }
            }
            tp = xpp.next();
        }
        return msgs;
    }
}

