/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractPmdReport
extends AbstractMavenReport {
    protected File targetDirectory;
    protected String outputDirectory;
    private SiteRenderer siteRenderer;
    protected MavenProject project;
    protected String format = "xml";
    private boolean linkXRef;
    private File xrefLocation;
    private File xrefTestLocation;
    private String[] excludes;
    private String[] includes;
    private List compileSourceRoots;
    private List testSourceRoots;
    private List excludeRoots;
    protected boolean includeTests;
    protected boolean aggregate;
    protected List reactorProjects;

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String constructXRefLocation(boolean test) {
        String location = null;
        if (this.linkXRef) {
            File xrefLoc = test ? this.xrefTestLocation : this.xrefLocation;
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory, (String)xrefLoc.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + xrefLoc.getName();
            if (xrefLoc.exists()) {
                location = relativePath;
            } else {
                Iterator reports = this.project.getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin plugin = (ReportPlugin)reports.next();
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    protected Map getFilesToProcess() throws IOException {
        File sroot;
        String root;
        String testXref;
        String sourceXref = this.constructXRefLocation(false);
        String string = testXref = this.includeTests ? this.constructXRefLocation(true) : "";
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return Collections.EMPTY_MAP;
        }
        if (this.excludeRoots == null) {
            this.excludeRoots = Collections.EMPTY_LIST;
        }
        ArrayList<File> excludeRootFiles = new ArrayList<File>(this.excludeRoots.size());
        Iterator it = this.excludeRoots.iterator();
        while (it.hasNext()) {
            String root2 = (String)it.next();
            File file = new File(root2);
            if (!file.exists() || !file.isDirectory()) continue;
            excludeRootFiles.add(file);
        }
        ArrayList<PmdFileInfo> directories = new ArrayList<PmdFileInfo>();
        Iterator i = this.compileSourceRoots.iterator();
        while (i.hasNext()) {
            root = (String)i.next();
            sroot = new File(root);
            directories.add(new PmdFileInfo(this.project, sroot, sourceXref));
        }
        if (this.includeTests) {
            i = this.testSourceRoots.iterator();
            while (i.hasNext()) {
                root = (String)i.next();
                sroot = new File(root);
                directories.add(new PmdFileInfo(this.project, sroot, testXref));
            }
        }
        if (this.aggregate) {
            i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                File sroot2;
                String root3;
                MavenProject localProject = (MavenProject)i.next();
                Iterator i2 = localProject.getCompileSourceRoots().iterator();
                while (i2.hasNext()) {
                    root3 = (String)i2.next();
                    sroot2 = new File(root3);
                    directories.add(new PmdFileInfo(localProject, sroot2, sourceXref));
                }
                if (!this.includeTests) continue;
                i2 = localProject.getTestCompileSourceRoots().iterator();
                while (i2.hasNext()) {
                    root3 = (String)i2.next();
                    sroot2 = new File(root3);
                    directories.add(new PmdFileInfo(localProject, sroot2, testXref));
                }
            }
        }
        String excluding = this.getIncludeExcludeString(this.excludes);
        String including = this.getIncludeExcludeString(this.includes);
        TreeMap files = new TreeMap();
        if ("".equals(including)) {
            including = "**/*.java";
        }
        StringBuffer excludesStr = new StringBuffer();
        if (StringUtils.isNotEmpty((String)excluding)) {
            excludesStr.append(excluding);
        }
        String[] defaultExcludes = FileUtils.getDefaultExcludes();
        for (int i2 = 0; i2 < defaultExcludes.length; ++i2) {
            if (excludesStr.length() > 0) {
                excludesStr.append(",");
            }
            excludesStr.append(defaultExcludes[i2]);
        }
        this.getLog().debug((CharSequence)("Excluded files: '" + excludesStr + "'"));
        Iterator it2 = directories.iterator();
        while (it2.hasNext()) {
            PmdFileInfo finfo = (PmdFileInfo)it2.next();
            File sourceDirectory = finfo.getSourceDirectory();
            if (!sourceDirectory.exists() || !sourceDirectory.isDirectory() || excludeRootFiles.contains(sourceDirectory)) continue;
            List newfiles = FileUtils.getFiles((File)sourceDirectory, (String)including, (String)excludesStr.toString());
            Iterator it22 = newfiles.iterator();
            while (it22.hasNext()) {
                files.put(it22.next(), finfo);
            }
        }
        return files;
    }

    private String getIncludeExcludeString(String[] arr) {
        StringBuffer str = new StringBuffer();
        if (arr != null) {
            for (int index = 0; index < arr.length; ++index) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(arr[index]);
            }
        }
        return str.toString();
    }

    protected boolean isHtml() {
        return "html".equals(this.format);
    }

    public boolean canGenerateReport() {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return false;
        }
        if ("xml".equals(this.format)) {
            return true;
        }
        try {
            Map filesToProcess = this.getFilesToProcess();
            if (filesToProcess.isEmpty()) {
                return false;
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        return true;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }
}

