/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.plugin.AbstractGeneratorMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.PluginHelpGenerator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

@Mojo(name="helpmojo", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class HelpGeneratorMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/plugin")
    protected File outputDirectory;
    @Parameter
    private String helpPackageName;
    @Component
    private VelocityComponent velocity;

    String getHelpPackageName() {
        String packageName = null;
        if (StringUtils.isNotBlank((String)this.helpPackageName)) {
            packageName = this.helpPackageName;
        }
        if (packageName == null) {
            packageName = this.project.getGroupId() + "." + this.project.getArtifactId();
            packageName = packageName.replace("-", "_");
            String[] packageItems = packageName.split("\\.");
            packageName = Arrays.stream(packageItems).map(this::prefixSpecialCase).collect(Collectors.joining("."));
        }
        return packageName;
    }

    private String prefixSpecialCase(String name) {
        if (SourceVersion.isKeyword(name) || !Character.isJavaIdentifierStart(name.charAt(0))) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    protected void generate() throws MojoExecutionException {
        PluginHelpGenerator pluginHelpGenerator = new PluginHelpGenerator().setMavenProject(this.project).setHelpPackageName(this.getHelpPackageName()).setGoalPrefix(this.goalPrefix).setVelocityComponent(this.velocity);
        try {
            pluginHelpGenerator.execute(this.outputDirectory);
        }
        catch (GeneratorException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (!this.project.getCompileSourceRoots().contains(this.outputDirectory.getAbsolutePath())) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }
}

