/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.linkcheck;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.linkcheck.HttpBean;
import org.apache.maven.doxia.linkcheck.LinkCheck;
import org.apache.maven.doxia.linkcheck.LinkCheckException;
import org.apache.maven.doxia.linkcheck.model.LinkcheckModel;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.linkcheck.LinkcheckReportGenerator;
import org.apache.maven.plugins.linkcheck.SiteInvoker;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="linkcheck")
public class LinkcheckReport
extends AbstractMavenReport {
    @Component
    private I18N i18n;
    @Component
    private LinkCheck linkCheck;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="linkcheck.offline", defaultValue="${settings.offline}", required=true)
    private boolean offline;
    @Parameter(defaultValue="true")
    private boolean httpFollowRedirect;
    @Parameter(defaultValue="${project.build.directory}/linkcheck/linkcheck.cache", required=true)
    protected File linkcheckCache;
    @Parameter(defaultValue="${project.build.directory}/linkcheck/linkcheck.xml", required=true)
    protected File linkcheckOutput;
    @Parameter(defaultValue="head", required=true)
    private String httpMethod;
    @Parameter
    private Integer[] excludedHttpStatusErrors;
    @Parameter
    private Integer[] excludedHttpStatusWarnings;
    @Parameter
    private String[] excludedPages;
    @Parameter
    private String[] excludedLinks;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="httpClientParameters")
    private Properties httpClientParameters;
    @Parameter(property="timeout", defaultValue="2000")
    private int timeout;
    @Parameter(property="linkcheck.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="linkcheck.forceSite", defaultValue="true")
    private boolean forceSite;
    @Parameter(property="linkcheck.baseURL", defaultValue="${project.url}")
    private String baseURL;
    private LinkcheckModel result;
    protected static final String ICON_SUCCESS = "images/icon_success_sml.gif";
    protected static final String ICON_WARNING = "images/icon_warning_sml.gif";
    protected static final String ICON_INFO = "images/icon_info_sml.gif";
    protected static final String ICON_ERROR = "images/icon_error_sml.gif";
    private static final String pluginResourcesBase = "org/apache/maven/plugin/linkcheck";
    private static final String[] resourceNames = new String[]{"images/icon_success_sml.gif", "images/icon_warning_sml.gif", "images/icon_info_sml.gif", "images/icon_error_sml.gif"};

    public String getDescription(Locale locale) {
        return this.i18n.getString("linkcheck-report", locale, "report.linkcheck.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString("linkcheck-report", locale, "report.linkcheck.name");
    }

    public String getOutputName() {
        return "linkcheck";
    }

    public boolean canGenerateReport() {
        return !this.skip;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        this.checkEncoding();
        try {
            this.result = this.executeLinkCheck(this.getBasedir());
        }
        catch (LinkCheckException e) {
            throw new MojoExecutionException("LinkCheckException: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.result == null) {
            this.getLog().debug((CharSequence)"Calling execute()");
            try {
                this.execute();
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException("MojoExecutionException: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (this.result != null) {
            this.generateReport(locale, this.result);
            this.result = null;
        }
    }

    private void checkEncoding() {
        if (StringUtils.isEmpty((String)this.encoding)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
    }

    private File getBasedir() throws MojoExecutionException {
        File basedir;
        if (this.forceSite) {
            basedir = new File(this.linkcheckOutput.getParentFile(), "tmpsite");
            basedir.mkdirs();
            List documents = null;
            try {
                documents = FileUtils.getFiles((File)basedir, (String)"**/*.html", null);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
                this.getLog().debug((Throwable)e);
            }
            if (documents == null || documents != null && documents.size() == 0) {
                this.getLog().info((CharSequence)"Invoking the maven-site-plugin to ensure that all files are generated...");
                try {
                    SiteInvoker invoker = new SiteInvoker(this.localRepository, this.getLog());
                    invoker.invokeSite(this.project, basedir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
                }
            }
        } else {
            this.getLog().warn((CharSequence)"The number of documents analyzed by Linkcheck could differ from the actual number of documents!");
            basedir = this.outputDirectory;
            basedir.mkdirs();
        }
        return basedir;
    }

    private LinkcheckModel executeLinkCheck(File basedir) throws LinkCheckException {
        Proxy proxy;
        this.linkCheck.setOnline(!this.offline);
        this.linkCheck.setBasedir(basedir);
        this.linkCheck.setBaseURL(this.baseURL);
        this.linkCheck.setReportOutput(this.linkcheckOutput);
        this.linkCheck.setLinkCheckCache(this.linkcheckCache);
        this.linkCheck.setExcludedLinks(this.excludedLinks);
        this.linkCheck.setExcludedPages(this.getExcludedPages());
        this.linkCheck.setExcludedHttpStatusErrors(LinkcheckReport.asIntArray(this.excludedHttpStatusErrors));
        this.linkCheck.setExcludedHttpStatusWarnings(LinkcheckReport.asIntArray(this.excludedHttpStatusWarnings));
        this.linkCheck.setEncoding(StringUtils.isNotEmpty((String)this.encoding) ? this.encoding : "UTF-8");
        HttpBean bean = new HttpBean();
        bean.setMethod(this.httpMethod);
        bean.setFollowRedirects(this.httpFollowRedirect);
        bean.setTimeout(this.timeout);
        if (this.httpClientParameters != null) {
            bean.setHttpClientParameters(this.httpClientParameters);
        }
        if ((proxy = this.settings.getActiveProxy()) != null) {
            bean.setProxyHost(proxy.getHost());
            bean.setProxyPort(proxy.getPort());
            bean.setProxyUser(proxy.getUsername());
            bean.setProxyPassword(proxy.getPassword());
        }
        this.linkCheck.setHttp(bean);
        return this.linkCheck.execute();
    }

    private String[] getExcludedPages() {
        ArrayList<String> pagesToExclude = this.excludedPages != null ? new ArrayList<String>(Arrays.asList(this.excludedPages)) : new ArrayList();
        pagesToExclude.add(this.getOutputName() + ".html");
        return pagesToExclude.toArray(new String[pagesToExclude.size()]);
    }

    private void generateReport(Locale locale, LinkcheckModel linkcheckModel) {
        LinkcheckReportGenerator reportGenerator = new LinkcheckReportGenerator(this.i18n);
        reportGenerator.setExcludedHttpStatusErrors(this.excludedHttpStatusErrors);
        reportGenerator.setExcludedHttpStatusWarnings(this.excludedHttpStatusWarnings);
        reportGenerator.setExcludedLinks(this.excludedLinks);
        reportGenerator.setExcludedPages(this.excludedPages);
        reportGenerator.setHttpFollowRedirect(this.httpFollowRedirect);
        reportGenerator.setHttpMethod(this.httpMethod);
        reportGenerator.setOffline(this.offline);
        reportGenerator.generateReport(locale, linkcheckModel, this.getSink());
        this.closeReport();
        this.copyStaticResources();
    }

    private void copyStaticResources() {
        try {
            this.getLog().debug((CharSequence)"Copying static linkcheck resources.");
            for (String resourceName : resourceNames) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/plugin/linkcheck/" + resourceName);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.getReportOutputDirectory(), resourceName));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to copy icons for linkcheck report.");
            this.getLog().debug((Throwable)e);
        }
    }

    private static int[] asIntArray(Integer[] array) {
        if (array == null) {
            return null;
        }
        int[] newArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }
}

