/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jlink;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jlink.AbstractJLinkMojo;
import org.apache.maven.plugins.jlink.JLinkExecutor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.languages.java.version.JavaVersion;

@Mojo(name="jlink", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class JLinkMojo
extends AbstractJLinkMojo {
    @Component
    private LocationManager locationManager;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="false")
    private boolean stripDebug;
    @Parameter
    private Integer compress;
    @Parameter
    private String launcher;
    @Parameter
    private List<String> addOptions;
    @Parameter
    private List<String> limitModules;
    @Parameter
    private List<String> addModules;
    @Parameter
    private String pluginModulePath;
    @Parameter(defaultValue="${project.build.directory}/maven-jlink", required=true, readonly=true)
    private File outputDirectoryImage;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter
    private String endian;
    @Parameter
    private List<String> modulePaths;
    @Parameter(defaultValue="false")
    private boolean bindServices;
    @Parameter
    private String disablePlugin;
    @Parameter(defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(defaultValue="false")
    private boolean noManPages;
    @Parameter
    private List<String> suggestProviders;
    @Parameter
    private List<String> includeLocales;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    @Parameter
    private File sourceJdkModules;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.failIfParametersAreNotInTheirValidValueRanges();
        this.setOutputDirectoryImage();
        this.ifOutputDirectoryExistsDelteIt();
        JLinkExecutor jLinkExec = this.getExecutor();
        ArrayList<String> modulesToAdd = new ArrayList<String>();
        if (this.addModules != null) {
            modulesToAdd.addAll(this.addModules);
        }
        jLinkExec.addAllModules(modulesToAdd);
        ArrayList<String> pathsOfModules = new ArrayList<String>();
        if (this.modulePaths != null) {
            pathsOfModules.addAll(this.modulePaths);
        }
        for (Map.Entry<String, File> item : this.getModulePathElements().entrySet()) {
            this.getLog().info((CharSequence)(" -> module: " + item.getKey() + " ( " + item.getValue().getPath() + " )"));
            modulesToAdd.add(item.getKey());
            pathsOfModules.add(item.getValue().getPath());
        }
        jLinkExec.getJmodsFolder(this.sourceJdkModules).ifPresent(jmodsFolder -> pathsOfModules.add(jmodsFolder.getAbsolutePath()));
        jLinkExec.addAllModulePaths(pathsOfModules);
        List<String> jlinkArgs = this.createJlinkArgs(pathsOfModules, modulesToAdd);
        try {
            jLinkExec.executeJlink(jlinkArgs);
        }
        catch (IllegalStateException e) {
            throw new MojoFailureException("Unable to find jlink command: " + e.getMessage(), (Throwable)e);
        }
        File createZipArchiveFromImage = this.createZipArchiveFromImage(this.buildDirectory, this.outputDirectoryImage);
        if (this.hasClassifier()) {
            this.projectHelper.attachArtifact(this.getProject(), "jlink", this.getClassifier(), createZipArchiveFromImage);
        } else {
            if (this.projectHasAlreadySetAnArtifact()) {
                throw new MojoExecutionException("You have to use a classifier to attach supplemental artifacts to the project instead of replacing them.");
            }
            this.getProject().getArtifact().setFile(createZipArchiveFromImage);
        }
    }

    private List<File> getCompileClasspathElements(MavenProject project) {
        ArrayList<File> list = new ArrayList<File>(project.getArtifacts().size() + 1);
        for (Artifact a : project.getArtifacts()) {
            this.getLog().debug((CharSequence)("Artifact: " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion()));
            list.add(a.getFile());
        }
        return list;
    }

    private Map<String, File> getModulePathElements() throws MojoFailureException {
        HashMap<String, File> modulepathElements = new HashMap<String, File>();
        try {
            List<File> dependencyArtifacts = this.getCompileClasspathElements(this.getProject());
            ResolvePathsRequest request = ResolvePathsRequest.ofFiles(dependencyArtifacts);
            Optional<Toolchain> toolchain = this.getToolchain();
            if (toolchain.isPresent() && toolchain.orElseThrow(NoSuchElementException::new) instanceof DefaultJavaToolChain) {
                Toolchain toolcahin1 = toolchain.orElseThrow(NoSuchElementException::new);
                request.setJdkHome((Object)new File(((DefaultJavaToolChain)toolcahin1).getJavaHome()));
            }
            ResolvePathsResult resolvePathsResult = this.locationManager.resolvePaths(request);
            for (Map.Entry entry : resolvePathsResult.getPathElements().entrySet()) {
                JavaModuleDescriptor descriptor = (JavaModuleDescriptor)entry.getValue();
                if (descriptor == null) {
                    String message = "The given dependency " + entry.getKey() + " does not have a module-info.java file. So it can't be linked.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoFailureException(message);
                }
                this.getLog().debug((CharSequence)(" module: " + descriptor.name() + " automatic: " + descriptor.isAutomatic()));
                if (modulepathElements.containsKey(descriptor.name())) {
                    this.getLog().warn((CharSequence)("The module name " + descriptor.name() + " does already exists."));
                }
                modulepathElements.put(descriptor.name(), (File)entry.getKey());
            }
            if (this.outputDirectory.exists()) {
                List<File> singletonList = Collections.singletonList(this.outputDirectory);
                ResolvePathsRequest singleModuls = ResolvePathsRequest.ofFiles(singletonList);
                ResolvePathsResult resolvePaths = this.locationManager.resolvePaths(singleModuls);
                for (Map.Entry entry : resolvePaths.getPathElements().entrySet()) {
                    JavaModuleDescriptor descriptor = (JavaModuleDescriptor)entry.getValue();
                    if (descriptor == null) {
                        String message = "The given project " + entry.getKey() + " does not contain a module-info.java file. So it can't be linked.";
                        this.getLog().error((CharSequence)message);
                        throw new MojoFailureException(message);
                    }
                    if (modulepathElements.containsKey(descriptor.name())) {
                        this.getLog().warn((CharSequence)("The module name " + descriptor.name() + " does already exists."));
                    }
                    modulepathElements.put(descriptor.name(), (File)entry.getKey());
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException(e.getMessage());
        }
        return modulepathElements;
    }

    private JLinkExecutor getExecutor() {
        return this.getJlinkExecutor();
    }

    private boolean projectHasAlreadySetAnArtifact() {
        if (this.getProject().getArtifact().getFile() != null) {
            return this.getProject().getArtifact().getFile().isFile();
        }
        return false;
    }

    protected boolean hasClassifier() {
        boolean result = false;
        if (this.getClassifier() != null && !this.getClassifier().isEmpty()) {
            result = true;
        }
        return result;
    }

    private File createZipArchiveFromImage(File outputDirectory, File outputDirectoryImage) throws MojoExecutionException {
        this.zipArchiver.addDirectory(outputDirectoryImage);
        File resultArchive = this.getArchiveFile(outputDirectory, this.finalName, this.getClassifier(), "zip");
        this.zipArchiver.setDestFile(resultArchive);
        try {
            this.zipArchiver.createArchive();
        }
        catch (IOException | ArchiverException e) {
            this.getLog().error((CharSequence)e.getMessage(), e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return resultArchive;
    }

    private void failIfParametersAreNotInTheirValidValueRanges() throws MojoFailureException {
        if (this.compress != null && (this.compress < 0 || this.compress > 2)) {
            String message = "The given compress parameters " + this.compress + " is not in the valid value range from 0..2";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        if (this.endian != null && !"big".equals(this.endian) && !"little".equals(this.endian)) {
            String message = "The given endian parameter " + this.endian + " does not contain one of the following values: 'little' or 'big'.";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        if (this.addOptions != null && !this.addOptions.isEmpty()) {
            this.requireJdk14();
        }
    }

    private void requireJdk14() throws MojoFailureException {
        Optional<Toolchain> optToolchain = this.getToolchain();
        String java14reqMsg = "parameter 'addOptions' needs at least a Java 14 runtime or a Java 14 toolchain.";
        if (optToolchain.isPresent()) {
            Toolchain toolchain = optToolchain.orElseThrow(NoSuchElementException::new);
            if (!(toolchain instanceof ToolchainPrivate)) {
                this.getLog().warn((CharSequence)"Unable to check toolchain java version.");
                return;
            }
            ToolchainPrivate toolchainPrivate = (ToolchainPrivate)toolchain;
            if (!toolchainPrivate.matchesRequirements(Collections.singletonMap("jdk", "14"))) {
                throw new MojoFailureException(java14reqMsg);
            }
        } else if (!JavaVersion.JAVA_VERSION.isAtLeast("14")) {
            throw new MojoFailureException(java14reqMsg);
        }
    }

    private void setOutputDirectoryImage() {
        if (this.hasClassifier()) {
            File classifiersDirectory = new File(this.outputDirectoryImage, "classifiers");
            this.outputDirectoryImage = new File(classifiersDirectory, this.classifier);
        } else {
            this.outputDirectoryImage = new File(this.outputDirectoryImage, "default");
        }
    }

    private void ifOutputDirectoryExistsDelteIt() throws MojoExecutionException {
        if (this.outputDirectoryImage.exists()) {
            try {
                this.getLog().debug((CharSequence)("Deleting existing " + this.outputDirectoryImage.getAbsolutePath()));
                FileUtils.forceDelete((File)this.outputDirectoryImage);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"IOException", (Throwable)e);
                throw new MojoExecutionException("Failure during deletion of " + this.outputDirectoryImage.getAbsolutePath() + " occured.");
            }
        }
    }

    private List<String> createJlinkArgs(Collection<String> pathsOfModules, Collection<String> modulesToAdd) {
        CharSequence sb;
        ArrayList<CharSequence> jlinkArgs = new ArrayList<CharSequence>();
        if (this.stripDebug) {
            jlinkArgs.add("--strip-debug");
        }
        if (this.bindServices) {
            jlinkArgs.add("--bind-services");
        }
        if (this.endian != null) {
            jlinkArgs.add("--endian");
            jlinkArgs.add(this.endian);
        }
        if (this.ignoreSigningInformation) {
            jlinkArgs.add("--ignore-signing-information");
        }
        if (this.compress != null) {
            jlinkArgs.add("--compress");
            jlinkArgs.add(this.compress + "");
        }
        if (this.launcher != null) {
            jlinkArgs.add("--launcher");
            jlinkArgs.add(this.launcher);
        }
        if (this.addOptions != null && !this.addOptions.isEmpty()) {
            jlinkArgs.add("--add-options");
            jlinkArgs.add(String.format("\"%s\"", String.join((CharSequence)" ", this.addOptions)));
        }
        if (this.disablePlugin != null) {
            jlinkArgs.add("--disable-plugin");
            jlinkArgs.add(this.disablePlugin);
        }
        if (pathsOfModules != null) {
            jlinkArgs.add("--module-path");
            jlinkArgs.add(this.getPlatformDependSeparateList(pathsOfModules).replace("\\", "\\\\"));
        }
        if (this.noHeaderFiles) {
            jlinkArgs.add("--no-header-files");
        }
        if (this.noManPages) {
            jlinkArgs.add("--no-man-pages");
        }
        if (this.hasSuggestProviders()) {
            jlinkArgs.add("--suggest-providers");
            sb = this.getCommaSeparatedList(this.suggestProviders);
            jlinkArgs.add(sb);
        }
        if (this.hasLimitModules()) {
            jlinkArgs.add("--limit-modules");
            sb = this.getCommaSeparatedList(this.limitModules);
            jlinkArgs.add(sb);
        }
        if (!modulesToAdd.isEmpty()) {
            jlinkArgs.add("--add-modules");
            sb = this.getCommaSeparatedList(modulesToAdd);
            jlinkArgs.add(((String)sb).replace("\\", "\\\\"));
        }
        if (this.hasIncludeLocales()) {
            jlinkArgs.add("--add-modules");
            jlinkArgs.add("jdk.localedata");
            jlinkArgs.add("--include-locales");
            sb = this.getCommaSeparatedList(this.includeLocales);
            jlinkArgs.add(sb);
        }
        if (this.pluginModulePath != null) {
            jlinkArgs.add("--plugin-module-path");
            sb = this.convertSeparatedModulePathToPlatformSeparatedModulePath(this.pluginModulePath);
            jlinkArgs.add(((StringBuilder)sb).toString().replace("\\", "\\\\"));
        }
        if (this.buildDirectory != null) {
            jlinkArgs.add("--output");
            jlinkArgs.add(this.outputDirectoryImage.getAbsolutePath());
        }
        if (this.verbose) {
            jlinkArgs.add("--verbose");
        }
        return Collections.unmodifiableList(jlinkArgs);
    }

    private boolean hasIncludeLocales() {
        return this.includeLocales != null && !this.includeLocales.isEmpty();
    }

    private boolean hasSuggestProviders() {
        return this.suggestProviders != null && !this.suggestProviders.isEmpty();
    }

    private boolean hasLimitModules() {
        return this.limitModules != null && !this.limitModules.isEmpty();
    }

    @Override
    protected String getClassifier() {
        return this.classifier;
    }
}

