/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactInstallerException;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;

@Mojo(name="install-file", projectRequired=false, aggregator=true)
public class InstallFileMojo
implements org.apache.maven.api.plugin.Mojo {
    private static final String TAR = "tar.";
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*[](){},";
    @Inject
    private Log log;
    @Inject
    private Session session;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="file", required=true)
    private Path file;
    @Parameter(property="javadoc")
    private Path javadoc;
    @Parameter(property="sources")
    private Path sources;
    @Parameter(property="pomFile")
    private Path pomFile;
    @Parameter(property="generatePom")
    private Boolean generatePom;
    @Parameter(property="localRepositoryPath")
    private Path localRepositoryPath;

    public void execute() {
        Path deployedPom;
        if (!Files.exists(this.file, new LinkOption[0])) {
            String message = "The specified file '" + String.valueOf(this.file) + "' does not exist";
            this.log.error((CharSequence)message);
            throw new MojoException(message);
        }
        Session session = this.session;
        ArrayList<ProducedArtifact> installableArtifacts = new ArrayList<ProducedArtifact>();
        if (this.localRepositoryPath != null) {
            session = session.withLocalRepository(session.createLocalRepository(this.localRepositoryPath));
            this.log.debug((CharSequence)("localRepoPath: " + String.valueOf(this.localRepositoryPath)));
        }
        Path temporaryPom = null;
        if (this.pomFile != null) {
            deployedPom = this.pomFile;
            this.processModel(this.readModel(deployedPom));
        } else if (!Boolean.TRUE.equals(this.generatePom)) {
            temporaryPom = this.readingPomFromJarFile();
            deployedPom = temporaryPom;
            if (deployedPom != null) {
                this.log.debug((CharSequence)"Using JAR embedded POM as pomFile");
            }
        } else {
            deployedPom = null;
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        if (!(this.isValidId(this.groupId) && this.isValidId(this.artifactId) && this.isValidVersion(this.version))) {
            throw new MojoException("The artifact information is not valid: uses invalid characters.");
        }
        boolean isFilePom = this.classifier == null && "pom".equals(this.packaging);
        ProducedArtifact artifact = session.createProducedArtifact(this.groupId, this.artifactId, this.version, this.classifier, isFilePom ? "pom" : this.getExtension(this.file), this.packaging);
        if (this.file.equals(this.getLocalRepositoryFile((Artifact)artifact))) {
            throw new MojoException("Cannot install artifact. Artifact is already in the local repository.\n\nFile in question is: " + String.valueOf(this.file) + "\n");
        }
        ArtifactManager artifactManager = (ArtifactManager)session.getService(ArtifactManager.class);
        artifactManager.setPath(artifact, this.file);
        installableArtifacts.add(artifact);
        ProducedArtifact pomArtifact = null;
        if (!isFilePom) {
            pomArtifact = session.createProducedArtifact(this.groupId, this.artifactId, this.version, null, "pom", null);
            if (deployedPom != null) {
                artifactManager.setPath(pomArtifact, deployedPom);
                installableArtifacts.add(pomArtifact);
            } else {
                deployedPom = temporaryPom = this.generatePomFile();
                artifactManager.setPath(pomArtifact, deployedPom);
                if (Boolean.TRUE.equals(this.generatePom) || this.generatePom == null && !Files.exists(this.getLocalRepositoryFile((Artifact)pomArtifact), new LinkOption[0])) {
                    this.log.debug((CharSequence)"Installing generated POM");
                    installableArtifacts.add(pomArtifact);
                } else if (this.generatePom == null) {
                    this.log.debug((CharSequence)"Skipping installation of generated POM, already present in local repository");
                }
            }
        }
        if (this.sources != null) {
            ProducedArtifact sourcesArtifact = session.createProducedArtifact(this.groupId, this.artifactId, this.version, "sources", "jar", null);
            artifactManager.setPath(sourcesArtifact, this.sources);
            installableArtifacts.add(sourcesArtifact);
        }
        if (this.javadoc != null) {
            ProducedArtifact javadocArtifact = session.createProducedArtifact(this.groupId, this.artifactId, this.version, "javadoc", "jar", null);
            artifactManager.setPath(javadocArtifact, this.javadoc);
            installableArtifacts.add(javadocArtifact);
        }
        try {
            ArtifactInstaller artifactInstaller = (ArtifactInstaller)session.getService(ArtifactInstaller.class);
            artifactInstaller.install(session, installableArtifacts);
        }
        catch (ArtifactInstallerException e) {
            throw new MojoException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (temporaryPom != null) {
                try {
                    Files.deleteIfExists(temporaryPom);
                }
                catch (IOException iOException) {}
                if (pomArtifact != null) {
                    artifactManager.setPath(pomArtifact, null);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path readingPomFromJarFile() {
        Pattern pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
        try (JarFile jarFile = new JarFile(this.file.toFile());){
            JarEntry entry = jarFile.stream().filter(e -> pomEntry.matcher(e.getName()).matches()).findFirst().orElse(null);
            if (entry != null) {
                this.log.debug((CharSequence)("Loading " + entry.getName()));
                try (InputStream pomInputStream = jarFile.getInputStream(entry);){
                    String base = this.file.getFileName().toString();
                    if (base.indexOf(46) > 0) {
                        base = base.substring(0, base.lastIndexOf(46));
                    }
                    Path pomFile = File.createTempFile(base, ".pom").toPath();
                    Files.copy(pomInputStream, pomFile, StandardCopyOption.REPLACE_EXISTING);
                    this.processModel(this.readModel(pomFile));
                    Path path = pomFile;
                    return path;
                }
            }
            this.log.info((CharSequence)("pom.xml not found in " + String.valueOf(this.file.getFileName())));
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Model readModel(Path pomFile) throws MojoException {
        Model model;
        block10: {
            InputStream is = Files.newInputStream(pomFile, new OpenOption[0]);
            try {
                model = (Model)((ModelXmlFactory)this.session.getService(ModelXmlFactory.class)).read(is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new MojoException("File not found " + String.valueOf(pomFile), (Throwable)e);
                }
                catch (IOException e) {
                    throw new MojoException("Error reading POM " + String.valueOf(pomFile), (Throwable)e);
                }
                catch (XmlReaderException e) {
                    throw new MojoException("Error parsing POM " + String.valueOf(pomFile), (Throwable)e);
                }
            }
            is.close();
        }
        return model;
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model generateModel() {
        return Model.newBuilder().modelVersion("4.0.0").groupId(this.groupId).artifactId(this.artifactId).version(this.version).packaging(this.packaging).description("POM was created from install:install-file").build();
    }

    private Path generatePomFile() throws MojoException {
        Model model = this.generateModel();
        try {
            Path pomFile = File.createTempFile("mvninstall", ".pom").toPath();
            try (BufferedWriter writer = Files.newBufferedWriter(pomFile, new OpenOption[0]);){
                ((ModelXmlFactory)this.session.getService(ModelXmlFactory.class)).write((Object)model, (Writer)writer);
            }
            return pomFile;
        }
        catch (IOException e) {
            throw new MojoException("Error writing temporary POM file: " + e.getMessage(), (Throwable)e);
        }
    }

    private Path getLocalRepositoryFile(Artifact artifact) {
        return this.session.getPathForLocalArtifact(artifact);
    }

    private String getExtension(Path file) {
        String filename = file.getFileName().toString();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            String ext = filename.substring(lastDot + 1);
            return filename.regionMatches(lastDot + 1 - TAR.length(), TAR, 0, TAR.length()) ? TAR + ext : ext;
        }
        return "";
    }

    private boolean isValidId(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        for (int i = version.length() - 1; i >= 0; --i) {
            if (ILLEGAL_VERSION_CHARS.indexOf(version.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

