/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="install-file", requiresProject=false, aggregator=true, threadSafe=true)
public class InstallFileMojo
extends AbstractMojo {
    private static final String LS = System.lineSeparator();
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom")
    private Boolean generatePom;
    @Parameter(property="localRepositoryPath")
    private File localRepositoryPath;
    private static final Predicate<String> IS_EMPTY = s -> Objects.isNull(s) || s.isEmpty();
    private static final Predicate<String> IS_POM_PACKAGING = "pom"::equals;
    private static final Pattern POM_ENTRY_PATTERN = Pattern.compile("META-INF/maven/.*/pom\\.xml");
    private static final Predicate<JarEntry> IS_POM_ENTRY = entry -> POM_ENTRY_PATTERN.matcher(entry.getName()).matches();
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*[](){},";

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactType artifactType;
        boolean isFilePom;
        if (!this.file.exists()) {
            String message = "The specified file '" + this.file.getPath() + "' does not exist";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
        if (this.localRepositoryPath != null) {
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(this.session.getRepositorySession());
            newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
            String contentType = newSession.getLocalRepository().getContentType();
            if ("enhanced".equals(contentType)) {
                contentType = "default";
            }
            LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(this.localRepositoryPath, contentType));
            newSession.setLocalRepositoryManager(localRepositoryManager);
            repositorySystemSession = newSession;
            this.getLog().debug((CharSequence)("localRepoPath: " + localRepositoryManager.getRepository().getBasedir()));
        }
        File temporaryPom = null;
        if (this.pomFile == null) {
            temporaryPom = this.readingPomFromJarFile();
            if (!Boolean.TRUE.equals(this.generatePom)) {
                this.pomFile = temporaryPom;
                this.getLog().debug((CharSequence)"Using JAR embedded POM as pomFile");
            }
        } else {
            this.processModel(this.readModel(this.pomFile));
        }
        if (Objects.isNull(this.groupId) || Objects.isNull(this.artifactId) || Objects.isNull(this.version) || Objects.isNull(this.packaging)) {
            throw new MojoExecutionException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        if (!(this.isValidId(this.groupId) && this.isValidId(this.artifactId) && this.isValidVersion(this.version))) {
            throw new MojoExecutionException("The artifact information is not valid: uses invalid characters.");
        }
        InstallRequest installRequest = new InstallRequest();
        boolean bl = isFilePom = Objects.isNull(this.classifier) && IS_POM_PACKAGING.test(this.packaging);
        if (!isFilePom && Objects.nonNull(artifactType = repositorySystemSession.getArtifactTypeRegistry().get(this.packaging)) && IS_EMPTY.test(this.classifier) && !IS_EMPTY.test(artifactType.getClassifier())) {
            this.classifier = artifactType.getClassifier();
        }
        Artifact mainArtifact = new DefaultArtifact(this.groupId, this.artifactId, this.classifier, isFilePom ? "pom" : this.getExtension(this.file), this.version).setFile(this.file);
        installRequest.addArtifact(mainArtifact);
        File artifactLocalFile = this.getLocalRepositoryFile(repositorySystemSession, mainArtifact);
        File pomLocalFile = this.getPomLocalRepositoryFile(repositorySystemSession, mainArtifact);
        if (this.file.equals(artifactLocalFile)) {
            throw new MojoFailureException("Cannot install artifact. Artifact is already in the local repository." + LS + LS + "File in question is: " + this.file + LS);
        }
        if (!IS_POM_PACKAGING.test(this.packaging)) {
            if (Objects.isNull(this.pomFile)) {
                if (Boolean.TRUE.equals(this.generatePom) || this.generatePom == null && !pomLocalFile.exists()) {
                    temporaryPom = this.generatePomFile();
                    this.getLog().debug((CharSequence)"Installing generated POM");
                    installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "", "pom", temporaryPom));
                } else if (this.generatePom == null) {
                    this.getLog().debug((CharSequence)"Skipping installation of generated POM, already present in local repository");
                }
            } else {
                installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "", "pom", this.pomFile));
            }
        }
        if (this.sources != null) {
            installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "sources", "jar", this.sources));
        }
        if (this.javadoc != null) {
            installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "javadoc", "jar", this.javadoc));
        }
        try {
            this.repositorySystem.install(repositorySystemSession, installRequest);
        }
        catch (InstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (temporaryPom != null) {
                temporaryPom.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File readingPomFromJarFile() throws MojoExecutionException {
        String base = this.file.getName();
        if (base.contains(".")) {
            base = base.substring(0, base.lastIndexOf(46));
        }
        try (JarFile jarFile = new JarFile(this.file);){
            JarEntry pomEntry = jarFile.stream().filter(IS_POM_ENTRY).findAny().orElse(null);
            if (Objects.isNull(pomEntry)) {
                this.getLog().info((CharSequence)("pom.xml not found in " + this.file.getName()));
                File file = null;
                return file;
            }
            Path tempPomFile = Files.createTempFile(base, ".pom", new FileAttribute[0]);
            Files.copy(jarFile.getInputStream(pomEntry), tempPomFile, StandardCopyOption.REPLACE_EXISTING);
            this.getLog().debug((CharSequence)("Loading " + pomEntry.getName()));
            this.processModel(this.readModel(tempPomFile.toFile()));
            File file = tempPomFile.toFile();
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        block10: {
            InputStream reader = Files.newInputStream(pomFile.toPath(), new OpenOption[0]);
            try {
                model = new MavenXpp3Reader().read(reader);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
                }
            }
            reader.close();
        }
        return model;
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription("POM was created from install:install-file");
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        block8: {
            Model model = this.generateModel();
            Path tempPomFile = Files.createTempFile("mvninstall", ".pom", new FileAttribute[0]);
            OutputStream writer = Files.newOutputStream(tempPomFile, new OpenOption[0]);
            try {
                new MavenXpp3Writer().write(writer, model);
                file = tempPomFile.toFile();
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
                }
            }
            writer.close();
        }
        return file;
    }

    private File getLocalRepositoryFile(RepositorySystemSession session, Artifact artifact) {
        String path = session.getLocalRepositoryManager().getPathForLocalArtifact(artifact);
        return new File(session.getLocalRepository().getBasedir(), path);
    }

    private File getPomLocalRepositoryFile(RepositorySystemSession session, Artifact artifact) {
        SubArtifact pomArtifact = new SubArtifact(artifact, "", "pom");
        String path = session.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)pomArtifact);
        return new File(session.getLocalRepository().getBasedir(), path);
    }

    private String getExtension(File file) {
        String filename = file.getName();
        if (filename.contains(".tar.")) {
            return "tar." + FileUtils.getExtension((String)filename);
        }
        return FileUtils.getExtension((String)filename);
    }

    private boolean isValidId(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        for (int i = version.length() - 1; i >= 0; --i) {
            if (ILLEGAL_VERSION_CHARS.indexOf(version.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

