/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.workspace;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class EclipseCodeFormatterProfile {
    private static final String ELT_PROFILE = "profile";
    private String content;
    private String profileName;

    public EclipseCodeFormatterProfile init(URL url, String profileName) throws MojoExecutionException {
        this.profileName = profileName;
        if (this.profileName == null) {
            this.loadDefaultProfileName(url);
        }
        this.convertFormatterToString(url);
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDefaultProfileName(URL url) throws MojoExecutionException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(url.openStream());
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
            Xpp3Dom[] existingProfiles = dom.getChildren(ELT_PROFILE);
            if (existingProfiles.length != 0) {
                Xpp3Dom firstProfile = existingProfiles[0];
                this.profileName = firstProfile.getAttribute("name");
            }
        }
        catch (XmlPullParserException e) {
            try {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantparseexisting", url.toString()));
                catch (IOException e2) {
                    throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantparseexisting", url.toString()));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
    }

    private void convertFormatterToString(URL url) throws MojoExecutionException {
        InputStream is = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            is = url.openStream();
            IOUtil.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantreadfile", url.toString()), (Exception)e);
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        this.content = os.toString();
    }

    public String getContent() {
        return this.content;
    }

    public String getProfileName() {
        return this.profileName;
    }
}

