/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.BuildCommand;
import org.apache.maven.plugin.eclipse.EclipseConfigFile;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.WorkspaceConfiguration;
import org.apache.maven.plugin.eclipse.reader.ReadWorkspaceLocations;
import org.apache.maven.plugin.eclipse.writers.EclipseAjdtWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseClasspathWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseManifestWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseOSGiManifestWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpApplicationXMLWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpComponent15Writer;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpComponentWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpFacetsWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpmodulesWriter;
import org.apache.maven.plugin.ide.AbstractIdeSupportMojo;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class EclipsePlugin
extends AbstractIdeSupportMojo {
    private static final String WEAVE_DEPENDENCY = "weaveDependency";
    private static final String WEAVE_DEPENDENCIES = "weaveDependencies";
    private static final String ASPECT_LIBRARY = "aspectLibrary";
    private static final String ASPECT_LIBRARIES = "aspectLibraries";
    private static final String ASPECT_DIRECTORY = "aspectDirectory";
    private static final String TEST_ASPECT_DIRECTORY = "testAspectDirectory";
    private static final String ASPECTJ_MAVEN_PLUGIN = "aspectj-maven-plugin";
    private static final String ORG_CODEHAUS_MOJO = "org.codehaus.mojo";
    private static final String DEFAULT_TEST_ASPECT_DIRECTORY = "src/test/aspect";
    private static final String DEFAULT_ASPECT_DIRECTORY = "src/main/aspect";
    private static final String NATURE_WST_FACET_CORE_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilderDependencyResolver";
    protected static final String BUILDER_WST_VALIDATION = "org.eclipse.wst.validation.validationbuilder";
    private static final String BUILDER_JDT_CORE_JAVA = "org.eclipse.jdt.core.javabuilder";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilder";
    private static final String BUILDER_WST_FACET = "org.eclipse.wst.common.project.facet.core.builder";
    private static final String BUILDER_PDE_MANIFEST = "org.eclipse.pde.ManifestBuilder";
    private static final String BUILDER_PDE_SCHEMA = "org.eclipse.pde.SchemaBuilder";
    private static final String BUILDER_AJDT_CORE_JAVA = "org.eclipse.ajdt.core.ajbuilder";
    private static final String NATURE_WST_MODULE_CORE_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final String NATURE_JDT_CORE_JAVA = "org.eclipse.jdt.core.javanature";
    private static final String NATURE_JEM_WORKBENCH_JAVA_EMF = "org.eclipse.jem.workbench.JavaEMFNature";
    private static final String NATURE_PDE_PLUGIN = "org.eclipse.pde.PluginNature";
    private static final String NATURE_AJDT_CORE_JAVA = "org.eclipse.ajdt.ui.ajnature";
    protected static final String COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    protected static final String ASPECTJ_RT_CONTAINER = "org.eclipse.ajdt.core.ASPECTJRT_CONTAINER";
    protected static final String REQUIRED_PLUGINS_CONTAINER = "org.eclipse.pde.core.requiredPlugins";
    public static final String[] WTP_SUPPORTED_VERSIONS = new String[]{"1.0", "1.5", "2.0", "R7", "none"};
    private static final String POM_ELT_ARTIFACT_ID = "artifactId";
    private static final String POM_ELT_GROUP_ID = "groupId";
    private List projectnatures;
    private List excludes;
    private List additionalProjectnatures;
    private Map additionalProjectFacets;
    private List buildcommands;
    private List additionalBuildcommands;
    private List classpathContainers;
    private boolean eclipseDownloadSources;
    private File eclipseProjectDir;
    private boolean useProjectReferences;
    private File buildOutputDirectory;
    private String wtpversion;
    private String wtpContextName;
    private boolean pde;
    private boolean ajdt;
    private File manifest;
    private EclipseConfigFile[] additionalConfig;
    private boolean addVersionToProjectName;
    private boolean addGroupIdToProjectName;
    private String projectNameTemplate;
    private float wtpVersionFloat;
    private boolean isJavaProject;
    private boolean wtpmanifest;
    private boolean wtpapplicationxml;
    private String wtpdefaultserver;
    private WorkspaceConfiguration workspaceConfiguration;
    private ResourceManager locator;
    protected File workspace;
    protected boolean limitProjectReferencesToWorkspace;
    private String ajdtVersion;

    protected final boolean isJavaProject() {
        return this.isJavaProject;
    }

    protected final boolean isPdeProject() {
        return this.pde;
    }

    public final List getBuildcommands() {
        return this.buildcommands;
    }

    public final void setBuildcommands(List buildcommands) {
        this.buildcommands = buildcommands;
    }

    public final File getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public final void setBuildOutputDirectory(File buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public final List getClasspathContainers() {
        return this.classpathContainers;
    }

    public final void setClasspathContainers(List classpathContainers) {
        this.classpathContainers = classpathContainers;
    }

    public final File getEclipseProjectDir() {
        return this.eclipseProjectDir;
    }

    public final void setEclipseProjectDir(File eclipseProjectDir) {
        this.eclipseProjectDir = eclipseProjectDir;
    }

    public final List getProjectnatures() {
        return this.projectnatures;
    }

    public final void setProjectnatures(List projectnatures) {
        this.projectnatures = projectnatures;
    }

    public final boolean getUseProjectReferences() {
        return this.useProjectReferences;
    }

    public final void setUseProjectReferences(boolean useProjectReferences) {
        this.useProjectReferences = useProjectReferences;
    }

    public final String getWtpversion() {
        return this.wtpversion;
    }

    public final void setWtpversion(String wtpversion) {
        this.wtpversion = wtpversion;
    }

    public final List getAdditionalBuildcommands() {
        return this.additionalBuildcommands;
    }

    public final void setAdditionalBuildcommands(List additionalBuildcommands) {
        this.additionalBuildcommands = additionalBuildcommands;
    }

    public final List getAdditionalProjectnatures() {
        return this.additionalProjectnatures;
    }

    public final void setAdditionalProjectnatures(List additionalProjectnatures) {
        this.additionalProjectnatures = additionalProjectnatures;
    }

    public final boolean isAddVersionToProjectName() {
        return this.addVersionToProjectName;
    }

    public final void setAddVersionToProjectName(boolean addVersionToProjectName) {
        this.addVersionToProjectName = addVersionToProjectName;
    }

    public final boolean isAddGroupIdToProjectName() {
        return this.addGroupIdToProjectName;
    }

    public final void setAddGroupIdToProjectName(boolean addGroupIdToProjectName) {
        this.addGroupIdToProjectName = addGroupIdToProjectName;
    }

    public final String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    public final void setProjectNameTemplate(String projectNameTemplate) {
        this.projectNameTemplate = projectNameTemplate;
    }

    public final boolean setup() throws MojoExecutionException {
        boolean ready = true;
        this.checkDeprecations();
        this.setProjectNameTemplate(IdeUtils.calculateProjectNameTemplate(this.getProjectNameTemplate(), this.isAddVersionToProjectName(), this.isAddGroupIdToProjectName(), this.getLog()));
        this.ajdt = this.enableAjdt(this.executedProject) && !this.ajdtVersion.equals("none");
        ready = this.validate();
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        this.isJavaProject = this.pde || "java".equals(artifactHandler.getLanguage()) && !"ear".equals(this.packaging);
        this.setupExtras();
        this.parseConfigurationOptions();
        if (this.projectnatures == null) {
            this.fillDefaultNatures(this.packaging);
        }
        if (this.additionalProjectnatures != null) {
            this.projectnatures.addAll(this.additionalProjectnatures);
        }
        if (this.buildcommands == null) {
            this.fillDefaultBuilders(this.packaging);
        } else {
            this.convertBuildCommandList(this.buildcommands);
        }
        if (this.additionalBuildcommands != null) {
            this.convertBuildCommandList(this.additionalBuildcommands);
            this.buildcommands.addAll(this.additionalBuildcommands);
        }
        if (this.classpathContainers == null) {
            this.fillDefaultClasspathContainers(this.packaging);
        } else {
            this.verifyClasspathContainerListIsComplete();
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        return ready;
    }

    protected final void convertBuildCommandList(List commands) {
        if (commands != null) {
            ListIterator i = commands.listIterator();
            while (i.hasNext()) {
                Object command = i.next();
                if (!(command instanceof String)) continue;
                command = new BuildCommand((String)command);
                i.set(command);
            }
        }
    }

    private void parseConfigurationOptions() {
        if ("R7".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 0.7f;
        } else if ("1.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 1.0f;
        } else if ("1.5".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 1.5f;
        } else if ("2.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 2.0f;
        }
        if (!"none".equalsIgnoreCase(this.wtpversion)) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wtpversion", this.wtpversion));
        }
    }

    protected void setupExtras() throws MojoExecutionException {
    }

    private void verifyClasspathContainerListIsComplete() {
        boolean containsJREContainer = false;
        Iterator iter = this.classpathContainers.iterator();
        while (iter.hasNext()) {
            Object classPathContainer = iter.next();
            if (classPathContainer == null || !classPathContainer.toString().startsWith(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER)) continue;
            containsJREContainer = true;
            break;
        }
        if (!containsJREContainer) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.missingjrecontainer"));
            this.classpathContainers.add(0, COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
        }
    }

    private boolean validate() throws MojoExecutionException {
        if (Arrays.binarySearch(WTP_SUPPORTED_VERSIONS, this.wtpversion) < 0) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.unsupportedwtp", new Object[]{this.wtpversion, StringUtils.join((Object[])WTP_SUPPORTED_VERSIONS, (String)" ")}));
        }
        this.assertNotEmpty(this.executedProject.getGroupId(), POM_ELT_GROUP_ID);
        this.assertNotEmpty(this.executedProject.getArtifactId(), POM_ELT_ARTIFACT_ID);
        if (this.executedProject.getFile() == null || !this.executedProject.getFile().exists()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingpom"));
        }
        if ("pom".equals(this.packaging) && this.eclipseProjectDir == null) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.pompackaging"));
            return false;
        }
        if ("eclipse-plugin".equals(this.packaging)) {
            this.pde = true;
        }
        if (this.eclipseProjectDir == null) {
            this.eclipseProjectDir = this.executedProject.getFile().getParentFile();
        }
        if (!this.eclipseProjectDir.exists() && !this.eclipseProjectDir.mkdirs()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.eclipseProjectDir));
        }
        if (!this.eclipseProjectDir.equals(this.executedProject.getFile().getParentFile())) {
            if (!this.eclipseProjectDir.isDirectory()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.notadir", this.eclipseProjectDir));
            }
            this.eclipseProjectDir = new File(this.eclipseProjectDir, this.executedProject.getArtifactId());
            if (!this.eclipseProjectDir.isDirectory() && !this.eclipseProjectDir.mkdirs()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.eclipseProjectDir));
            }
        }
        this.validateExtras();
        return true;
    }

    protected void validateExtras() throws MojoExecutionException {
    }

    private void checkDeprecations() {
        if (this.eclipseDownloadSources) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.deprecatedpar", new Object[]{"eclipse.downloadSources", "downloadSources"}));
            this.downloadSources = true;
        }
        this.checkDeprecationsExtras();
    }

    protected void checkDeprecationsExtras() {
    }

    public final void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        EclipseWriterConfig config = this.createEclipseWriterConfig(deps);
        if (this.wtpmanifest && this.isJavaProject()) {
            EclipseManifestWriter.addManifestResource(this.getLog(), config);
        }
        this.writeConfigurationExtras(config);
        if (this.wtpVersionFloat == 0.7f) {
            new EclipseWtpmodulesWriter().init(this.getLog(), config).write();
        }
        if (this.wtpVersionFloat >= 1.0f) {
            new EclipseWtpFacetsWriter().init(this.getLog(), config).write();
        }
        if (this.wtpVersionFloat == 1.0f) {
            new EclipseWtpComponentWriter().init(this.getLog(), config).write();
        }
        if ((double)this.wtpVersionFloat >= 1.5) {
            new EclipseWtpComponent15Writer().init(this.getLog(), config).write();
        }
        new EclipseSettingsWriter().init(this.getLog(), config).write();
        if (this.isJavaProject) {
            new EclipseClasspathWriter().init(this.getLog(), config).write();
            if (this.ajdt && this.ajdtVersion.equals("1.4")) {
                new EclipseAjdtWriter().init(this.getLog(), config).write();
            }
        }
        if (this.wtpapplicationxml) {
            new EclipseWtpApplicationXMLWriter().init(this.getLog(), config).write();
        }
        if (this.pde) {
            this.getLog().info((CharSequence)"The Maven Eclipse plugin runs in 'pde'-mode.");
            new EclipseOSGiManifestWriter().init(this.getLog(), config).write();
        }
        new EclipseProjectWriter().init(this.getLog(), config).write();
        this.writeAdditionalConfig();
        this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wrote", new Object[]{config.getEclipseProjectName(), this.eclipseProjectDir.getAbsolutePath()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAdditionalConfig() throws MojoExecutionException {
        if (this.additionalConfig != null) {
            for (int j = 0; j < this.additionalConfig.length; ++j) {
                EclipseConfigFile file = this.additionalConfig[j];
                File projectRelativeFile = new File(this.eclipseProjectDir, file.getName());
                if (projectRelativeFile.isDirectory()) {
                    this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.foundadir", projectRelativeFile.getAbsolutePath()));
                }
                try {
                    projectRelativeFile.getParentFile().mkdirs();
                    if (file.getContent() == null) {
                        InputStream inStream = file.getLocation() != null ? this.locator.getResourceAsInputStream(file.getLocation()) : file.getURL().openConnection().getInputStream();
                        FileOutputStream outStream = new FileOutputStream(projectRelativeFile);
                        try {
                            IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
                            continue;
                        }
                        finally {
                            inStream.close();
                            ((OutputStream)outStream).close();
                        }
                    }
                    FileUtils.fileWrite((String)projectRelativeFile.getAbsolutePath(), (String)file.getContent());
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantwritetofile", projectRelativeFile.getAbsolutePath()));
                }
                catch (ResourceNotFoundException e) {
                    throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantfindresource", file.getLocation()));
                }
            }
        }
    }

    protected final EclipseWriterConfig createEclipseWriterConfig(IdeDependency[] deps) throws MojoExecutionException {
        float ajdtVersionFloat;
        File projectBaseDir = this.executedProject.getFile().getParentFile();
        EclipseSourceDir[] sourceDirs = this.buildDirectoryList(this.executedProject, this.eclipseProjectDir, this.buildOutputDirectory);
        EclipseWriterConfig config = new EclipseWriterConfig();
        config.setWorkspaceConfiguration(this.getWorkspaceConfiguration());
        config.setProjectNameTemplate(this.getProjectNameTemplate());
        String projectName = IdeUtils.getProjectName(config.getProjectNameTemplate(), this.project);
        config.setEclipseProjectName(projectName);
        config.setWtpapplicationxml(this.wtpapplicationxml);
        config.setWtpVersion(this.wtpVersionFloat);
        try {
            ajdtVersionFloat = Float.parseFloat(this.ajdtVersion);
        }
        catch (NumberFormatException e) {
            ajdtVersionFloat = 0.0f;
        }
        config.setAjdtVersion(ajdtVersionFloat);
        LinkedHashSet convertedBuildCommands = new LinkedHashSet();
        if (this.buildcommands != null) {
            Iterator it = this.buildcommands.iterator();
            while (it.hasNext()) {
                Object cmd = it.next();
                if (cmd instanceof BuildCommand) {
                    convertedBuildCommands.add(cmd);
                    continue;
                }
                convertedBuildCommands.add(new BuildCommand((String)cmd));
            }
        }
        if (this.ajdt) {
            this.buildAjdtWeaveDeps(deps);
            this.buildAspectjDeps(deps);
        }
        config.setBuildCommands(new LinkedList(convertedBuildCommands));
        config.setBuildOutputDirectory(this.buildOutputDirectory);
        config.setClasspathContainers(this.classpathContainers);
        config.setDeps(deps);
        config.setEclipseProjectDirectory(this.eclipseProjectDir);
        config.setLocalRepository(this.localRepository);
        config.setOSGIManifestFile(this.manifest);
        config.setPde(this.pde);
        config.setProject(this.project);
        config.setProjectBaseDir(projectBaseDir);
        config.setProjectnatures(this.projectnatures);
        config.setProjectFacets(this.additionalProjectFacets);
        config.setSourceDirs(sourceDirs);
        config.setAddVersionToProjectName(this.isAddVersionToProjectName());
        config.setPackaging(this.packaging);
        this.collectWarContextRootsFromReactorEarConfiguration(config);
        return config;
    }

    private void collectWarContextRootsFromReactorEarConfiguration(EclipseWriterConfig config) {
        if (this.reactorProjects != null && this.wtpContextName == null && "war".equals(this.project.getPackaging())) {
            Iterator iter = this.reactorProjects.iterator();
            while (iter.hasNext()) {
                MavenProject reactorProject = (MavenProject)iter.next();
                if (!"ear".equals(reactorProject.getPackaging())) continue;
                Xpp3Dom[] warDefinitions = IdeUtils.getPluginConfigurationDom(reactorProject, "org.apache.maven.plugins:maven-ear-plugin", new String[]{"modules", "webModule"});
                for (int index = 0; index < warDefinitions.length; ++index) {
                    Xpp3Dom groupId = warDefinitions[index].getChild(POM_ELT_GROUP_ID);
                    Xpp3Dom artifactId = warDefinitions[index].getChild(POM_ELT_ARTIFACT_ID);
                    Xpp3Dom contextRoot = warDefinitions[index].getChild("contextRoot");
                    if (groupId != null && artifactId != null && contextRoot != null && groupId.getValue() != null && artifactId.getValue() != null && contextRoot.getValue() != null) {
                        this.getLog().info((CharSequence)("Found context root definition for " + groupId.getValue() + ":" + artifactId.getValue() + " " + contextRoot.getValue()));
                        if (!this.project.getArtifactId().equals(artifactId.getValue()) || !this.project.getGroupId().equals(groupId.getValue())) continue;
                        config.setContextName(contextRoot.getValue());
                        continue;
                    }
                    this.getLog().info((CharSequence)("Found incomplete ear configuration in " + reactorProject.getGroupId() + ":" + reactorProject.getGroupId() + " found " + warDefinitions[index].toString()));
                }
            }
        }
        if (config.getContextName() == null && "war".equals(this.project.getPackaging())) {
            if (this.wtpContextName == null) {
                config.setContextName(this.project.getArtifactId());
            } else {
                config.setContextName(this.wtpContextName);
            }
        }
    }

    protected void writeConfigurationExtras(EclipseWriterConfig config) throws MojoExecutionException {
    }

    private void assertNotEmpty(String string, String elementName) throws MojoExecutionException {
        if (string == null) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingelement", elementName));
        }
    }

    protected void fillDefaultNatures(String packaging) {
        this.projectnatures = new ArrayList();
        if (this.wtpVersionFloat >= 1.0f) {
            this.projectnatures.add(NATURE_WST_FACET_CORE_NATURE);
        }
        if (this.isJavaProject) {
            if (this.ajdt) {
                this.projectnatures.add(NATURE_AJDT_CORE_JAVA);
            }
            this.projectnatures.add(NATURE_JDT_CORE_JAVA);
        }
        if (this.wtpVersionFloat >= 0.7f) {
            this.projectnatures.add(NATURE_WST_MODULE_CORE_NATURE);
            if (this.isJavaProject) {
                this.projectnatures.add(NATURE_JEM_WORKBENCH_JAVA_EMF);
            }
        }
        if (this.pde) {
            this.projectnatures.add(NATURE_PDE_PLUGIN);
        }
    }

    protected void fillDefaultClasspathContainers(String packaging) {
        this.classpathContainers = new ArrayList();
        if (this.getWorkspaceConfiguration().getDefaultClasspathContainer() != null) {
            this.getLog().info((CharSequence)("Adding default classpath container: " + this.getWorkspaceConfiguration().getDefaultClasspathContainer()));
            this.classpathContainers.add(this.getWorkspaceConfiguration().getDefaultClasspathContainer());
        }
        if (this.pde) {
            this.classpathContainers.add(REQUIRED_PLUGINS_CONTAINER);
        }
        if (this.ajdt) {
            this.classpathContainers.add(ASPECTJ_RT_CONTAINER);
        }
    }

    protected void fillDefaultBuilders(String packaging) {
        this.buildcommands = new ArrayList();
        if (this.wtpVersionFloat == 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_COMPONENT_STRUCTURAL));
        }
        if (this.isJavaProject) {
            if (this.ajdt) {
                this.buildcommands.add(new BuildCommand(BUILDER_AJDT_CORE_JAVA));
            } else {
                this.buildcommands.add(new BuildCommand(BUILDER_JDT_CORE_JAVA));
            }
        }
        if (this.wtpVersionFloat >= 1.5f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_FACET));
        }
        if (this.wtpVersionFloat >= 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_VALIDATION));
        }
        if (this.wtpVersionFloat == 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER));
        }
        if (this.pde) {
            this.buildcommands.add(new BuildCommand(BUILDER_PDE_MANIFEST));
            this.buildcommands.add(new BuildCommand(BUILDER_PDE_SCHEMA));
        }
    }

    public final EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, File buildOutputDirectory) throws MojoExecutionException {
        File projectBaseDir = project.getFile().getParentFile();
        String mainOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, buildOutputDirectory, false);
        String testOutput = null;
        boolean useStandardOutputDir = buildOutputDirectory.equals(new File(project.getBuild().getOutputDirectory()));
        if (useStandardOutputDir) {
            this.getLog().debug((CharSequence)("testOutput toRelativeAndFixSeparator " + projectBaseDir + " , " + project.getBuild().getTestOutputDirectory()));
            testOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, new File(project.getBuild().getTestOutputDirectory()), false);
            this.getLog().debug((CharSequence)("testOutput after toRelative : " + testOutput));
        }
        LinkedHashSet mainDirectories = new LinkedHashSet();
        this.extractSourceDirs(mainDirectories, project.getCompileSourceRoots(), basedir, projectBaseDir, false, null);
        this.extractResourceDirs(mainDirectories, project.getBuild().getResources(), basedir, projectBaseDir, false, mainOutput);
        LinkedHashSet testDirectories = new LinkedHashSet();
        this.extractSourceDirs(testDirectories, project.getTestCompileSourceRoots(), basedir, projectBaseDir, true, testOutput);
        this.extractResourceDirs(testDirectories, project.getBuild().getTestResources(), basedir, projectBaseDir, true, testOutput);
        LinkedHashSet directories = new LinkedHashSet();
        boolean testBeforeMain = this.isMavenVersion("[2.0.8,)");
        if (testBeforeMain) {
            directories.addAll(testDirectories);
            directories.removeAll(mainDirectories);
            directories.addAll(mainDirectories);
        } else {
            directories.addAll(mainDirectories);
            directories.addAll(testDirectories);
        }
        if (this.ajdt) {
            this.extractAspectDirs(directories, project, basedir, projectBaseDir, testOutput);
        }
        return directories.toArray(new EclipseSourceDir[directories.size()]);
    }

    private void extractSourceDirs(Set directories, List sourceRoots, File basedir, File projectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            File sourceRootFile = new File((String)it.next());
            if (!sourceRootFile.isDirectory()) continue;
            String sourceRoot = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRootFile, !projectBaseDir.equals(basedir));
            directories.add(new EclipseSourceDir(sourceRoot, output, false, test, null, null, false));
        }
    }

    final void extractResourceDirs(Set directories, List resources, File basedir, File workspaceProjectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            File resourceDirectory;
            Resource resource = (Resource)it.next();
            this.getLog().debug((CharSequence)("Processing resource dir: " + resource.getDirectory()));
            String includePattern = null;
            String excludePattern = null;
            if (resource.getIncludes().size() != 0) {
                includePattern = StringUtils.join(resource.getIncludes().iterator(), (String)"|");
            }
            if (resource.getExcludes().size() != 0) {
                excludePattern = StringUtils.join(resource.getExcludes().iterator(), (String)"|");
            }
            if (!(resourceDirectory = new File(resource.getDirectory())).exists() || !resourceDirectory.isDirectory()) {
                this.getLog().debug((CharSequence)("Resource dir: " + resourceDirectory + " either missing or not a directory."));
                continue;
            }
            String resourceDir = IdeUtils.toRelativeAndFixSeparator(workspaceProjectBaseDir, resourceDirectory, !workspaceProjectBaseDir.equals(basedir));
            String thisOutput = output;
            if (thisOutput != null) {
                File outputFile = new File(thisOutput);
                if (!outputFile.isAbsolute()) {
                    outputFile = new File(workspaceProjectBaseDir, thisOutput);
                }
                outputFile.mkdirs();
                if (!StringUtils.isEmpty((String)resource.getTargetPath())) {
                    outputFile = new File(outputFile, resource.getTargetPath());
                    outputFile.mkdirs();
                }
                this.getLog().debug((CharSequence)("Making relative and fixing separator: { " + workspaceProjectBaseDir + ", " + outputFile + ", false }."));
                thisOutput = IdeUtils.toRelativeAndFixSeparator(workspaceProjectBaseDir, outputFile, false);
            }
            this.getLog().debug((CharSequence)("Adding eclipse source dir: { " + resourceDir + ", " + thisOutput + ", true, " + test + ", " + includePattern + ", " + excludePattern + " }."));
            directories.add(new EclipseSourceDir(resourceDir, thisOutput, true, test, includePattern, excludePattern, resource.isFiltering()));
        }
    }

    private void extractAspectDirs(Set directories, MavenProject project, File basedir, File projectBaseDir, String testOutput) throws MojoExecutionException {
        Xpp3Dom configuration = this.getAspectjConfiguration(project);
        if (configuration != null) {
            File testAspectDirectoryFile;
            File aspectDirectoryFile;
            String aspectDirectory = DEFAULT_ASPECT_DIRECTORY;
            Xpp3Dom aspectDirectoryElement = configuration.getChild(ASPECT_DIRECTORY);
            if (aspectDirectoryElement != null) {
                aspectDirectory = aspectDirectoryElement.getValue();
            }
            if ((aspectDirectoryFile = new File(basedir, aspectDirectory)).exists() && aspectDirectoryFile.isDirectory()) {
                String sourceRoot = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, aspectDirectoryFile, !projectBaseDir.equals(basedir));
                directories.add(new EclipseSourceDir(sourceRoot, null, false, false, null, null, false));
            }
            String testAspectDirectory = DEFAULT_TEST_ASPECT_DIRECTORY;
            Xpp3Dom testAspectDirectoryElement = configuration.getChild(TEST_ASPECT_DIRECTORY);
            if (testAspectDirectoryElement != null) {
                testAspectDirectory = testAspectDirectoryElement.getValue();
            }
            if ((testAspectDirectoryFile = new File(basedir, testAspectDirectory)).exists() && testAspectDirectoryFile.isDirectory()) {
                String sourceRoot = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, testAspectDirectoryFile, !projectBaseDir.equals(basedir));
                directories.add(new EclipseSourceDir(sourceRoot, testOutput, false, true, null, null, false));
            }
        }
    }

    private boolean enableAjdt(MavenProject project) {
        boolean enable = false;
        List buildPlugins = project.getBuildPlugins();
        Iterator it = buildPlugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getGroupId().equals(ORG_CODEHAUS_MOJO) || !plugin.getArtifactId().equals(ASPECTJ_MAVEN_PLUGIN)) continue;
            enable = true;
            break;
        }
        return enable;
    }

    private Xpp3Dom getAspectjConfiguration(MavenProject project) {
        Xpp3Dom configuration = null;
        List buildPlugins = project.getBuildPlugins();
        Iterator it = buildPlugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getGroupId().equals(ORG_CODEHAUS_MOJO) || !plugin.getArtifactId().equals(ASPECTJ_MAVEN_PLUGIN)) continue;
            configuration = (Xpp3Dom)plugin.getConfiguration();
            break;
        }
        return configuration;
    }

    private void buildAspectjDeps(IdeDependency[] deps) throws MojoExecutionException {
        Xpp3Dom aspectLibrariesParent;
        Xpp3Dom configuration = this.getAspectjConfiguration(this.executedProject);
        if (configuration != null && (aspectLibrariesParent = configuration.getChild(ASPECT_LIBRARIES)) != null) {
            Xpp3Dom[] aspectLibraries = aspectLibrariesParent.getChildren(ASPECT_LIBRARY);
            for (int i = 0; i < aspectLibraries.length; ++i) {
                int j;
                block4: {
                    String artifactId = aspectLibraries[i].getChild(POM_ELT_ARTIFACT_ID).getValue();
                    String groupId = aspectLibraries[i].getChild(POM_ELT_GROUP_ID).getValue();
                    for (j = 0; j < deps.length; ++j) {
                        if (!deps[j].getArtifactId().equals(artifactId) || !deps[j].getGroupId().equals(groupId)) {
                            continue;
                        }
                        break block4;
                    }
                    throw new MojoExecutionException("AspectLibrary is not a dependency of project");
                }
                deps[j].setAjdtDependency(true);
            }
        }
    }

    private void buildAjdtWeaveDeps(IdeDependency[] deps) throws MojoExecutionException {
        Xpp3Dom weaveDependenciesParent;
        Xpp3Dom configuration = this.getAspectjConfiguration(this.executedProject);
        if (configuration != null && (weaveDependenciesParent = configuration.getChild(WEAVE_DEPENDENCIES)) != null) {
            Xpp3Dom[] weaveDependencies = weaveDependenciesParent.getChildren(WEAVE_DEPENDENCY);
            for (int i = 0; i < weaveDependencies.length; ++i) {
                int j;
                block4: {
                    String artifactId = weaveDependencies[i].getChild(POM_ELT_ARTIFACT_ID).getValue();
                    String groupId = weaveDependencies[i].getChild(POM_ELT_GROUP_ID).getValue();
                    for (j = 0; j < deps.length; ++j) {
                        if (!deps[j].getArtifactId().equals(artifactId) || !deps[j].getGroupId().equals(groupId)) {
                            continue;
                        }
                        break block4;
                    }
                    throw new MojoExecutionException("WeaveDependency is not a dependency of project");
                }
                deps[j].setAjdtWeaveDependency(true);
            }
        }
    }

    public String getProjectNameForArifact(Artifact artifact) {
        IdeDependency[] workspaceArtefacts = this.getWorkspaceArtefacts();
        for (int index = 0; workspaceArtefacts != null && index < workspaceArtefacts.length; ++index) {
            IdeDependency workspaceArtefact = workspaceArtefacts[index];
            if (!workspaceArtefact.isAddedToClasspath() || !workspaceArtefact.getGroupId().equals(artifact.getGroupId()) || !workspaceArtefact.getArtifactId().equals(artifact.getArtifactId()) || !workspaceArtefact.getVersion().equals(artifact.getVersion())) continue;
            return workspaceArtefact.getEclipseProjectName();
        }
        MavenProject reactorProject = this.getReactorProject(artifact);
        if (reactorProject != null) {
            return IdeUtils.getProjectName(this.getProjectNameTemplateForMavenProject(reactorProject), artifact);
        }
        return IdeUtils.getProjectName(this.getProjectNameTemplate(), artifact);
    }

    private String getProjectNameTemplateForMavenProject(MavenProject mavenProject) {
        Xpp3Dom config;
        Plugin plugin;
        String projectNameTemplate = null;
        boolean addVersionToProjectName = false;
        boolean addGroupIdToProjectName = false;
        Build build = mavenProject.getBuild();
        if (build != null && (plugin = (Plugin)build.getPluginsAsMap().get("org.apache.maven.plugins:maven-eclipse-plugin")) != null && (config = (Xpp3Dom)plugin.getConfiguration()) != null) {
            Xpp3Dom addVersionToProjectNameNode;
            Xpp3Dom projectNameTemplateNode = config.getChild("projectNameTemplate");
            if (projectNameTemplateNode != null) {
                projectNameTemplate = projectNameTemplateNode.getValue();
            }
            addVersionToProjectName = (addVersionToProjectNameNode = config.getChild("addVersionToProjectName")) != null;
            Xpp3Dom addGroupIdToProjectNameNode = config.getChild("addGroupIdToProjectName");
            addGroupIdToProjectName = addGroupIdToProjectNameNode != null;
        }
        return IdeUtils.calculateProjectNameTemplate(projectNameTemplate, addVersionToProjectName, addGroupIdToProjectName, this.getLog());
    }

    protected final IdeDependency[] getWorkspaceArtefacts() {
        return this.getWorkspaceConfiguration().getWorkspaceArtefacts();
    }

    public final WorkspaceConfiguration getWorkspaceConfiguration() {
        if (this.workspaceConfiguration == null) {
            this.workspaceConfiguration = new WorkspaceConfiguration();
            this.locateWorkspace();
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.workspace", this.workspace));
            this.workspaceConfiguration.setWorkspaceDirectory(this.workspace);
            new ReadWorkspaceLocations().init(this.getLog(), this.workspaceConfiguration, this.project, this.wtpdefaultserver);
        }
        return this.workspaceConfiguration;
    }

    private void locateWorkspace() {
        if (this.workspace == null) {
            for (File currentWorkingDirectory = new File(".").getAbsoluteFile(); currentWorkingDirectory != null; currentWorkingDirectory = currentWorkingDirectory.getParentFile()) {
                File metadataDirectory = new File(currentWorkingDirectory, ".metadata");
                this.logger.debug("Checking for eclipse workspace at " + currentWorkingDirectory);
                if (!metadataDirectory.exists() || !metadataDirectory.isDirectory()) continue;
                this.logger.debug("  Found workspace at " + currentWorkingDirectory);
                this.workspace = currentWorkingDirectory;
                return;
            }
        }
    }

    public final List getExcludes() {
        return this.excludes;
    }

    private boolean isAvailableAsAWorkspaceProject(Artifact artifact) {
        IdeDependency[] workspaceArtefacts = this.getWorkspaceArtefacts();
        for (int index = 0; workspaceArtefacts != null && index < workspaceArtefacts.length; ++index) {
            IdeDependency workspaceArtefact = workspaceArtefacts[index];
            if (!workspaceArtefact.getGroupId().equals(artifact.getGroupId()) || !workspaceArtefact.getArtifactId().equals(artifact.getArtifactId())) continue;
            if (workspaceArtefact.getVersion().equals(artifact.getVersion())) {
                workspaceArtefact.setAddedToClasspath(true);
                this.getLog().debug((CharSequence)("Using workspace project: " + workspaceArtefact.getEclipseProjectName()));
                return true;
            }
            this.getLog().info((CharSequence)("Artifact " + artifact.getId() + " already available as a workspace project, but with different version. Expected: " + artifact.getVersion() + ", found: " + workspaceArtefact.getVersion()));
        }
        return false;
    }

    protected final boolean hasToResolveJar(Artifact art) {
        return !this.getUseProjectReferences() || !this.isAvailableAsAReactorProject(art) || this.limitProjectReferencesToWorkspace && (!this.getUseProjectReferences() || !this.isAvailableAsAWorkspaceProject(art));
    }

    protected final boolean useProjectReference(Artifact art) {
        boolean isReactorProject = this.getUseProjectReferences() && this.isAvailableAsAReactorProject(art);
        boolean isWorkspaceProject = this.getUseProjectReferences() && this.isAvailableAsAWorkspaceProject(art);
        return isReactorProject && !this.limitProjectReferencesToWorkspace || this.limitProjectReferencesToWorkspace && isWorkspaceProject || !isReactorProject && isWorkspaceProject;
    }
}

