/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModule
extends AbstractEarModule {
    protected static final String WEB_MODULE = "web";
    protected static final String WEB_URI_FIELD = "web-uri";
    protected static final String CONTEXT_ROOT_FIELD = "context-root";
    private String contextRoot;

    public WebModule() {
    }

    public WebModule(Artifact a) {
        super(a);
        this.contextRoot = WebModule.getDefaultContextRoot(a);
    }

    @Override
    public void appendModule(XMLWriter writer, String version, Boolean generateId) {
        this.startModuleElement(writer, generateId);
        writer.startElement(WEB_MODULE);
        writer.startElement(WEB_URI_FIELD);
        writer.writeText(this.getUri());
        writer.endElement();
        writer.startElement(CONTEXT_ROOT_FIELD);
        writer.writeText(this.getContextRoot());
        writer.endElement();
        writer.endElement();
        this.writeAltDeploymentDescriptor(writer, version);
        writer.endElement();
    }

    @Override
    public void resolveArtifact(Set<Artifact> artifacts) throws EarPluginException, MojoFailureException {
        super.resolveArtifact(artifacts);
        if (this.contextRoot == null) {
            this.contextRoot = WebModule.getDefaultContextRoot(this.getArtifact());
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    @Override
    public String getType() {
        return "war";
    }

    private static String getDefaultContextRoot(Artifact a) {
        if (a == null) {
            throw new NullPointerException("Artifact could not be null.");
        }
        return "/" + a.getArtifactId();
    }

    @Override
    public String getLibDir() {
        return "WEB-INF/lib";
    }
}

