/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.ear.EarModuleFactory;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.UnknownArtifactTypeException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class ArtifactTypeMappingService {
    static final String ARTIFACT_TYPE_MAPPING_ELEMENT = "artifactTypeMapping";
    static final String TYPE_ATTRIBUTE = "type";
    static final String MAPPING_ATTRIBUTE = "mapping";
    private final Map<String, List<String>> typeMappings = new HashMap<String, List<String>>();
    private final Map<String, String> customMappings = new HashMap<String, String>();

    public ArtifactTypeMappingService() {
        this.init();
    }

    public void configure(PlexusConfiguration plexusConfiguration) throws EarPluginException, PlexusConfigurationException {
        if (plexusConfiguration == null) {
            return;
        }
        PlexusConfiguration[] artifactTypeMappings = plexusConfiguration.getChildren(ARTIFACT_TYPE_MAPPING_ELEMENT);
        for (int i = 0; i < artifactTypeMappings.length; ++i) {
            PlexusConfiguration artifactTypeMapping = artifactTypeMappings[i];
            String customType = artifactTypeMapping.getAttribute(TYPE_ATTRIBUTE);
            String mapping = artifactTypeMapping.getAttribute(MAPPING_ATTRIBUTE);
            if (customType == null) {
                throw new EarPluginException("Invalid artifact type mapping, type attribute should be set.");
            }
            if (mapping == null) {
                throw new EarPluginException("Invalid artifact type mapping, mapping attribute should be set.");
            }
            if (!EarModuleFactory.isStandardArtifactType(mapping)) {
                throw new EarPluginException("Invalid artifact type mapping, mapping[" + mapping + "] must be a standard Ear artifact type[" + EarModuleFactory.getStandardArtifactTypes() + "]");
            }
            if (this.customMappings.containsKey(customType)) {
                throw new EarPluginException("Invalid artifact type mapping, type[" + customType + "] is already registered.");
            }
            this.customMappings.put(customType, mapping);
            List<String> typeMapping = this.typeMappings.get(mapping);
            typeMapping.add(customType);
        }
    }

    public boolean isMappedToType(String standardType, String customType) {
        if (!EarModuleFactory.isStandardArtifactType(standardType)) {
            throw new IllegalStateException("Artifact type[" + standardType + "] is not a standard Ear artifact type[" + EarModuleFactory.getStandardArtifactTypes() + "]");
        }
        List<String> typeMappings = this.typeMappings.get(standardType);
        return typeMappings.contains(customType);
    }

    public String getStandardType(String type) throws UnknownArtifactTypeException {
        if (type == null) {
            throw new IllegalStateException("custom type could not be null.");
        }
        if (EarModuleFactory.getStandardArtifactTypes().contains(type)) {
            return type;
        }
        if (!this.customMappings.containsKey(type)) {
            throw new UnknownArtifactTypeException("Unknown artifact type[" + type + "]");
        }
        return this.customMappings.get(type);
    }

    private void init() {
        this.typeMappings.clear();
        this.customMappings.clear();
        for (String type : EarModuleFactory.getStandardArtifactTypes()) {
            ArrayList<String> typeMapping = new ArrayList<String>();
            typeMapping.add(type);
            this.typeMappings.put(type, typeMapping);
        }
    }
}

