/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import org.apache.maven.plugin.ear.EarPluginException;

class JbossConfiguration {
    static final String VERSION_3_2 = "3.2";
    static final String VERSION_4 = "4";
    static final String VERSION = "version";
    static final String SECURITY_DOMAIN = "security-domain";
    static final String UNAUHTHENTICTED_PRINCIPAL = "unauthenticated-principal";
    static final String JMX_NAME = "jmx-name";
    private final String version;
    private boolean jbossThreeDot2;
    private boolean jbossFour;
    private final String securityDomain;
    private final String unauthenticatedPrincipal;
    private final String jmxName;

    public JbossConfiguration(String version, String securityDomain, String unauthenticatedPrincipal, String jmxName) throws EarPluginException {
        if (version == null) {
            throw new EarPluginException("jboss version could not be null.");
        }
        this.version = version;
        if (version.equals(VERSION_3_2)) {
            this.jbossThreeDot2 = true;
        } else if (version.equals(VERSION_4)) {
            this.jbossFour = true;
        } else {
            throw new EarPluginException("Invalid JBoss configuration, version[" + version + "] is not supported.");
        }
        this.securityDomain = securityDomain;
        this.unauthenticatedPrincipal = unauthenticatedPrincipal;
        this.jmxName = jmxName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isJbossThreeDot2() {
        return this.jbossThreeDot2;
    }

    public boolean isJbossFour() {
        return this.jbossFour;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public String getJmxName() {
        return this.jmxName;
    }
}

