/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.EarExecutionContext;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarModuleFactory;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.JbossConfiguration;
import org.apache.maven.plugin.ear.util.ArtifactTypeMappingService;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public abstract class AbstractEarMojo
extends AbstractMojo {
    public static final String APPLICATION_XML_URI = "META-INF/application.xml";
    public static final String META_INF = "META-INF";
    public static final String UTF_8 = "UTF-8";
    protected String encoding = "UTF-8";
    protected String generatedDescriptorLocation;
    protected MavenProject project;
    private EarModule[] modules;
    protected PlexusConfiguration artifactTypeMappings;
    private String defaultLibBundleDir;
    private String fileNameMapping;
    private File workDirectory;
    private PlexusConfiguration jboss;
    private List earModules;
    private List allModules;
    private JbossConfiguration jbossConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Resolving artifact type mappings ...");
        try {
            ArtifactTypeMappingService.getInstance().configure(this.artifactTypeMappings);
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize artifact type mappings", (Exception)e);
        }
        catch (PlexusConfigurationException e) {
            throw new MojoExecutionException("Invalid artifact type mappings configuration", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)"Initializing JBoss configuration if necessary ...");
        try {
            this.initializeJbossConfiguration();
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize JBoss configuration", (Exception)e);
        }
        this.getLog().debug((CharSequence)"Initializing ear execution context");
        EarExecutionContext.getInstance().initialize(this.defaultLibBundleDir, this.jbossConfiguration, this.fileNameMapping);
        this.getLog().debug((CharSequence)"Resolving ear modules ...");
        this.allModules = new ArrayList();
        try {
            if (this.modules != null && this.modules.length > 0) {
                EarModule module = null;
                for (int i = 0; i < this.modules.length; ++i) {
                    module = this.modules[i];
                    this.getLog().debug((CharSequence)("Resolving ear module[" + module + "]"));
                    module.resolveArtifact(this.project.getArtifacts());
                    this.allModules.add(module);
                }
            }
            Set artifacts = this.project.getArtifacts();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if ("pom".equals(artifact.getType())) continue;
                ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                if (AbstractEarMojo.isArtifactRegistered(artifact, this.allModules) || artifact.isOptional() || !filter.include(artifact)) continue;
                EarModule module = EarModuleFactory.newEarModule(artifact, this.defaultLibBundleDir);
                this.allModules.add(module);
            }
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize ear modules", (Exception)e);
        }
        this.earModules = new ArrayList();
        Iterator iter = this.allModules.iterator();
        while (iter.hasNext()) {
            EarModule earModule = (EarModule)iter.next();
            if (earModule.isExcluded()) {
                this.getLog().debug((CharSequence)("Skipping ear module[" + earModule + "]"));
                continue;
            }
            this.earModules.add(earModule);
        }
    }

    protected List getModules() {
        if (this.earModules == null) {
            throw new IllegalStateException("Ear modules have not been initialized");
        }
        return this.earModules;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    protected JbossConfiguration getJbossConfiguration() {
        return this.jbossConfiguration;
    }

    private static boolean isArtifactRegistered(Artifact a, List currentList) {
        Iterator i = currentList.iterator();
        while (i.hasNext()) {
            EarModule em = (EarModule)i.next();
            if (!em.getArtifact().equals(a)) continue;
            return true;
        }
        return false;
    }

    private void initializeJbossConfiguration() throws EarPluginException {
        if (this.jboss == null) {
            this.jbossConfiguration = null;
        } else {
            try {
                String version = this.jboss.getChild("version").getValue();
                if (version == null) {
                    this.getLog().info((CharSequence)"JBoss version not set, using JBoss 4 by default");
                    version = "4";
                }
                String securityDomain = this.jboss.getChild("security-domain").getValue();
                String unauthenticatedPrincipal = this.jboss.getChild("unauthenticated-principal").getValue();
                String jmxName = this.jboss.getChild("jmx-name").getValue();
                this.jbossConfiguration = new JbossConfiguration(version, securityDomain, unauthenticatedPrincipal, jmxName);
            }
            catch (PlexusConfigurationException e) {
                throw new EarPluginException("Invalid JBoss configuration", e);
            }
        }
    }
}

