/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import org.apache.maven.plugin.ear.JbossConfiguration;
import org.apache.maven.plugin.ear.output.FileNameMapping;
import org.apache.maven.plugin.ear.output.FileNameMappingFactory;
import org.apache.maven.plugin.ear.util.ArtifactRepository;
import org.apache.maven.plugin.ear.util.ArtifactTypeMappingService;
import org.apache.maven.project.MavenProject;

public class EarExecutionContext {
    private String defaultLibBundleDir;
    private JbossConfiguration jbossConfiguration;
    private FileNameMapping fileNameMapping;
    private ArtifactRepository artifactRepository;

    public EarExecutionContext(MavenProject project, String mainArtifactId, String defaultLibBundleDir, JbossConfiguration jbossConfiguration, String fileNameMappingName, ArtifactTypeMappingService typeMappingService) {
        this.initialize(project, mainArtifactId, defaultLibBundleDir, jbossConfiguration, fileNameMappingName, typeMappingService);
    }

    public String getDefaultLibBundleDir() {
        return this.defaultLibBundleDir;
    }

    public boolean isJbossConfigured() {
        return this.jbossConfiguration != null;
    }

    public FileNameMapping getFileNameMapping() {
        return this.fileNameMapping;
    }

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    private void initialize(MavenProject project, String mainArtifactId, String defaultLibBundleDir, JbossConfiguration jbossConfiguration, String fileNameMappingName, ArtifactTypeMappingService typeMappingService) {
        this.artifactRepository = new ArtifactRepository(project.getArtifacts(), mainArtifactId, typeMappingService);
        this.defaultLibBundleDir = defaultLibBundleDir;
        this.jbossConfiguration = jbossConfiguration;
        this.fileNameMapping = fileNameMappingName == null || fileNameMappingName.trim().length() == 0 ? FileNameMappingFactory.getDefaultFileNameMapping() : FileNameMappingFactory.getFileNameMapping(fileNameMappingName);
    }
}

