/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.MojoExecution;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactDeployerRequest;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;

@Mojo(name="deploy", defaultPhase="deploy")
public class DeployMojo
extends AbstractDeployMojo {
    private static final Pattern ALT_LEGACY_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+?)::(.+)");
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+?)::(.+)");
    @Inject
    private Project project;
    @Inject
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="true", property="deployAtEnd")
    private boolean deployAtEnd;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Parameter(property="altReleaseDeploymentRepository")
    private String altReleaseDeploymentRepository;
    @Parameter(property="maven.deploy.skip", defaultValue="false")
    private String skip = Boolean.FALSE.toString();
    @Parameter(defaultValue="false", property="allowIncompleteProjects")
    private boolean allowIncompleteProjects;

    private void putState(State state) {
        this.session.getPluginContext(this.project).put(State.class.getName(), state);
    }

    private void putState(ArtifactDeployerRequest request) {
        this.session.getPluginContext(this.project).put(ArtifactDeployerRequest.class.getName(), request);
    }

    private State getState(Project project) {
        return (State)((Object)this.session.getPluginContext(project).get(State.class.getName()));
    }

    private boolean hasState(Project project) {
        return this.session.getPluginContext(project).containsKey(State.class.getName());
    }

    public void execute() {
        if (Boolean.parseBoolean(this.skip) || "releases".equals(this.skip) && !this.session.isVersionSnapshot(this.project.getVersion()) || "snapshots".equals(this.skip) && this.session.isVersionSnapshot(this.project.getVersion())) {
            this.getLog().info((CharSequence)"Skipping artifact deployment");
            this.putState(State.SKIPPED);
        } else {
            this.failIfOffline();
            this.warnIfAffectedPackagingAndMaven(this.project.getPackaging().id());
            if (!this.deployAtEnd) {
                this.getLog().info((CharSequence)("Deploying deploy for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
                this.deploy(this.createDeployerRequest());
                this.putState(State.DEPLOYED);
            } else {
                this.putState(State.TO_BE_DEPLOYED);
                this.putState(this.createDeployerRequest());
                if (!this.allProjectsMarked()) {
                    this.getLog().info((CharSequence)("Deferring deploy for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
                }
            }
        }
        if (this.allProjectsMarked()) {
            this.deployAllAtOnce();
        }
    }

    private boolean allProjectsMarked() {
        return this.session.getProjects().stream().allMatch(p -> this.hasState((Project)p) || !this.hasDeployExecution((Project)p));
    }

    private boolean hasDeployExecution(Project p) {
        String key = this.mojoExecution.getPlugin().getModel().getKey();
        Plugin plugin = (Plugin)p.getBuild().getPluginsAsMap().get(key);
        if (plugin != null) {
            for (PluginExecution execution : plugin.getExecutions()) {
                if (execution.getGoals().isEmpty() || "none".equalsIgnoreCase(execution.getPhase())) continue;
                return true;
            }
        }
        return false;
    }

    private void deployAllAtOnce() {
        LinkedHashMap<RemoteRepository, Map> flattenedRequests = new LinkedHashMap<RemoteRepository, Map>();
        for (Project reactorProject : this.session.getProjects()) {
            State state = this.getState(reactorProject);
            if (state != State.TO_BE_DEPLOYED) continue;
            ArtifactDeployerRequest request = (ArtifactDeployerRequest)this.session.getPluginContext(reactorProject).get(ArtifactDeployerRequest.class.getName());
            flattenedRequests.computeIfAbsent(request.getRepository(), r -> new LinkedHashMap()).computeIfAbsent(request.getRetryFailedDeploymentCount(), i -> new ArrayList()).addAll(request.getArtifacts());
        }
        ArrayList<ArtifactDeployerRequest> requests = new ArrayList<ArtifactDeployerRequest>();
        for (Map.Entry entry1 : flattenedRequests.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                requests.add(ArtifactDeployerRequest.builder().session(this.session).repository((RemoteRepository)entry1.getKey()).retryFailedDeploymentCount(((Integer)entry2.getKey()).intValue()).artifacts((Collection)entry2.getValue()).build());
            }
        }
        if (!requests.isEmpty()) {
            requests.forEach(this::deploy);
        } else {
            this.getLog().info((CharSequence)"No actual deploy requests");
        }
    }

    private void deploy(ArtifactDeployerRequest request) {
        try {
            this.getLog().info((CharSequence)("Deploying artifacts " + request.getArtifacts().toString() + " to repository " + String.valueOf(request.getRepository())));
            this.getArtifactDeployer().deploy(request);
        }
        catch (MojoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoException(e.getMessage(), (Throwable)e);
        }
    }

    private ArtifactDeployerRequest createDeployerRequest() {
        ProjectManager projectManager = this.getProjectManager();
        Collection deployables = projectManager.getAllArtifacts(this.project);
        Collection attachedArtifacts = projectManager.getAttachedArtifacts(this.project);
        ArtifactManager artifactManager = this.getArtifactManager();
        if (artifactManager.getPath((Artifact)this.project.getPomArtifact()).isEmpty()) {
            artifactManager.setPath(this.project.getPomArtifact(), this.project.getPomPath());
        }
        for (Artifact deployable : deployables) {
            if (this.isValidPath(deployable)) continue;
            if (deployable == this.project.getMainArtifact().orElse(null)) {
                if (attachedArtifacts.isEmpty()) {
                    throw new MojoException("The packaging for this project did not assign a file to the build artifact");
                }
                if (this.allowIncompleteProjects) {
                    this.getLog().warn((CharSequence)"");
                    this.getLog().warn((CharSequence)"The packaging plugin for this project did not assign");
                    this.getLog().warn((CharSequence)"a main file to the project but it has attachments. Change packaging to 'pom'.");
                    this.getLog().warn((CharSequence)"");
                    this.getLog().warn((CharSequence)"Incomplete projects like this will fail in future Maven versions!");
                    this.getLog().warn((CharSequence)"");
                    continue;
                }
                throw new MojoException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
            }
            throw new MojoException("The packaging for this project did not assign a file to the attached artifact: " + String.valueOf(deployable));
        }
        ArtifactDeployerRequest request = ArtifactDeployerRequest.builder().session(this.session).repository(this.getDeploymentRepository(this.session.isVersionSnapshot(this.project.getVersion()))).artifacts(deployables).retryFailedDeploymentCount(Math.max(1, Math.min(10, this.getRetryFailedDeploymentCount()))).build();
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RemoteRepository getDeploymentRepository(boolean isSnapshot) throws MojoException {
        DistributionManagement dm;
        RemoteRepository repo = null;
        String altDeploymentRepo = isSnapshot && this.altSnapshotDeploymentRepository != null ? this.altSnapshotDeploymentRepository : (!isSnapshot && this.altReleaseDeploymentRepository != null ? this.altReleaseDeploymentRepository : this.altDeploymentRepository);
        if (altDeploymentRepo != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + altDeploymentRepo));
            Matcher matcher = ALT_LEGACY_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
            if (matcher.matches()) {
                String id = matcher.group(1).trim();
                String layout = matcher.group(2).trim();
                String url = matcher.group(3).trim();
                if (!"default".equals(layout)) throw new MojoException((Object)altDeploymentRepo, "Invalid legacy syntax and layout for repository.", "Invalid legacy syntax and layout for alternative repository. Use \"" + id + "::" + url + "\" instead, and only default layout is supported.");
                this.getLog().warn((CharSequence)("Using legacy syntax for alternative repository. Use \"" + id + "::" + url + "\" instead."));
                repo = this.createDeploymentArtifactRepository(id, url);
            } else {
                matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
                if (!matcher.matches()) {
                    throw new MojoException((Object)altDeploymentRepo, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::url\".");
                }
                String id = matcher.group(1).trim();
                String url = matcher.group(2).trim();
                repo = this.createDeploymentArtifactRepository(id, url);
            }
        }
        if (repo == null && (dm = this.project.getModel().getDistributionManagement()) != null) {
            if (isSnapshot && dm.getSnapshotRepository() != null && DeployMojo.isNotEmpty(dm.getSnapshotRepository().getId()) && DeployMojo.isNotEmpty(dm.getSnapshotRepository().getUrl())) {
                repo = this.session.createRemoteRepository((Repository)dm.getSnapshotRepository());
            } else if (dm.getRepository() != null && DeployMojo.isNotEmpty(dm.getRepository().getId()) && DeployMojo.isNotEmpty(dm.getRepository().getUrl())) {
                repo = this.session.createRemoteRepository((Repository)dm.getRepository());
            }
        }
        if (repo != null) return repo;
        String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::url parameter";
        throw new MojoException(msg);
    }

    private boolean isValidPath(Artifact a) {
        return this.getArtifactManager().getPath(a).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).isPresent();
    }

    private static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    private ArtifactDeployer getArtifactDeployer() {
        return (ArtifactDeployer)this.session.getService(ArtifactDeployer.class);
    }

    private ArtifactManager getArtifactManager() {
        return (ArtifactManager)this.session.getService(ArtifactManager.class);
    }

    private ProjectManager getProjectManager() {
        return (ProjectManager)this.session.getService(ProjectManager.class);
    }

    private static enum State {
        SKIPPED,
        DEPLOYED,
        TO_BE_DEPLOYED;

    }
}

