/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromConfiguration;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractFromConfigurationMojo
extends AbstractDependencyMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/dependency")
    private File outputDirectory;
    @Parameter(property="mdep.overWriteReleases", defaultValue="false")
    private boolean overWriteReleases;
    @Parameter(property="mdep.overWriteSnapshots", defaultValue="false")
    private boolean overWriteSnapshots;
    @Deprecated
    @Parameter(property="mdep.overIfNewer", defaultValue="true")
    private boolean overIfNewer;
    @Parameter(property="mdep.overWriteIfNewer", defaultValue="true")
    private boolean overWriteIfNewer;
    @Parameter
    private List<ArtifactItem> artifactItems;
    @Parameter
    private File localRepositoryDirectory;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystem repositorySystem;

    protected AbstractFromConfigurationMojo(MavenSession session, BuildContext buildContext, MavenProject project, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem) {
        super(session, buildContext, project);
        this.artifactHandlerManager = artifactHandlerManager;
        this.repositorySystem = repositorySystem;
    }

    abstract ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem var1);

    protected void verifyRequirements() throws MojoFailureException {
        if (this.artifactItems == null || this.artifactItems.isEmpty()) {
            throw new MojoFailureException("Either artifact or artifactItems is required ");
        }
    }

    protected List<ArtifactItem> getProcessedArtifactItems(ProcessArtifactItemsRequest processArtifactItemsRequest) throws MojoExecutionException {
        boolean removeVersion = processArtifactItemsRequest.isRemoveVersion();
        boolean prependGroupId = processArtifactItemsRequest.isPrependGroupId();
        boolean useBaseVersion = processArtifactItemsRequest.isUseBaseVersion();
        boolean removeClassifier = processArtifactItemsRequest.isRemoveClassifier();
        if (this.artifactItems == null || this.artifactItems.isEmpty()) {
            throw new MojoExecutionException("There are no artifactItems configured.");
        }
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().debug((CharSequence)("Configured Artifact: " + artifactItem.toString()));
            if (artifactItem.getOutputDirectory() == null) {
                artifactItem.setOutputDirectory(this.outputDirectory);
            }
            artifactItem.getOutputDirectory().mkdirs();
            if (artifactItem.getVersion() == null || artifactItem.getVersion().isEmpty()) {
                this.fillMissingArtifactVersion(artifactItem);
            }
            artifactItem.setArtifact(this.getArtifact(artifactItem));
            if (artifactItem.getDestFileName() == null || artifactItem.getDestFileName().isEmpty()) {
                artifactItem.setDestFileName(DependencyUtil.getFormattedFileName(artifactItem.getArtifact(), removeVersion, prependGroupId, useBaseVersion, removeClassifier));
            }
            try {
                artifactItem.setNeedsProcessing(this.checkIfProcessingNeeded(artifactItem));
            }
            catch (ArtifactFilterException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.artifactItems;
    }

    private boolean checkIfProcessingNeeded(ArtifactItem item) throws ArtifactFilterException {
        return "true".equalsIgnoreCase(item.getOverWrite()) || this.getMarkedArtifactFilter(item).isArtifactIncluded(item);
    }

    private RepositorySystemSession createSystemSessionForLocalRepo() {
        RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
        if (this.localRepositoryDirectory != null) {
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(this.session.getRepositorySession());
            newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
            LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(this.localRepositoryDirectory));
            newSession.setLocalRepositoryManager(localRepositoryManager);
            repositorySystemSession = newSession;
            this.getLog().debug((CharSequence)("localRepoPath: " + localRepositoryManager.getRepository().getBasedir()));
        }
        return repositorySystemSession;
    }

    protected org.apache.maven.artifact.Artifact getArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        try {
            ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(artifactItem.getType());
            String extension = artifactHandler != null ? artifactHandler.getExtension() : artifactItem.getType();
            DefaultArtifact artifact = new DefaultArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getClassifier(), extension, artifactItem.getVersion());
            RepositorySystemSession repositorySession = this.createSystemSessionForLocalRepo();
            ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.getProject().getRemoteProjectRepositories(), null);
            ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(repositorySession, request);
            return RepositoryUtils.toArtifact((Artifact)artifactResult.getArtifact());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find/resolve artifact.", (Exception)((Object)e));
        }
    }

    private void fillMissingArtifactVersion(ArtifactItem artifact) throws MojoExecutionException {
        List depMngt;
        MavenProject project = this.getProject();
        List deps = project.getDependencies();
        List list = depMngt = project.getDependencyManagement() == null ? Collections.emptyList() : project.getDependencyManagement().getDependencies();
        if (!(this.findDependencyVersion(artifact, deps, false) || project.getDependencyManagement() != null && this.findDependencyVersion(artifact, depMngt, false) || this.findDependencyVersion(artifact, deps, true) || project.getDependencyManagement() != null && this.findDependencyVersion(artifact, depMngt, true))) {
            throw new MojoExecutionException("Unable to find artifact version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " in either dependency list or in project's dependency management.");
        }
    }

    private boolean findDependencyVersion(ArtifactItem artifact, List<Dependency> dependencies, boolean looseMatch) {
        for (Dependency dependency : dependencies) {
            if (!Objects.equals(dependency.getArtifactId(), artifact.getArtifactId()) || !Objects.equals(dependency.getGroupId(), artifact.getGroupId()) || !looseMatch && !Objects.equals(dependency.getClassifier(), artifact.getClassifier()) || !looseMatch && !Objects.equals(dependency.getType(), artifact.getType())) continue;
            artifact.setVersion(dependency.getVersion());
            return true;
        }
        return false;
    }

    public List<ArtifactItem> getArtifactItems() {
        return this.artifactItems;
    }

    public void setArtifactItems(List<ArtifactItem> theArtifactItems) {
        this.artifactItems = theArtifactItems;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File theOutputDirectory) {
        this.outputDirectory = theOutputDirectory;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean theOverWriteIfNewer) {
        this.overWriteIfNewer = theOverWriteIfNewer;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean theOverWriteReleases) {
        this.overWriteReleases = theOverWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean theOverWriteSnapshots) {
        this.overWriteSnapshots = theOverWriteSnapshots;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public void setArtifact(String artifact) throws MojoFailureException {
        if (artifact != null) {
            String packaging = "jar";
            String[] tokens = StringUtils.split((String)artifact, (String)":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + artifact);
            }
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            if (tokens.length >= 4) {
                packaging = tokens[3];
            }
            String classifier = tokens.length == 5 ? tokens[4] : null;
            ArtifactItem artifactItem = new ArtifactItem();
            artifactItem.setGroupId(groupId);
            artifactItem.setArtifactId(artifactId);
            artifactItem.setVersion(version);
            artifactItem.setType(packaging);
            artifactItem.setClassifier(classifier);
            this.setArtifactItems(Collections.singletonList(artifactItem));
        }
    }
}

