/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Named
@Singleton
public class CopyUtil {
    private final BuildContext buildContext;
    private final Logger logger = LoggerFactory.getLogger(CopyUtil.class);

    @Inject
    public CopyUtil(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void copyArtifactFile(Artifact sourceArtifact, File destination) throws IOException, MojoExecutionException {
        File source = sourceArtifact.getFile();
        if (source.isDirectory()) {
            throw new MojoExecutionException("Artifact '" + sourceArtifact + "' has not been packaged yet (is a directory). When used on reactor artifact, copy should be executed after packaging: see MDEP-187.");
        }
        this.logger.debug("Copying artifact '{}' ({}) to {}", new Object[]{sourceArtifact, sourceArtifact.getFile(), destination});
        FileUtils.copyFile((File)source, (File)destination);
        this.buildContext.refresh(destination);
    }
}

