/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.exclusion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.exclusion.Coordinates;
import org.apache.maven.plugins.dependency.exclusion.ExclusionChecker;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyCollectionException;

@Mojo(name="analyze-exclusions", requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class AnalyzeExclusionsMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private ResolverUtil resolverUtil;
    @Component
    private MavenSession session;
    @Parameter(property="mdep.exclusion.fail", defaultValue="false")
    private boolean exclusionFail;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;
    private String projectModelId;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping execution");
            return;
        }
        this.projectModelId = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion();
        HashMap dependenciesWithExclusions = new HashMap();
        this.project.getDependencyManagement().getDependencies().forEach(dependency -> {
            Collection<Exclusion> exclusions = this.getExclusionsForDependency((Dependency)dependency);
            if (!exclusions.isEmpty()) {
                dependenciesWithExclusions.computeIfAbsent(Coordinates.coordinates(dependency), d -> new ArrayList()).addAll(exclusions);
            }
        });
        this.project.getDependencies().forEach(dependency -> {
            Collection<Exclusion> exclusions = this.getExclusionsForDependency((Dependency)dependency);
            if (!exclusions.isEmpty()) {
                dependenciesWithExclusions.computeIfAbsent(Coordinates.coordinates(dependency), d -> new ArrayList()).addAll(exclusions);
            }
        });
        if (dependenciesWithExclusions.isEmpty()) {
            this.getLog().debug((CharSequence)"No dependencies defined with exclusions - exiting");
            return;
        }
        ExclusionChecker checker = new ExclusionChecker();
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        for (Map.Entry entry : dependenciesWithExclusions.entrySet()) {
            Collection<org.eclipse.aether.graph.Dependency> actualDependencies;
            Coordinates currentCoordinates = (Coordinates)entry.getKey();
            try {
                actualDependencies = this.resolverUtil.collectDependencies(RepositoryUtils.toDependency((Dependency)currentCoordinates.getDependency(), (ArtifactTypeRegistry)artifactTypeRegistry).setExclusions(null));
            }
            catch (DependencyCollectionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            Set<Coordinates> actualCoordinates = actualDependencies.stream().map(org.eclipse.aether.graph.Dependency::getArtifact).map(a -> Coordinates.coordinates(a.getGroupId(), a.getArtifactId())).collect(Collectors.toSet());
            Set<Coordinates> exclusions = ((Collection)entry.getValue()).stream().map(Coordinates::coordinates).collect(Collectors.toSet());
            checker.check(currentCoordinates, exclusions, actualCoordinates);
        }
        if (!checker.getViolations().isEmpty()) {
            if (this.exclusionFail) {
                this.logViolations(this.project.getName(), checker.getViolations(), value -> this.getLog().error((CharSequence)value));
                throw new MojoExecutionException("Invalid exclusions found");
            }
            this.logViolations(this.project.getName(), checker.getViolations(), value -> this.getLog().warn((CharSequence)value));
        } else {
            this.getLog().info((CharSequence)"No problems with dependencies exclusions");
        }
    }

    private Collection<Exclusion> getExclusionsForDependency(Dependency dependency) {
        return dependency.getExclusions().stream().filter(this::isExclusionInProject).collect(Collectors.toList());
    }

    private boolean isExclusionInProject(Exclusion exclusion) {
        String modelId = exclusion.getLocation((Object)"").getSource().getModelId();
        return this.projectModelId.equals(modelId);
    }

    private void logViolations(String name, Map<Coordinates, List<Coordinates>> violations, Consumer<String> logger) {
        logger.accept(name + " defines following unnecessary excludes");
        violations.forEach((dependency, invalidExclusions) -> {
            logger.accept("    " + dependency);
            invalidExclusions.forEach(invalidExclusion -> logger.accept("        - " + invalidExclusion));
        });
    }
}

