/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeReactorProjectsDependencyFilter
implements Predicate<Dependency> {
    private final Logger log = LoggerFactory.getLogger(ExcludeReactorProjectsDependencyFilter.class);
    private final Set<String> reactorArtifactKeys;

    public ExcludeReactorProjectsDependencyFilter(List<MavenProject> reactorProjects) {
        this.reactorArtifactKeys = reactorProjects.stream().map(project -> ArtifactUtils.key((Artifact)project.getArtifact())).collect(Collectors.toSet());
    }

    @Override
    public boolean test(Dependency dependency) {
        String key = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
        if (this.reactorArtifactKeys.contains(key)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skipped dependency {} because it is present in the reactor", (Object)key);
            }
            return false;
        }
        return true;
    }
}

