/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.AsmModuleInfoParser;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;

@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter(property="maven.compiler.testSource")
    private String testSource;
    @Parameter(property="maven.compiler.testTarget")
    private String testTarget;
    @Parameter(property="maven.compiler.testRelease")
    private String testRelease;
    @Parameter
    private Map<String, String> testCompilerArguments;
    @Parameter
    private String testCompilerArgument;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    private File generatedTestSourcesDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true)
    private List<String> compilePath;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true)
    private List<String> testPath;
    private List<String> classpathElements;
    private List<String> modulepathElements;

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
        }
        super.execute();
    }

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Override
    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected List<String> getModulepathElements() {
        return this.modulepathElements;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void preparePaths(Set<File> sourceFiles) {
        File mainOutputDirectory = new File(this.getProject().getBuild().getOutputDirectory());
        File mainModuleInfo = new File(mainOutputDirectory, "module-info.class");
        boolean hasMainModuleDescriptor = mainModuleInfo.exists();
        boolean hasTestModuleDescriptor = false;
        for (File sourceFile : sourceFiles) {
            if (!"module-info.java".equals(sourceFile.getName())) continue;
            hasTestModuleDescriptor = true;
            break;
        }
        ArrayList<String> testScopedElements = new ArrayList<String>(this.testPath);
        testScopedElements.removeAll(this.compilePath);
        if (this.release != null) {
            if (Integer.valueOf(this.release) < 9) {
                this.modulepathElements = Collections.emptyList();
                this.classpathElements = this.testPath;
                return;
            }
        } else if (Double.valueOf(this.getTarget()) < Double.valueOf("1.9")) {
            this.modulepathElements = Collections.emptyList();
            this.classpathElements = this.testPath;
            return;
        }
        if (hasTestModuleDescriptor) {
            this.modulepathElements = this.testPath;
            this.classpathElements = Collections.emptyList();
            if (!hasMainModuleDescriptor) {
                throw new UnsupportedOperationException("Can't compile test sources when main sources are missing a module descriptor");
            }
        } else if (hasMainModuleDescriptor) {
            this.modulepathElements = this.compilePath;
            this.classpathElements = testScopedElements;
            if (this.compilerArgs == null) {
                this.compilerArgs = new ArrayList();
            }
            try {
                String moduleName = new AsmModuleInfoParser().getModuleName(mainOutputDirectory);
                this.compilerArgs.add("-Xmodule:" + moduleName);
                this.compilerArgs.add("--add-reads");
                this.compilerArgs.add(moduleName + "=ALL-UNNAMED");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse module-info: " + e.getMessage());
            }
        } else {
            this.modulepathElements = Collections.emptyList();
            this.classpathElements = this.testPath;
        }
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            this.testIncludes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, Collections.emptySet());
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add(defaultIncludePattern);
            }
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    @Override
    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    @Override
    protected String getRelease() {
        return this.testRelease == null ? this.release : this.testRelease;
    }

    @Override
    protected String getCompilerArgument() {
        return this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument;
    }

    @Override
    protected Map<String, String> getCompilerArguments() {
        return this.testCompilerArguments == null ? this.compilerArguments : this.testCompilerArguments;
    }

    @Override
    protected File getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected boolean isTestCompile() {
        return true;
    }
}

