/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.clean;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.clean.Selector;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.io.FileUtils;

class Cleaner {
    private static final boolean ON_WINDOWS = Os.isFamily((String)"windows");
    private final Logger logDebug;
    private final Logger logInfo;
    private final Logger logVerbose;
    private final Logger logWarn;

    public Cleaner(final Log log, boolean verbose) {
        this.logDebug = log == null || !log.isDebugEnabled() ? null : new Logger(){

            @Override
            public void log(CharSequence message) {
                log.debug(message);
            }
        };
        this.logInfo = log == null || !log.isInfoEnabled() ? null : new Logger(){

            @Override
            public void log(CharSequence message) {
                log.info(message);
            }
        };
        this.logWarn = log == null || !log.isWarnEnabled() ? null : new Logger(){

            @Override
            public void log(CharSequence message) {
                log.warn(message);
            }
        };
        this.logVerbose = verbose ? this.logInfo : this.logDebug;
    }

    public void delete(File basedir, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        if (!basedir.isDirectory()) {
            if (!basedir.exists()) {
                if (this.logDebug != null) {
                    this.logDebug.log("Skipping non-existing directory " + basedir);
                }
                return;
            }
            throw new IOException("Invalid base directory " + basedir);
        }
        if (this.logInfo != null) {
            this.logInfo.log("Deleting " + basedir + (selector != null ? " (" + selector + ")" : ""));
        }
        File file = followSymlinks ? basedir : basedir.getCanonicalFile();
        this.delete(file, "", selector, followSymlinks, failOnError, retryOnError);
    }

    private Result delete(File file, String pathname, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        Result result = new Result();
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            if (selector == null || selector.couldHoldSelected(pathname)) {
                File canonical;
                boolean isSymlink = FileUtils.isSymbolicLink((File)file);
                File file2 = canonical = followSymlinks ? file : file.getCanonicalFile();
                if (followSymlinks || !isSymlink) {
                    String[] filenames = canonical.list();
                    if (filenames != null) {
                        String prefix = pathname.length() > 0 ? pathname + File.separatorChar : "";
                        for (int i = filenames.length - 1; i >= 0; --i) {
                            String filename = filenames[i];
                            File child = new File(canonical, filename);
                            result.update(this.delete(child, prefix + filename, selector, followSymlinks, failOnError, retryOnError));
                        }
                    }
                } else if (this.logDebug != null) {
                    this.logDebug.log("Not recursing into symlink " + file);
                }
            } else if (this.logDebug != null) {
                this.logDebug.log("Not recursing into directory without included files " + file);
            }
        }
        if (!result.excluded && (selector == null || selector.isSelected(pathname))) {
            if (this.logVerbose != null) {
                if (isDirectory) {
                    this.logVerbose.log("Deleting directory " + file);
                } else if (file.exists()) {
                    this.logVerbose.log("Deleting file " + file);
                } else {
                    this.logVerbose.log("Deleting dangling symlink " + file);
                }
            }
            result.failures += this.delete(file, failOnError, retryOnError);
        } else {
            result.excluded = true;
        }
        return result;
    }

    private int delete(File file, boolean failOnError, boolean retryOnError) throws IOException {
        if (!file.delete()) {
            boolean deleted = false;
            if (retryOnError) {
                if (ON_WINDOWS) {
                    System.gc();
                }
                int[] delays = new int[]{50, 250, 750};
                for (int i = 0; !deleted && i < delays.length; ++i) {
                    try {
                        Thread.sleep(delays[i]);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    deleted = file.delete() || !file.exists();
                }
            } else {
                boolean bl = deleted = !file.exists();
            }
            if (!deleted) {
                if (failOnError) {
                    throw new IOException("Failed to delete " + file);
                }
                if (this.logWarn != null) {
                    this.logWarn.log("Failed to delete " + file);
                }
                return 1;
            }
        }
        return 0;
    }

    private static interface Logger {
        public void log(CharSequence var1);
    }

    private static class Result {
        private int failures;
        private boolean excluded;

        private Result() {
        }

        public void update(Result result) {
            this.failures += result.failures;
            this.excluded |= result.excluded;
        }
    }
}

