/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clean;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clean.Fileset;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class CleanMojo
extends AbstractMojo {
    private MavenProject project;
    private File directory;
    private File outputDirectory;
    private File testOutputDirectory;
    private File reportDirectory;
    private Boolean verbose;
    private List filesets;
    private boolean followSymLinks;
    private FileSetManager fileSetManager;
    private boolean skip;
    private boolean failOnError;
    private boolean excludeDefaultDirectories;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Clean is skipped.");
            return;
        }
        try {
            this.fileSetManager = new FileSetManager(this.getLog(), this.isVerbose());
            if (!this.excludeDefaultDirectories) {
                this.removeDirectory(this.directory);
                this.removeDirectory(this.outputDirectory);
                this.removeDirectory(this.testOutputDirectory);
                this.removeDirectory(this.reportDirectory);
            }
            this.removeAdditionalFilesets();
        }
        catch (MojoExecutionException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    private boolean isVerbose() {
        return this.verbose != null ? this.verbose.booleanValue() : this.getLog().isDebugEnabled();
    }

    private void removeAdditionalFilesets() throws MojoExecutionException {
        if (this.filesets != null && !this.filesets.isEmpty()) {
            Iterator it = this.filesets.iterator();
            while (it.hasNext()) {
                FileSet fileset = (FileSet)it.next();
                this.removeFileSet(fileset);
            }
        }
    }

    private void removeDirectory(File dir) throws MojoExecutionException {
        if (dir != null) {
            Fileset fs = new Fileset();
            fs.setDirectory(dir.getPath());
            fs.addInclude("**");
            fs.setFollowSymlinks(this.followSymLinks);
            this.removeFileSet(fs);
        }
    }

    private void removeFileSet(FileSet fileset) throws MojoExecutionException {
        try {
            File dir = new File(fileset.getDirectory());
            if (!dir.isAbsolute()) {
                dir = new File(this.project.getBasedir(), fileset.getDirectory());
                fileset.setDirectory(dir.getPath());
            }
            if (!dir.exists()) {
                this.getLog().debug((CharSequence)("Skipping non-existing directory: " + dir));
                return;
            }
            if (!dir.isDirectory()) {
                throw new MojoExecutionException(dir + " is not a directory.");
            }
            this.getLog().info((CharSequence)("Deleting " + fileset));
            this.fileSetManager.delete(fileset, this.failOnError);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete directory: " + fileset.getDirectory() + ". Reason: " + e.getMessage(), (Exception)e);
        }
        catch (IllegalStateException e) {
            throw new MojoExecutionException("Failed to delete directory: " + fileset.getDirectory() + ". Reason: " + e.getMessage(), (Exception)e);
        }
    }

    protected void setDirectory(File newDirectory) {
        this.directory = newDirectory;
    }

    protected void setOutputDirectory(File newOutputDirectory) {
        this.outputDirectory = newOutputDirectory;
    }

    protected void setTestOutputDirectory(File newTestOutputDirectory) {
        this.testOutputDirectory = newTestOutputDirectory;
    }

    protected void setReportDirectory(File newReportDirectory) {
        this.reportDirectory = newReportDirectory;
    }

    public void addFileset(Fileset fileset) {
        if (this.filesets == null) {
            this.filesets = new LinkedList();
        }
        this.filesets.add(fileset);
    }
}

