/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;

public class IconTool {
    public static final String INFO = "info";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final int NO_TEXT = 0;
    public static final int TEXT_SIMPLE = 1;
    public static final int TEXT_TITLE = 2;
    public static final int TEXT_ABBREV = 3;
    private final Sink sink;
    private final ResourceBundle bundle;

    public IconTool(Sink sink, ResourceBundle bundle) {
        this.sink = sink;
        this.bundle = bundle;
    }

    public void iconSeverity(String level) {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_" + level + "_sml.gif");
        this.sink.figure_();
    }

    public void iconSeverity(String level, int textType) {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_" + level + "_sml.gif");
        this.sink.figure_();
        if (textType > 0) {
            this.sink.nonBreakingSpace();
            this.sink.text(this.bundle.getString("report.checkstyle." + level + this.suffix(textType)));
        }
    }

    public void iconInfo() {
        this.iconSeverity(INFO);
    }

    public void iconInfo(int textType) {
        this.iconSeverity(INFO, textType);
    }

    public void iconWarning() {
        this.iconSeverity(WARNING);
    }

    public void iconWarning(int textType) {
        this.iconSeverity(WARNING, textType);
    }

    public void iconError() {
        this.iconSeverity(ERROR);
    }

    public void iconError(int textType) {
        this.iconSeverity(ERROR, textType);
    }

    private String suffix(int textType) {
        switch (textType) {
            case 2: {
                return "s";
            }
            case 3: {
                return "s.abbrev";
            }
        }
        return "";
    }
}

