/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.trac;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.project.MavenProject;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.codehaus.plexus.util.StringUtils;

public class TracDownloader {
    private MavenProject project;
    private String query;
    private String tracPassword;
    private String tracUser;

    private Issue createIssue(Object[] ticketObj) {
        Issue issue = new Issue();
        issue.setId(String.valueOf(ticketObj[0]));
        issue.setKey(String.valueOf(ticketObj[0]));
        issue.setLink(this.getUrl() + "/ticket/" + String.valueOf(ticketObj[0]));
        issue.setCreated(this.parseDate(String.valueOf(ticketObj[1])));
        issue.setUpdated(this.parseDate(String.valueOf(ticketObj[2])));
        Map attributes = (Map)ticketObj[3];
        issue.setType((String)attributes.get("type"));
        issue.setSummary((String)attributes.get("summary"));
        issue.setStatus((String)attributes.get("status"));
        issue.setResolution((String)attributes.get("resolution"));
        issue.setAssignee((String)attributes.get("owner"));
        issue.addFixVersion((String)attributes.get("milestone"));
        issue.setPriority((String)attributes.get("priority"));
        issue.setReporter((String)attributes.get("reporter"));
        issue.addComponent((String)attributes.get("component"));
        return issue;
    }

    public List<Issue> getIssueList() throws MalformedURLException, XmlRpcException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(this.getUrl() + "/login/xmlrpc"));
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("The Trac URL is incorrect.");
        }
        config.setBasicUserName(this.tracUser);
        config.setBasicPassword(this.tracPassword);
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(client));
        String qstr = "";
        if (!StringUtils.isEmpty((String)this.query)) {
            qstr = this.query;
        }
        Object[] params = new Object[]{qstr};
        ArrayList<Issue> issueList = new ArrayList<Issue>();
        try {
            Object[] queryResult;
            for (Object aQueryResult : queryResult = (Object[])client.execute("ticket.query", params)) {
                params = new Object[]{aQueryResult};
                Object[] ticketGetResult = (Object[])client.execute("ticket.get", params);
                issueList.add(this.createIssue(ticketGetResult));
            }
        }
        catch (XmlRpcException e) {
            throw new XmlRpcException("XmlRpc Error.", (Throwable)e);
        }
        return issueList;
    }

    private String getUrl() {
        String url = this.project.getIssueManagement().getUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setTracPassword(String tracPassword) {
        this.tracPassword = tracPassword;
    }

    public void setTracUser(String tracUser) {
        this.tracUser = tracUser;
    }

    private Date parseDate(String timeCreated) throws RuntimeException {
        try {
            long millis = Long.parseLong(timeCreated);
            Calendar cld = Calendar.getInstance();
            cld.setTimeInMillis(millis * 1000L);
            return cld.getTime();
        }
        catch (NumberFormatException e) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
            try {
                return format.parse(timeCreated);
            }
            catch (ParseException e1) {
                throw new RuntimeException("Failed to parse date '" + timeCreated + "' as a date.", e1);
            }
        }
    }
}

