// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.9.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugins.assembly.model;

/**
 * 
 *         
 *         An assembly defines a collection of files usually
 * distributed in an
 *         archive format such as zip, tar, or tar.gz that is
 * generated from a
 *         project.  For example, a project could produce a ZIP
 * assembly which
 *         contains a project's JAR artifact in the root directory,
 * the
 *         runtime dependencies in a lib/ directory, and a shell
 * script to launch
 *         a stand-alone application.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Assembly
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Sets the id of this assembly. This is a symbolic
     * name for a
     *             particular assembly of files from this project.
     * Also, aside from
     *             being used to distinctly name the assembled
     * package by attaching
     *             its value to the generated archive, the id is
     * used as your
     *             artifact's classifier when deploying.
     *           
     */
    private String id;

    /**
     * Field formats.
     */
    private java.util.List<String> formats;

    /**
     * 
     *             Includes a base directory in the final archive.
     * For example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory.
     *           
     */
    private boolean includeBaseDirectory = true;

    /**
     * 
     *             Sets the base directory of the resulting
     * assembly archive. If this is not
     *             set and includeBaseDirectory == true,
     * ${project.build.finalName} will be used instead.
     *             (Since 2.2-beta-1)
     *           .
     */
    private String baseDirectory;

    /**
     * 
     *             Includes a site directory in the final archive.
     * The site directory
     *             location of a project is determined by the
     * siteDirectory parameter
     *             of the Assembly Plugin.
     *           
     */
    private boolean includeSiteDirectory = false;

    /**
     * Field containerDescriptorHandlers.
     */
    private java.util.List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers;

    /**
     * Field moduleSets.
     */
    private java.util.List<ModuleSet> moduleSets;

    /**
     * Field fileSets.
     */
    private java.util.List<FileSet> fileSets;

    /**
     * Field files.
     */
    private java.util.List<FileItem> files;

    /**
     * Field dependencySets.
     */
    private java.util.List<DependencySet> dependencySets;

    /**
     * Field repositories.
     */
    private java.util.List<Repository> repositories;

    /**
     * Field componentDescriptors.
     */
    private java.util.List<String> componentDescriptors;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addComponentDescriptor.
     * 
     * @param string
     */
    public void addComponentDescriptor( String string )
    {
        getComponentDescriptors().add( string );
    } //-- void addComponentDescriptor( String )

    /**
     * Method addContainerDescriptorHandler.
     * 
     * @param containerDescriptorHandlerConfig
     */
    public void addContainerDescriptorHandler( ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig )
    {
        getContainerDescriptorHandlers().add( containerDescriptorHandlerConfig );
    } //-- void addContainerDescriptorHandler( ContainerDescriptorHandlerConfig )

    /**
     * Method addDependencySet.
     * 
     * @param dependencySet
     */
    public void addDependencySet( DependencySet dependencySet )
    {
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet( DependencySet )

    /**
     * Method addFile.
     * 
     * @param fileItem
     */
    public void addFile( FileItem fileItem )
    {
        getFiles().add( fileItem );
    } //-- void addFile( FileItem )

    /**
     * Method addFileSet.
     * 
     * @param fileSet
     */
    public void addFileSet( FileSet fileSet )
    {
        getFileSets().add( fileSet );
    } //-- void addFileSet( FileSet )

    /**
     * Method addFormat.
     * 
     * @param string
     */
    public void addFormat( String string )
    {
        getFormats().add( string );
    } //-- void addFormat( String )

    /**
     * Method addModuleSet.
     * 
     * @param moduleSet
     */
    public void addModuleSet( ModuleSet moduleSet )
    {
        getModuleSets().add( moduleSet );
    } //-- void addModuleSet( ModuleSet )

    /**
     * Method addRepository.
     * 
     * @param repository
     */
    public void addRepository( Repository repository )
    {
        getRepositories().add( repository );
    } //-- void addRepository( Repository )

    /**
     * Get sets the base directory of the resulting assembly
     * archive. If this is not
     *             set and includeBaseDirectory == true,
     * ${project.build.finalName} will be used instead.
     *             (Since 2.2-beta-1).
     * 
     * @return String
     */
    public String getBaseDirectory()
    {
        return this.baseDirectory;
    } //-- String getBaseDirectory()

    /**
     * Method getComponentDescriptors.
     * 
     * @return List
     */
    public java.util.List<String> getComponentDescriptors()
    {
        if ( this.componentDescriptors == null )
        {
            this.componentDescriptors = new java.util.ArrayList<String>();
        }

        return this.componentDescriptors;
    } //-- java.util.List<String> getComponentDescriptors()

    /**
     * Method getContainerDescriptorHandlers.
     * 
     * @return List
     */
    public java.util.List<ContainerDescriptorHandlerConfig> getContainerDescriptorHandlers()
    {
        if ( this.containerDescriptorHandlers == null )
        {
            this.containerDescriptorHandlers = new java.util.ArrayList<ContainerDescriptorHandlerConfig>();
        }

        return this.containerDescriptorHandlers;
    } //-- java.util.List<ContainerDescriptorHandlerConfig> getContainerDescriptorHandlers()

    /**
     * Method getDependencySets.
     * 
     * @return List
     */
    public java.util.List<DependencySet> getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList<DependencySet>();
        }

        return this.dependencySets;
    } //-- java.util.List<DependencySet> getDependencySets()

    /**
     * Method getFileSets.
     * 
     * @return List
     */
    public java.util.List<FileSet> getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList<FileSet>();
        }

        return this.fileSets;
    } //-- java.util.List<FileSet> getFileSets()

    /**
     * Method getFiles.
     * 
     * @return List
     */
    public java.util.List<FileItem> getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList<FileItem>();
        }

        return this.files;
    } //-- java.util.List<FileItem> getFiles()

    /**
     * Method getFormats.
     * 
     * @return List
     */
    public java.util.List<String> getFormats()
    {
        if ( this.formats == null )
        {
            this.formats = new java.util.ArrayList<String>();
        }

        return this.formats;
    } //-- java.util.List<String> getFormats()

    /**
     * Get sets the id of this assembly. This is a symbolic name
     * for a
     *             particular assembly of files from this project.
     * Also, aside from
     *             being used to distinctly name the assembled
     * package by attaching
     *             its value to the generated archive, the id is
     * used as your
     *             artifact's classifier when deploying.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Method getModuleSets.
     * 
     * @return List
     */
    public java.util.List<ModuleSet> getModuleSets()
    {
        if ( this.moduleSets == null )
        {
            this.moduleSets = new java.util.ArrayList<ModuleSet>();
        }

        return this.moduleSets;
    } //-- java.util.List<ModuleSet> getModuleSets()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List<Repository> getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList<Repository>();
        }

        return this.repositories;
    } //-- java.util.List<Repository> getRepositories()

    /**
     * Get includes a base directory in the final archive. For
     * example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory.
     * 
     * @return boolean
     */
    public boolean isIncludeBaseDirectory()
    {
        return this.includeBaseDirectory;
    } //-- boolean isIncludeBaseDirectory()

    /**
     * Get includes a site directory in the final archive. The site
     * directory
     *             location of a project is determined by the
     * siteDirectory parameter
     *             of the Assembly Plugin.
     * 
     * @return boolean
     */
    public boolean isIncludeSiteDirectory()
    {
        return this.includeSiteDirectory;
    } //-- boolean isIncludeSiteDirectory()

    /**
     * Method removeComponentDescriptor.
     * 
     * @param string
     */
    public void removeComponentDescriptor( String string )
    {
        getComponentDescriptors().remove( string );
    } //-- void removeComponentDescriptor( String )

    /**
     * Method removeContainerDescriptorHandler.
     * 
     * @param containerDescriptorHandlerConfig
     */
    public void removeContainerDescriptorHandler( ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig )
    {
        getContainerDescriptorHandlers().remove( containerDescriptorHandlerConfig );
    } //-- void removeContainerDescriptorHandler( ContainerDescriptorHandlerConfig )

    /**
     * Method removeDependencySet.
     * 
     * @param dependencySet
     */
    public void removeDependencySet( DependencySet dependencySet )
    {
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet( DependencySet )

    /**
     * Method removeFile.
     * 
     * @param fileItem
     */
    public void removeFile( FileItem fileItem )
    {
        getFiles().remove( fileItem );
    } //-- void removeFile( FileItem )

    /**
     * Method removeFileSet.
     * 
     * @param fileSet
     */
    public void removeFileSet( FileSet fileSet )
    {
        getFileSets().remove( fileSet );
    } //-- void removeFileSet( FileSet )

    /**
     * Method removeFormat.
     * 
     * @param string
     */
    public void removeFormat( String string )
    {
        getFormats().remove( string );
    } //-- void removeFormat( String )

    /**
     * Method removeModuleSet.
     * 
     * @param moduleSet
     */
    public void removeModuleSet( ModuleSet moduleSet )
    {
        getModuleSets().remove( moduleSet );
    } //-- void removeModuleSet( ModuleSet )

    /**
     * Method removeRepository.
     * 
     * @param repository
     */
    public void removeRepository( Repository repository )
    {
        getRepositories().remove( repository );
    } //-- void removeRepository( Repository )

    /**
     * Set sets the base directory of the resulting assembly
     * archive. If this is not
     *             set and includeBaseDirectory == true,
     * ${project.build.finalName} will be used instead.
     *             (Since 2.2-beta-1).
     * 
     * @param baseDirectory
     */
    public void setBaseDirectory( String baseDirectory )
    {
        this.baseDirectory = baseDirectory;
    } //-- void setBaseDirectory( String )

    /**
     * Set specifies the shared components xml file locations to
     * include in the
     *             assembly. The locations specified must be
     * relative to the base location
     *             of the descriptor. If the descriptor was found
     * via a &lt;descriptorRef/&gt;
     *             element in the
     *             classpath, any components it specifies will also
     * be found on the classpath.
     *             If it is found by pathname via a
     * &lt;descriptor/&gt; element
     *             the value here will be interpreted
     *             as a path relative to the project basedir.
     *             When multiple componentDescriptors are found,
     * their
     *             contents are merged. Check out the <a
     * href="assembly-component.html">
     *             descriptor components</a> for more information.
     * A
     *             componentDescriptor is specified by providing
     * one or more of
     *             &lt;componentDescriptor&gt; subelements.
     * 
     * @param componentDescriptors
     */
    public void setComponentDescriptors( java.util.List<String> componentDescriptors )
    {
        this.componentDescriptors = componentDescriptors;
    } //-- void setComponentDescriptors( java.util.List )

    /**
     * Set set of components which filter various container
     * descriptors out of
     *             the normal archive stream, so they can be
     * aggregated then added.
     * 
     * @param containerDescriptorHandlers
     */
    public void setContainerDescriptorHandlers( java.util.List<ContainerDescriptorHandlerConfig> containerDescriptorHandlers )
    {
        this.containerDescriptorHandlers = containerDescriptorHandlers;
    } //-- void setContainerDescriptorHandlers( java.util.List )

    /**
     * Set specifies which dependencies to include in the assembly.
     * A
     *             dependencySet is specified by providing one or
     * more of
     *             &lt;dependencySet&gt; subelements.
     * 
     * @param dependencySets
     */
    public void setDependencySets( java.util.List<DependencySet> dependencySets )
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets( java.util.List )

    /**
     * Set specifies which groups of files to include in the
     * assembly. A
     *             fileSet is specified by providing one or more of
     * &lt;fileSet&gt;
     *             subelements.
     * 
     * @param fileSets
     */
    public void setFileSets( java.util.List<FileSet> fileSets )
    {
        this.fileSets = fileSets;
    } //-- void setFileSets( java.util.List )

    /**
     * Set specifies which single files to include in the assembly.
     * A file
     *             is specified by providing one or more of
     * &lt;file&gt;
     *             subelements.
     * 
     * @param files
     */
    public void setFiles( java.util.List<FileItem> files )
    {
        this.files = files;
    } //-- void setFiles( java.util.List )

    /**
     * Set specifies the formats of the assembly.
     * 
     *             It is often better to specify the formats via
     * the goal parameter rather
     *             than here. For example, that allows different
     * profiles to generate
     *             different types of archives.
     * 
     *             Multiple formats can be
     *             supplied and the Assembly Plugin will generate
     * an archive for each
     *             of the desired formats. When deploying your
     * project, all file formats
     *             specified will also be deployed. A format is
     * specified by supplying
     *             one of the following values in a &lt;format&gt;
     * subelement:
     *             <ul>
     *               <li><b>"zip"</b> - Creates a ZIP file
     * format</li>
     *               <li><b>"tar"</b> - Creates a TAR format</li>
     *               <li><b>"tar.gz"</b> or <b>"tgz"</b> - Creates
     * a gzip'd TAR format</li>
     *               <li><b>"tar.bz2"</b> or <b>"tbz2"</b> -
     * Creates a bzip'd TAR format</li>
     *               <li><b>"tar.snappy"</b> - Creates a snappy'd
     * TAR format</li>
     *               <li><b>"tar.xz"</b> or <b>"txz"</b> - Creates
     * a xz'd TAR format</li>
     *               <li><b>"jar"</b> - Creates a JAR format</li>
     *               <li><b>"dir"</b> - Creates an exploded
     * directory format</li>
     *               <li><b>"war"</b> - Creates a WAR format</li>
     *             </ul>
     * 
     * @param formats
     */
    public void setFormats( java.util.List<String> formats )
    {
        this.formats = formats;
    } //-- void setFormats( java.util.List )

    /**
     * Set sets the id of this assembly. This is a symbolic name
     * for a
     *             particular assembly of files from this project.
     * Also, aside from
     *             being used to distinctly name the assembled
     * package by attaching
     *             its value to the generated archive, the id is
     * used as your
     *             artifact's classifier when deploying.
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set includes a base directory in the final archive. For
     * example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory.
     * 
     * @param includeBaseDirectory
     */
    public void setIncludeBaseDirectory( boolean includeBaseDirectory )
    {
        this.includeBaseDirectory = includeBaseDirectory;
    } //-- void setIncludeBaseDirectory( boolean )

    /**
     * Set includes a site directory in the final archive. The site
     * directory
     *             location of a project is determined by the
     * siteDirectory parameter
     *             of the Assembly Plugin.
     * 
     * @param includeSiteDirectory
     */
    public void setIncludeSiteDirectory( boolean includeSiteDirectory )
    {
        this.includeSiteDirectory = includeSiteDirectory;
    } //-- void setIncludeSiteDirectory( boolean )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set specifies which module files to include in the assembly.
     * A moduleSet
     *             is specified by providing one or more of
     * &lt;moduleSet&gt;
     *             subelements.
     * 
     * @param moduleSets
     */
    public void setModuleSets( java.util.List<ModuleSet> moduleSets )
    {
        this.moduleSets = moduleSets;
    } //-- void setModuleSets( java.util.List )

    /**
     * Set specifies which repository files to include in the
     * assembly. A
     *             repository is specified by providing one or more
     * of
     *             &lt;repository&gt; subelements.
     * 
     * @param repositories
     */
    public void setRepositories( java.util.List<Repository> repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )

}
