/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugins.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugins.assembly.io.AssemblyReadException;
import org.apache.maven.plugins.assembly.io.AssemblyReader;
import org.apache.maven.plugins.assembly.io.PrefixedClasspathLocatorStrategy;
import org.apache.maven.plugins.assembly.io.RelativeFileLocatorStrategy;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.Component;
import org.apache.maven.plugins.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.Repository;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Writer;
import org.apache.maven.plugins.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.plugins.assembly.resolved.AssemblyId;
import org.apache.maven.plugins.assembly.utils.InterpolationConstants;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.io.location.ClasspathResourceLocatorStrategy;
import org.apache.maven.shared.io.location.FileLocatorStrategy;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.location.Locator;
import org.apache.maven.shared.io.location.LocatorStrategy;
import org.apache.maven.shared.utils.ReaderFactory;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.codehaus.plexus.interpolation.fixed.InterpolationState;
import org.codehaus.plexus.interpolation.fixed.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedPropertiesValueSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@org.codehaus.plexus.component.annotations.Component(role=AssemblyReader.class)
public class DefaultAssemblyReader
extends AbstractLogEnabled
implements AssemblyReader {
    public static FixedStringSearchInterpolator createProjectInterpolator(MavenProject project) {
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, project.getProperties(), true), new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)project, true)});
    }

    @Override
    public List<Assembly> readAssemblies(AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Locator locator = new Locator();
        ArrayList<RelativeFileLocatorStrategy> strategies = new ArrayList<RelativeFileLocatorStrategy>();
        strategies.add(new RelativeFileLocatorStrategy(configSource.getBasedir()));
        strategies.add((RelativeFileLocatorStrategy)new FileLocatorStrategy());
        ArrayList<PrefixedClasspathLocatorStrategy> refStrategies = new ArrayList<PrefixedClasspathLocatorStrategy>();
        refStrategies.add(new PrefixedClasspathLocatorStrategy("/assemblies/"));
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        String[] descriptors = configSource.getDescriptors();
        String[] descriptorRefs = configSource.getDescriptorReferences();
        File descriptorSourceDirectory = configSource.getDescriptorSourceDirectory();
        if (descriptors != null && descriptors.length > 0) {
            locator.setStrategies(strategies);
            for (String descriptor1 : descriptors) {
                this.getLogger().info("Reading assembly descriptor: " + descriptor1);
                this.addAssemblyFromDescriptor(descriptor1, locator, configSource, assemblies);
            }
        }
        if (descriptorRefs != null && descriptorRefs.length > 0) {
            locator.setStrategies(refStrategies);
            for (String descriptorRef : descriptorRefs) {
                this.addAssemblyForDescriptorReference(descriptorRef, configSource, assemblies);
            }
        }
        if (descriptorSourceDirectory != null && descriptorSourceDirectory.isDirectory()) {
            String[] paths;
            locator.setStrategies(Collections.singletonList(new RelativeFileLocatorStrategy(descriptorSourceDirectory)));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(descriptorSourceDirectory);
            scanner.setIncludes(new String[]{"**/*.xml"});
            scanner.addDefaultExcludes();
            scanner.scan();
            for (String path : paths = scanner.getIncludedFiles()) {
                this.addAssemblyFromDescriptor(path, locator, configSource, assemblies);
            }
        }
        if (assemblies.isEmpty()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptors per configuration. See messages above for specifics.");
            } else {
                throw new AssemblyReadException("No assembly descriptors found.");
            }
        }
        HashSet<String> ids = new HashSet<String>();
        for (Assembly assembly : assemblies) {
            if (ids.add(assembly.getId())) continue;
            this.getLogger().warn("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    @Override
    public Assembly getAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyForDescriptorReference(ref, configSource, new ArrayList<Assembly>(1));
    }

    @Override
    public Assembly getAssemblyFromDescriptorFile(File file, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyFromDescriptorFile(file, configSource, new ArrayList<Assembly>(1));
    }

    private Assembly addAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/assemblies/" + ref + ".xml");
        if (resourceAsStream == null) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor with ID '" + ref + "' per configuration.");
                return null;
            }
            throw new AssemblyReadException("Descriptor with ID '" + ref + "' not found");
        }
        Reader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((InputStream)resourceAsStream);
            Assembly assembly = this.readAssembly(reader, ref, null, configSource);
            reader.close();
            reader = null;
            assemblies.add(assembly);
            Assembly assembly2 = assembly;
            return assembly2;
        }
        catch (IOException e) {
            throw new AssemblyReadException("Problem with descriptor with ID '" + ref + "'", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private Assembly addAssemblyFromDescriptorFile(File descriptor, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        if (!descriptor.exists()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor: '" + descriptor + "' per configuration.");
                return null;
            }
            throw new AssemblyReadException("Descriptor: '" + descriptor + "' not found");
        }
        Reader r = null;
        try {
            r = ReaderFactory.newXmlReader((File)descriptor);
            Assembly assembly = this.readAssembly(r, descriptor.getAbsolutePath(), descriptor.getParentFile(), configSource);
            r.close();
            r = null;
            assemblies.add(assembly);
            Assembly assembly2 = assembly;
            return assembly2;
        }
        catch (IOException e) {
            throw new AssemblyReadException("Error reading assembly descriptor: " + descriptor, e);
        }
        finally {
            IOUtil.close((Reader)r);
        }
    }

    private Assembly addAssemblyFromDescriptor(String spec, Locator locator, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Location location = locator.resolve(spec);
        if (location == null) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor with ID '" + spec + "' per configuration.\nLocator output was:\n\n" + locator.getMessageHolder().render());
                return null;
            }
            throw new AssemblyReadException("Error locating assembly descriptor: " + spec + "\n\n" + locator.getMessageHolder().render());
        }
        Reader r = null;
        try {
            r = ReaderFactory.newXmlReader((InputStream)location.getInputStream());
            File dir = null;
            if (location.getFile() != null) {
                dir = location.getFile().getParentFile();
            }
            Assembly assembly = this.readAssembly(r, spec, dir, configSource);
            r.close();
            r = null;
            assemblies.add(assembly);
            Assembly assembly2 = assembly;
            return assembly2;
        }
        catch (IOException e) {
            throw new AssemblyReadException("Error reading assembly descriptor: " + spec, e);
        }
        finally {
            IOUtil.close((Reader)r);
        }
    }

    public Assembly readAssembly(Reader reader, String locationDescription, File assemblyDir, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        MavenProject project = configSource.getProject();
        try {
            InterpolationState is = new InterpolationState();
            PrefixAwareRecursionInterceptor interceptor = new PrefixAwareRecursionInterceptor(InterpolationConstants.PROJECT_PREFIXES, true);
            is.setRecursionInterceptor((RecursionInterceptor)interceptor);
            FixedStringSearchInterpolator interpolator = AssemblyInterpolator.fullInterpolator(project, DefaultAssemblyReader.createProjectInterpolator(project), configSource);
            AssemblyXpp3Reader.ContentTransformer transformer = AssemblyInterpolator.assemblyInterpolator(interpolator, is, this.getLogger());
            AssemblyXpp3Reader r = new AssemblyXpp3Reader(transformer);
            assembly = r.read(reader);
            ComponentXpp3Reader.ContentTransformer ctrans = AssemblyInterpolator.componentInterpolator(interpolator, is, this.getLogger());
            this.mergeComponentsWithMainAssembly(assembly, assemblyDir, configSource, ctrans);
            this.debugPrintAssembly("After assembly is interpolated:", assembly);
            AssemblyInterpolator.checkErrors(AssemblyId.createAssemblyId(assembly), is, this.getLogger());
            reader.close();
            reader = null;
        }
        catch (IOException | XmlPullParserException e) {
            throw new AssemblyReadException("Error reading descriptor: " + locationDescription + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly, configSource);
        }
        return assembly;
    }

    private void debugPrintAssembly(String message, Assembly assembly) {
        StringWriter sWriter = new StringWriter();
        try {
            new AssemblyXpp3Writer().write(sWriter, assembly);
        }
        catch (IOException e) {
            this.getLogger().debug("Failed to print debug message with assembly descriptor listing, and message: " + message, (Throwable)e);
        }
        this.getLogger().debug(message + "\n\n" + sWriter.toString() + "\n\n");
    }

    protected void mergeComponentsWithMainAssembly(Assembly assembly, File assemblyDir, AssemblerConfigurationSource configSource, ComponentXpp3Reader.ContentTransformer transformer) throws AssemblyReadException {
        Locator locator = new Locator();
        if (assemblyDir != null && assemblyDir.exists() && assemblyDir.isDirectory()) {
            locator.addStrategy((LocatorStrategy)new RelativeFileLocatorStrategy(assemblyDir));
        }
        locator.addStrategy((LocatorStrategy)new RelativeFileLocatorStrategy(configSource.getBasedir()));
        locator.addStrategy((LocatorStrategy)new FileLocatorStrategy());
        locator.addStrategy((LocatorStrategy)new ClasspathResourceLocatorStrategy());
        AssemblyExpressionEvaluator aee = new AssemblyExpressionEvaluator(configSource);
        List<String> componentLocations = assembly.getComponentDescriptors();
        for (String location : componentLocations) {
            try {
                location = aee.evaluate(location).toString();
            }
            catch (Exception eee) {
                this.getLogger().error("Error interpolating componentDescriptor: " + location, (Throwable)eee);
            }
            Location resolvedLocation = locator.resolve(location);
            if (resolvedLocation == null) {
                throw new AssemblyReadException("Failed to locate component descriptor: " + location);
            }
            Component component = null;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(resolvedLocation.getInputStream());
                component = new ComponentXpp3Reader(transformer).read(reader);
            }
            catch (IOException | XmlPullParserException e) {
                try {
                    throw new AssemblyReadException("Error reading component descriptor: " + location + " (resolved to: " + resolvedLocation.getSpecification() + ")", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
            this.mergeComponentWithAssembly(component, assembly);
        }
    }

    protected void mergeComponentWithAssembly(Component component, Assembly assembly) {
        List<ContainerDescriptorHandlerConfig> containerHandlerDescriptors = component.getContainerDescriptorHandlers();
        for (ContainerDescriptorHandlerConfig cfg : containerHandlerDescriptors) {
            assembly.addContainerDescriptorHandler(cfg);
        }
        List<DependencySet> dependencySetList = component.getDependencySets();
        for (DependencySet dependencySet : dependencySetList) {
            assembly.addDependencySet(dependencySet);
        }
        List<FileSet> fileSetList = component.getFileSets();
        for (FileSet fileSet : fileSetList) {
            assembly.addFileSet(fileSet);
        }
        List<FileItem> fileList = component.getFiles();
        for (FileItem fileItem : fileList) {
            assembly.addFile(fileItem);
        }
        List<Repository> repositoriesList = component.getRepositories();
        for (Repository repository : repositoriesList) {
            assembly.addRepository(repository);
        }
        List<ModuleSet> moduleSets = component.getModuleSets();
        for (ModuleSet moduleSet : moduleSets) {
            assembly.addModuleSet(moduleSet);
        }
    }

    @Override
    public void includeSiteInAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        File siteDirectory = configSource.getSiteDirectory();
        if (!siteDirectory.exists()) {
            throw new InvalidAssemblerConfigurationException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        this.getLogger().info("Adding site directory to assembly : " + siteDirectory);
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "assemblyReader-internal");
            this.enableLogging(logger);
        }
        return logger;
    }
}

