/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.UnpackOptions;

public class ModuleBinaries
implements Serializable {
    private String outputDirectory;
    private List<String> includes;
    private List<String> excludes;
    private String fileMode;
    private String directoryMode;
    private String attachmentClassifier;
    private boolean includeDependencies = true;
    private List<DependencySet> dependencySets;
    private boolean unpack = true;
    private UnpackOptions unpackOptions;
    private String outputFileNameMapping = "${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}";

    public void addDependencySet(DependencySet dependencySet) {
        this.getDependencySets().add(dependencySet);
    }

    public void addExclude(String string) {
        this.getExcludes().add(string);
    }

    public void addInclude(String string) {
        this.getIncludes().add(string);
    }

    public String getAttachmentClassifier() {
        return this.attachmentClassifier;
    }

    public List<DependencySet> getDependencySets() {
        if (this.dependencySets == null) {
            this.dependencySets = new ArrayList<DependencySet>();
        }
        return this.dependencySets;
    }

    public String getDirectoryMode() {
        return this.directoryMode;
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        return this.excludes;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public List<String> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        return this.includes;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getOutputFileNameMapping() {
        return this.outputFileNameMapping;
    }

    public UnpackOptions getUnpackOptions() {
        return this.unpackOptions;
    }

    public boolean isIncludeDependencies() {
        return this.includeDependencies;
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    public void removeDependencySet(DependencySet dependencySet) {
        this.getDependencySets().remove(dependencySet);
    }

    public void removeExclude(String string) {
        this.getExcludes().remove(string);
    }

    public void removeInclude(String string) {
        this.getIncludes().remove(string);
    }

    public void setAttachmentClassifier(String attachmentClassifier) {
        this.attachmentClassifier = attachmentClassifier;
    }

    public void setDependencySets(List<DependencySet> dependencySets) {
        this.dependencySets = dependencySets;
    }

    public void setDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setOutputFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void setUnpackOptions(UnpackOptions unpackOptions) {
        this.unpackOptions = unpackOptions;
    }
}

