/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AddArtifactTask
implements ArchiverTask {
    public static final String[] DEFAULT_INCLUDES_ARRAY = new String[]{"**/*"};
    private String directoryMode;
    private String fileMode;
    private boolean unpack = false;
    private List includes;
    private List excludes;
    private final Artifact artifact;
    private MavenProject project;
    private String outputDirectory;
    private String outputFileNameMapping;
    private final Logger logger;
    private String artifactExpressionPrefix = "artifact.";

    public AddArtifactTask(Artifact artifact, Logger logger) {
        this.artifact = artifact;
        this.logger = logger;
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        if (this.artifact.getFile() != null && archiver.getDestFile() != null && this.artifact.getFile().equals(archiver.getDestFile())) {
            File tempRoot = configSource.getTemporaryRootDirectory();
            File tempArtifactFile = new File(tempRoot, this.artifact.getFile().getName());
            this.logger.warn("Artifact: " + this.artifact.getId() + " references the same file as the assembly destination file. Moving it to a temporary location for inclusion.");
            try {
                FileUtils.copyFile((File)this.artifact.getFile(), (File)tempArtifactFile);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error moving artifact file: '" + this.artifact.getFile() + "' to temporary location: " + tempArtifactFile + ". Reason: " + e.getMessage(), e);
            }
            this.artifact.setFile(tempArtifactFile);
        }
        String destDirectory = this.outputDirectory;
        destDirectory = AssemblyFormatUtils.getOutputDirectory(destDirectory, configSource.getProject(), this.project, configSource.getFinalName(), this.artifactExpressionPrefix);
        if (this.unpack) {
            Object[] includesArray;
            String outputLocation = destDirectory;
            if (outputLocation.length() > 0 && !outputLocation.endsWith("/")) {
                outputLocation = outputLocation + "/";
            }
            if ((includesArray = TypeConversionUtils.toStringArray(this.includes)) == null) {
                includesArray = DEFAULT_INCLUDES_ARRAY;
            }
            Object[] excludesArray = TypeConversionUtils.toStringArray(this.excludes);
            int oldDirMode = archiver.getDefaultDirectoryMode();
            int oldFileMode = archiver.getDefaultFileMode();
            this.logger.debug("Unpacking artifact: " + this.artifact.getId() + " to assembly location: " + outputLocation + ".");
            try {
                File artifactFile;
                if (this.fileMode != null) {
                    archiver.setDefaultFileMode(TypeConversionUtils.modeToInt(this.fileMode, this.logger));
                }
                if (this.directoryMode != null) {
                    archiver.setDefaultDirectoryMode(TypeConversionUtils.modeToInt(this.directoryMode, this.logger));
                }
                if ((artifactFile = this.artifact.getFile()) == null) {
                    this.logger.warn("Skipping artifact: " + this.artifact.getId() + "; it does not have an associated file or directory.");
                }
                if (artifactFile.isDirectory()) {
                    this.logger.debug("Adding artifact directory contents for: " + this.artifact + " to: " + outputLocation);
                    archiver.addDirectory(artifactFile, outputLocation, (String[])includesArray, (String[])excludesArray);
                }
                this.logger.debug("Unpacking artifact contents for: " + this.artifact + " to: " + outputLocation);
                this.logger.debug("includes:\n" + StringUtils.join((Object[])includesArray, (String)"\n") + "\n");
                this.logger.debug("excludes:\n" + (excludesArray == null ? "none" : StringUtils.join((Object[])excludesArray, (String)"\n")) + "\n");
                archiver.addArchivedFileSet(artifactFile, outputLocation, (String[])includesArray, (String[])excludesArray);
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file-set for '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
            }
            finally {
                archiver.setDefaultDirectoryMode(oldDirMode);
                archiver.setDefaultFileMode(oldFileMode);
            }
        } else {
            String fileNameMapping = AssemblyFormatUtils.evaluateFileNameMapping(this.outputFileNameMapping, this.artifact, configSource.getProject(), this.project, this.artifactExpressionPrefix);
            String outputLocation = destDirectory + fileNameMapping;
            try {
                File artifactFile = this.artifact.getFile();
                this.logger.debug("Adding artifact: " + this.artifact.getId() + " with file: " + artifactFile + " to assembly location: " + outputLocation + ".");
                if (this.fileMode != null) {
                    int mode = TypeConversionUtils.modeToInt(this.fileMode, this.logger);
                    archiver.addFile(artifactFile, outputLocation, mode);
                } else {
                    archiver.addFile(artifactFile, outputLocation);
                }
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
            }
        }
    }

    public void setDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public void setExcludes(List excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public void setOutputDirectory(String outputDirectory, String defaultOutputDirectory) {
        this.setOutputDirectory(outputDirectory == null ? defaultOutputDirectory : outputDirectory);
    }

    public void setFileNameMapping(String outputFileNameMapping, String defaultOutputFileNameMapping) {
        this.setFileNameMapping(outputFileNameMapping == null ? defaultOutputFileNameMapping : outputFileNameMapping);
    }

    public void setArtifactExpressionPrefix(String artifactExpressionPrefix) {
        this.artifactExpressionPrefix = artifactExpressionPrefix;
    }
}

