/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.artifact.buildinfo.BuildInfoWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;
import org.eclipse.aether.AbstractForwardingRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

class ReferenceBuildinfoUtil {
    private static final Set<String> JAR_TYPES;
    private final Log log;
    private final File referenceDir;
    private final Map<Artifact, String> artifacts;
    private final ArtifactFactory artifactFactory;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RuntimeInformation rtInformation;

    ReferenceBuildinfoUtil(Log log, File referenceDir, Map<Artifact, String> artifacts, ArtifactFactory artifactFactory, RepositorySystem repoSystem, RepositorySystemSession repoSession, ArtifactHandlerManager artifactHandlerManager, RuntimeInformation rtInformation) {
        this.log = log;
        this.referenceDir = referenceDir;
        this.artifacts = artifacts;
        this.artifactFactory = artifactFactory;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.artifactHandlerManager = artifactHandlerManager;
        this.rtInformation = rtInformation;
    }

    File downloadOrCreateReferenceBuildinfo(RemoteRepository repo, MavenProject project, File buildinfoFile, boolean mono) throws MojoExecutionException {
        File referenceBuildinfo = this.downloadReferenceBuildinfo(repo, project);
        if (referenceBuildinfo != null) {
            this.log.warn((CharSequence)"dropping downloaded reference buildinfo because it may be generated from different maven-artifact-plugin release...");
            referenceBuildinfo = null;
        }
        String javaVersion = null;
        String osName = null;
        String currentJavaVersion = null;
        String currentOsName = null;
        HashMap<Artifact, File> referenceArtifacts = new HashMap<Artifact, File>();
        for (Artifact artifact : this.artifacts.keySet()) {
            try {
                ReproducibleEnv env;
                File file = this.downloadReference(repo, artifact);
                referenceArtifacts.put(artifact, file);
                if (javaVersion != null || !JAR_TYPES.contains(artifact.getType()) || (env = this.extractEnv(file, artifact)) == null || env.javaVersion == null) continue;
                javaVersion = env.javaVersion;
                osName = env.osName;
                ReproducibleEnv currentEnv = this.extractEnv(artifact.getFile(), artifact);
                currentJavaVersion = currentEnv.javaVersion;
                currentOsName = currentEnv.osName;
            }
            catch (ArtifactNotFoundException e) {
                this.log.warn((CharSequence)("Reference artifact not found " + artifact));
            }
        }
        referenceBuildinfo = this.getReference(null, buildinfoFile);
        try (PrintWriter p = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(referenceBuildinfo.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)));){
            BuildInfoWriter bi = new BuildInfoWriter(this.log, p, mono, this.artifactHandlerManager, this.rtInformation);
            if (javaVersion != null || osName != null) {
                p.println("# effective build environment information");
                if (javaVersion != null) {
                    p.println("java.version=" + javaVersion);
                    this.log.info((CharSequence)("Reference build java.version: " + javaVersion));
                    if (!javaVersion.equals(currentJavaVersion)) {
                        this.log.error((CharSequence)("Current build java.version: " + currentJavaVersion));
                    }
                }
                if (osName != null) {
                    String expectedLs;
                    p.println("os.name=" + osName);
                    this.log.info((CharSequence)("Reference build os.name: " + osName));
                    if (!osName.equals(currentOsName)) {
                        this.log.error((CharSequence)("Current build os.name: " + currentOsName));
                    }
                    String string = expectedLs = osName.startsWith("Windows") ? "\r\n" : "\n";
                    if (!expectedLs.equals(System.lineSeparator())) {
                        this.log.warn((CharSequence)"Current System.lineSeparator() does not match reference build OS");
                        String ls = System.getProperty("line.separator");
                        if (!ls.equals(System.lineSeparator())) {
                            this.log.warn((CharSequence)"System.lineSeparator() != System.getProperty( \"line.separator\" ): too late standard system property update...");
                        }
                    }
                }
            }
            for (Map.Entry<Artifact, String> entry : this.artifacts.entrySet()) {
                Artifact artifact = entry.getKey();
                String prefix = entry.getValue();
                File referenceFile = (File)referenceArtifacts.get(artifact);
                if (referenceFile == null) continue;
                bi.printFile(prefix, artifact.getGroupId(), referenceFile);
            }
            if (p.checkError()) {
                throw new MojoExecutionException("Write error to " + referenceBuildinfo);
            }
            this.log.info((CharSequence)("Minimal buildinfo generated from downloaded artifacts: " + referenceBuildinfo));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + referenceBuildinfo, (Exception)e);
        }
        return referenceBuildinfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReproducibleEnv extractEnv(File file, Artifact artifact) {
        this.log.debug((CharSequence)("Guessing java.version and os.name from jar " + file));
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                String javaVersion = this.extractJavaVersion(manifest);
                String osName = this.extractOsName(artifact, jar);
                ReproducibleEnv reproducibleEnv = new ReproducibleEnv(javaVersion, osName);
                return reproducibleEnv;
            }
            this.log.warn((CharSequence)("no MANIFEST.MF found in jar " + file));
            return null;
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("unable to open jar file " + file), (Throwable)e);
        }
        return null;
    }

    private String extractJavaVersion(Manifest manifest) {
        Attributes attr = manifest.getMainAttributes();
        String value = attr.getValue("Build-Jdk-Spec");
        if (value != null) {
            return value + " (from MANIFEST.MF Build-Jdk-Spec)";
        }
        value = attr.getValue("Build-Jdk");
        if (value != null) {
            return String.valueOf(value) + " (from MANIFEST.MF Build-Jdk)";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractOsName(Artifact a, JarFile jar) {
        String entryName = "META-INF/maven/" + a.getGroupId() + '/' + a.getArtifactId() + "/pom.properties";
        ZipEntry zipEntry = jar.getEntry(entryName);
        if (zipEntry == null) {
            return null;
        }
        try (InputStream in = jar.getInputStream(zipEntry);){
            String content = IOUtil.toString((InputStream)in, (String)StandardCharsets.UTF_8.name());
            this.log.debug((CharSequence)("Manifest content: " + content));
            if (content.contains("\r\n")) {
                String string = "Windows (from pom.properties newline)";
                return string;
            }
            if (!content.contains("\n")) return null;
            String string = "Unix (from pom.properties newline)";
            return string;
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Unable to read " + entryName + " from " + jar), (Throwable)e);
        }
        return null;
    }

    private File downloadReferenceBuildinfo(RemoteRepository repo, MavenProject project) throws MojoExecutionException {
        Artifact buildinfo = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "buildinfo", "");
        try {
            File file = this.downloadReference(repo, buildinfo);
            this.log.info((CharSequence)("Reference buildinfo file found, copied to " + file));
            return file;
        }
        catch (ArtifactNotFoundException e) {
            this.log.info((CharSequence)"Reference buildinfo file not found: it will be generated from downloaded reference artifacts");
            return null;
        }
    }

    private File downloadReference(RemoteRepository repo, Artifact artifact) throws MojoExecutionException, ArtifactNotFoundException {
        try {
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler() != null ? artifact.getArtifactHandler().getExtension() : artifact.getType(), artifact.getVersion()));
            request.setRepositories(Collections.singletonList(repo));
            ArtifactResult result = this.repoSystem.resolveArtifact((RepositorySystemSession)new NoWorkspaceRepositorySystemSession(this.repoSession), request);
            File resultFile = result.getArtifact().getFile();
            File destFile = this.getReference(artifact.getGroupId(), resultFile);
            FileUtils.copyFile((File)resultFile, (File)destFile);
            return destFile;
        }
        catch (ArtifactResolutionException are) {
            if (are.getResult().isMissing()) {
                throw new ArtifactNotFoundException("Artifact not found " + artifact, artifact);
            }
            throw new MojoExecutionException("Error resolving reference artifact " + artifact, (Exception)((Object)are));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error copying reference artifact " + artifact, (Exception)ioe);
        }
    }

    private File getReference(String groupId, File file) {
        File dir;
        if (groupId == null) {
            dir = this.referenceDir;
        } else {
            dir = new File(this.referenceDir, groupId);
            if (!dir.isDirectory()) {
                dir.mkdir();
            }
        }
        return new File(dir, file.getName());
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("jar");
        types.add("test-jar");
        types.add("war");
        types.add("ear");
        types.add("rar");
        types.add("maven-plugin");
        JAR_TYPES = Collections.unmodifiableSet(types);
    }

    private static class ReproducibleEnv {
        public final String javaVersion;
        public final String osName;

        ReproducibleEnv(String javaVersion, String osName) {
            this.javaVersion = javaVersion;
            this.osName = osName;
        }
    }

    private static class NoWorkspaceRepositorySystemSession
    extends AbstractForwardingRepositorySystemSession {
        private final RepositorySystemSession rss;

        NoWorkspaceRepositorySystemSession(RepositorySystemSession rss) {
            this.rss = rss;
        }

        protected RepositorySystemSession getSession() {
            return this.rss;
        }

        public WorkspaceReader getWorkspaceReader() {
            return null;
        }
    }
}

