/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="check-buildplan", threadSafe=true, requiresProject=true)
public class CheckBuildPlanMojo
extends AbstractMojo {
    @Component
    private List<MavenProject> reactorProjects;
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Parameter(property="check.buildplan.tasks", defaultValue="deploy")
    private String[] tasks;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(property="check.plugin-issues")
    private File pluginIssues;
    @Parameter(property="check.failOnNonReproducible", defaultValue="true")
    private boolean failOnNonReproducible;

    protected MavenExecutionPlan calculateExecutionPlan() throws MojoExecutionException {
        try {
            return this.lifecycleExecutor.calculateExecutionPlan(this.session, this.tasks);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot calculate Maven execution plan" + e.getMessage(), e);
        }
    }

    public void execute() throws MojoExecutionException {
        boolean fail = this.hasBadOutputTimestamp();
        Properties issues = this.loadIssues();
        MavenExecutionPlan plan = this.calculateExecutionPlan();
        HashSet<String> plugins = new HashSet<String>();
        for (MojoExecution exec : plan.getMojoExecutions()) {
            Plugin plugin = exec.getPlugin();
            String id = plugin.getId();
            if (!plugins.add(id)) continue;
            String issue = issues.getProperty(plugin.getKey());
            if (issue == null) {
                this.getLog().info((CharSequence)("no known issue with " + id));
                continue;
            }
            if (issue.startsWith("fail:")) {
                String logMessage = "plugin without solution " + id + ", see " + issue.substring(5);
                if (this.failOnNonReproducible) {
                    this.getLog().error((CharSequence)logMessage);
                } else {
                    this.getLog().warn((CharSequence)logMessage);
                }
                fail = true;
                continue;
            }
            DefaultArtifactVersion minimum = new DefaultArtifactVersion(issue);
            DefaultArtifactVersion version = new DefaultArtifactVersion(plugin.getVersion());
            if (version.compareTo((Object)minimum) < 0) {
                String logMessage = "plugin with non-reproducible output: " + id + ", require minimum " + issue;
                if (this.failOnNonReproducible) {
                    this.getLog().error((CharSequence)logMessage);
                } else {
                    this.getLog().warn((CharSequence)logMessage);
                }
                fail = true;
                continue;
            }
            this.getLog().info((CharSequence)("no known issue with " + id + " (>= " + issue + ")"));
        }
        if (fail) {
            this.getLog().info((CharSequence)("current module pom.xml is " + this.project.getBasedir() + "/pom.xml"));
            MavenProject parent = this.project;
            while ((parent = parent.getParent()) != null && this.reactorProjects.contains(parent)) {
                this.getLog().info((CharSequence)("        parent pom.xml is " + parent.getBasedir() + "/pom.xml"));
            }
            String message = "non-reproducible plugin or configuration found with fix available";
            if (this.failOnNonReproducible) {
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
    }

    private boolean hasBadOutputTimestamp() {
        MavenArchiver archiver = new MavenArchiver();
        Date timestamp = archiver.parseOutputTimestamp(this.outputTimestamp);
        if (timestamp == null) {
            this.getLog().error((CharSequence)"Reproducible Build not activated by project.build.outputTimestamp property: see https://maven.apache.org/guides/mini/guide-reproducible-builds.html");
            return true;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("project.build.outputTimestamp = \"" + this.outputTimestamp + "\" => " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(timestamp)));
        }
        boolean parentInReactor = false;
        MavenProject reactorParent = this.project;
        while (this.reactorProjects.contains(reactorParent.getParent())) {
            parentInReactor = true;
            reactorParent = reactorParent.getParent();
        }
        String prop = reactorParent.getOriginalModel().getProperties().getProperty("project.build.outputTimestamp");
        if (prop == null) {
            this.getLog().error((CharSequence)("project.build.outputTimestamp property should not be inherited but defined in " + (parentInReactor ? "parent POM from reactor " : "POM ") + reactorParent.getFile()));
            return true;
        }
        return false;
    }

    private Properties loadIssues() throws MojoExecutionException {
        Properties properties;
        block10: {
            InputStream in = this.pluginIssues == null ? ((Object)((Object)this)).getClass().getResourceAsStream("not-reproducible-plugins.properties") : Files.newInputStream(this.pluginIssues.toPath(), new OpenOption[0]);
            try {
                Properties prop = new Properties();
                prop.load(in);
                Properties result = new Properties();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    String plugin = entry.getKey().toString().replace('+', ':');
                    if (!plugin.contains(":")) {
                        plugin = "org.apache.maven.plugins:" + plugin;
                    }
                    result.put(plugin, entry.getValue());
                }
                properties = result;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Cannot load issues file", (Exception)ioe);
                }
            }
            in.close();
        }
        return properties;
    }
}

