/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.artifact.buildinfo.JdkToolchainUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.utils.PropertyUtils;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.toolchain.Toolchain;

class BuildInfoWriter {
    private final Log log;
    private final PrintWriter p;
    private final boolean mono;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RuntimeInformation rtInformation;
    private final Map<Artifact, String> artifacts = new LinkedHashMap<Artifact, String>();
    private int projectCount = -1;
    private boolean ignoreJavadoc = true;
    private List<PathMatcher> ignore;
    private Toolchain toolchain;

    BuildInfoWriter(Log log, PrintWriter p, boolean mono, ArtifactHandlerManager artifactHandlerManager, RuntimeInformation rtInformation) {
        this.log = log;
        this.p = p;
        this.mono = mono;
        this.artifactHandlerManager = artifactHandlerManager;
        this.rtInformation = rtInformation;
    }

    void printHeader(MavenProject project, MavenProject aggregate, boolean reproducible) {
        this.p.println("# https://reproducible-builds.org/docs/jvm/");
        this.p.println("buildinfo.version=1.0-SNAPSHOT");
        this.p.println();
        this.p.println("name=" + project.getName());
        this.p.println("group-id=" + project.getGroupId());
        this.p.println("artifact-id=" + project.getArtifactId());
        this.p.println("version=" + project.getVersion());
        this.p.println();
        this.printSourceInformation(project);
        this.p.println();
        this.p.println("# build instructions");
        this.p.println("build-tool=mvn");
        this.p.println();
        if (reproducible) {
            this.p.println("# build environment information (simplified for reproducibility)");
            this.p.println("java.version=" + BuildInfoWriter.extractJavaMajorVersion(System.getProperty("java.version")));
            String ls = System.getProperty("line.separator");
            this.p.println("os.name=" + ("\n".equals(ls) ? "Unix" : "Windows"));
        } else {
            this.p.println("# effective build environment information");
            this.p.println("java.version=" + System.getProperty("java.version"));
            this.p.println("java.vendor=" + System.getProperty("java.vendor"));
            this.p.println("os.name=" + System.getProperty("os.name"));
        }
        this.p.println();
        this.p.println("# Maven rebuild instructions and effective environment");
        if (!reproducible) {
            this.p.println("mvn.version=" + this.rtInformation.getMavenVersion());
        }
        if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
            this.p.println("mvn.minimum.version=" + project.getPrerequisites().getMaven());
        }
        if (this.toolchain != null) {
            String javaVersion = JdkToolchainUtil.getJavaVersion(this.toolchain);
            if (reproducible) {
                javaVersion = BuildInfoWriter.extractJavaMajorVersion(javaVersion);
            }
            this.p.println("mvn.toolchain.jdk=" + javaVersion);
        }
        if (!this.mono && aggregate != null) {
            this.p.println("mvn.aggregate.artifact-id=" + aggregate.getArtifactId());
        }
        this.p.println();
        this.p.println("# " + (this.mono ? "" : "aggregated ") + "output");
    }

    private static String extractJavaMajorVersion(String javaVersion) {
        int index;
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        if ((index = javaVersion.indexOf(46)) < 0) {
            index = javaVersion.indexOf(45);
        }
        return index < 0 ? javaVersion : javaVersion.substring(0, index);
    }

    private void printSourceInformation(MavenProject project) {
        boolean sourceAvailable = false;
        this.p.println("# source information");
        if (project.getScm() != null) {
            sourceAvailable = true;
            this.p.println("source.scm.uri=" + project.getScm().getConnection());
            this.p.println("source.scm.tag=" + project.getScm().getTag());
            if (project.getArtifact().isSnapshot()) {
                this.log.warn((CharSequence)("SCM source tag in buildinfo source.scm.tag=" + project.getScm().getTag() + " does not permit rebuilders reproducible source checkout"));
            }
        } else {
            this.p.println("# no scm configured in pom.xml");
        }
        if (!sourceAvailable) {
            this.log.warn((CharSequence)"No source information available in buildinfo for rebuilders...");
        }
    }

    void printArtifacts(MavenProject project) throws MojoExecutionException {
        String prefix = "outputs.";
        if (!this.mono) {
            ++this.projectCount;
            prefix = prefix + this.projectCount + ".";
            this.p.println();
            this.p.println(prefix + "coordinates=" + project.getGroupId() + ':' + project.getArtifactId());
        }
        Artifact consumerPom = project.getAttachedArtifacts().stream().filter(a -> "pom".equals(a.getType()) && "consumer".equals(a.getClassifier())).findAny().orElse(null);
        int n = 0;
        DefaultArtifact pomArtifact = new DefaultArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, "pom", "", this.artifactHandlerManager.getArtifactHandler("pom"));
        if (consumerPom != null) {
            try {
                Path pomFile = Files.createTempFile(Paths.get(project.getBuild().getDirectory(), new String[0]), "consumer-", ".pom", new FileAttribute[0]);
                Files.copy(consumerPom.getFile().toPath(), pomFile, StandardCopyOption.REPLACE_EXISTING);
                pomArtifact.setFile(pomFile.toFile());
            }
            catch (IOException e) {
                this.p.println("Error processing consumer POM: " + e);
            }
        } else {
            pomArtifact.setFile(project.getFile());
        }
        this.artifacts.put((Artifact)pomArtifact, prefix + n);
        this.printFile(prefix + n++, pomArtifact.getGroupId(), pomArtifact.getFile(), project.getArtifactId() + '-' + project.getVersion() + ".pom");
        if (project.getArtifact() == null) {
            return;
        }
        if (project.getArtifact().getFile() != null) {
            this.printArtifact(prefix, n++, project.getArtifact());
        }
        for (Artifact attached : project.getAttachedArtifacts()) {
            if (attached == consumerPom || attached.getType().endsWith(".asc") || this.ignoreJavadoc && "javadoc".equals(attached.getClassifier())) continue;
            if (this.isIgnore(attached)) {
                this.p.println("# ignored " + BuildInfoWriter.getArtifactFilename(attached));
                this.artifacts.put(attached, null);
                continue;
            }
            this.printArtifact(prefix, n++, attached);
        }
    }

    private void printArtifact(String prefix, int i, Artifact artifact) throws MojoExecutionException {
        prefix = prefix + i;
        File artifactFile = artifact.getFile();
        if (artifactFile.isDirectory()) {
            if ("pom".equals(artifact.getType())) {
                return;
            }
            throw new MojoExecutionException("Artifact " + artifact.getId() + " points to a directory: " + artifactFile + ". Packaging should be 'pom'?");
        }
        if (!artifactFile.isFile()) {
            this.log.warn((CharSequence)("Ignoring artifact " + artifact.getId() + " because it points to inexistent " + artifactFile));
            return;
        }
        this.printFile(prefix, artifact.getGroupId(), artifact.getFile(), BuildInfoWriter.getArtifactFilename(artifact));
        this.artifacts.put(artifact, prefix);
    }

    static String getArtifactFilename(Artifact artifact) {
        ArtifactHandler artifactHandler;
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getArtifactId()).append('-').append(artifact.getBaseVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (StringUtils.isNotEmpty((String)(artifactHandler = artifact.getArtifactHandler()).getExtension())) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    void printFile(String prefix, String groupId, File file) throws MojoExecutionException {
        this.printFile(prefix, groupId, file, file.getName());
    }

    private void printFile(String prefix, String groupId, File file, String filename) throws MojoExecutionException {
        this.p.println();
        this.p.println(prefix + ".groupId=" + groupId);
        this.p.println(prefix + ".filename=" + filename);
        this.p.println(prefix + ".length=" + file.length());
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.p.println(prefix + ".checksums.sha512=" + DigestUtils.sha512Hex((InputStream)is));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error processing file " + file, (Exception)ioe);
        }
        catch (IllegalArgumentException iae) {
            throw new MojoExecutionException("Could not get hash algorithm", iae.getCause());
        }
    }

    Map<Artifact, String> getArtifacts() {
        return this.artifacts;
    }

    static Properties loadOutputProperties(File buildinfo) throws MojoExecutionException {
        Properties prop = PropertyUtils.loadOptionalProperties((File)buildinfo);
        for (String name : prop.stringPropertyNames()) {
            if (name.startsWith("outputs.") && !name.endsWith(".coordinates")) continue;
            prop.remove(name);
        }
        return prop;
    }

    boolean getIgnoreJavadoc() {
        return this.ignoreJavadoc;
    }

    void setIgnoreJavadoc(boolean ignoreJavadoc) {
        this.ignoreJavadoc = ignoreJavadoc;
    }

    void setIgnore(List<String> ignore) {
        FileSystem fs = FileSystems.getDefault();
        this.ignore = ignore.stream().map(i -> fs.getPathMatcher("glob:" + i)).collect(Collectors.toList());
    }

    private boolean isIgnore(Artifact attached) {
        Path path = Paths.get(attached.getGroupId() + '/' + BuildInfoWriter.getArtifactFilename(attached), new String[0]);
        return this.ignore.stream().anyMatch(m -> m.matches(path));
    }

    public void setToolchain(Toolchain toolchain) {
        this.toolchain = toolchain;
    }
}

