/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.shared.utils.StringUtils;

class MavenVersion {
    MavenVersion() {
    }

    static String createMavenVersionString() {
        return MavenVersion.createMavenVersionString(MavenVersion.getBuildProperties());
    }

    private static String createMavenVersionString(Properties buildProperties) {
        String timestamp = MavenVersion.reduce(buildProperties.getProperty("timestamp"));
        String version = MavenVersion.reduce(buildProperties.getProperty("version"));
        String rev = MavenVersion.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = MavenVersion.reduce(buildProperties.getProperty("distributionName"));
        String msg = distributionName + " ";
        msg = msg + (version != null ? version : "<version unknown>");
        if (rev != null || timestamp != null) {
            msg = msg + " (";
            msg = msg + (rev != null ? rev : "");
            if (StringUtils.isNotBlank((String)timestamp)) {
                String ts = MavenVersion.formatTimestamp(Long.valueOf(timestamp));
                msg = msg + (rev != null ? "; " : "") + ts;
            }
            msg = msg + ")";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    private static Properties getBuildProperties() {
        Properties properties = new Properties();
        try (InputStream resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        return properties;
    }

    private static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }
}

