/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.ant.ArtifactResolverWrapper;
import org.apache.maven.project.MavenProject;
import org.apache.xpath.XPathAPI;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AntBuildWriterUtil {
    public static List removeEmptyCompileSourceRoots(List compileSourceRoots) {
        ArrayList<String> newCompileSourceRootsList = new ArrayList<String>();
        if (compileSourceRoots != null) {
            Iterator i = compileSourceRoots.iterator();
            while (i.hasNext()) {
                String srcDir = (String)i.next();
                if (!new File(srcDir).exists()) continue;
                newCompileSourceRootsList.add(srcDir);
            }
        }
        return newCompileSourceRootsList;
    }

    public static void writeIncludesExcludes(XMLWriter writer, List includes, List excludes) {
        Iterator i;
        if (includes != null) {
            i = includes.iterator();
            while (i.hasNext()) {
                String include = (String)i.next();
                writer.startElement("include");
                writer.addAttribute("name", include);
                writer.endElement();
            }
        }
        if (excludes != null) {
            i = excludes.iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                writer.startElement("exclude");
                writer.addAttribute("name", exclude);
                writer.endElement();
            }
        }
    }

    public static void writeHeader(XMLWriter writer) {
        AntBuildWriterUtil.writeAntVersionHeader(writer);
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)(StringUtils.repeat((String)"=", (int)21) + " - DO NOT EDIT THIS FILE! - " + StringUtils.repeat((String)"=", (int)21)));
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"Any modifications will be overwritten.");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)("Generated by Maven Ant Plugin on " + dateFormat.format(new Date(System.currentTimeMillis()))));
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: http://maven.apache.org/plugins/maven-ant-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeLineBreak((XMLWriter)writer);
    }

    public static void writeAntVersionHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentText((XMLWriter)writer, (String)"Ant build file (http://ant.apache.org/) for Ant 1.6.2 or above.", (int)0);
    }

    public static void writeAntTask(XMLWriter writer, MavenProject project, String moduleSubPath, String tasks) {
        writer.startElement("ant");
        writer.addAttribute("antfile", "build.xml");
        writer.addAttribute("dir", AntBuildWriterUtil.toRelative(project.getBasedir(), moduleSubPath));
        writer.addAttribute("target", tasks);
        writer.endElement();
    }

    public static void writeJavadocTask(XMLWriter writer, MavenProject project, ArtifactResolverWrapper wrapper) throws IOException {
        Map[] tags;
        String taglet;
        String doclet;
        Map[] groups;
        Map[] offlineLinks;
        Map[] links;
        String bottom;
        String footer;
        String header;
        ArrayList<String> sources = new ArrayList<String>();
        Iterator it = project.getCompileSourceRoots().iterator();
        while (it.hasNext()) {
            String source = (String)it.next();
            if (!new File(source).exists()) continue;
            sources.add(source);
        }
        if (sources.size() == 0) {
            return;
        }
        writer.startElement("javadoc");
        String sourcepath = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "sourcepath", null);
        if (sourcepath == null) {
            StringBuffer sb = new StringBuffer();
            String[] compileSourceRoots = sources.toArray(new String[0]);
            for (int i = 0; i < compileSourceRoots.length; ++i) {
                sb.append("${maven.build.srcDir.").append(i).append("}");
                if (i >= compileSourceRoots.length - 1) continue;
                sb.append(File.pathSeparatorChar);
            }
            writer.addAttribute("sourcepath", sb.toString());
            AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "packagenames", "*", 3);
        } else {
            writer.addAttribute("sourcepath", sourcepath);
        }
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "destdir", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "destdir", "${maven.reporting.outputDirectory}/apidocs"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "extdirs", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "extdirs", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "overview", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "overview", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "access", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "show", "protected"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "old", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "old", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "verbose", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "verbose", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "locale", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "locale", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "encoding", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "encoding", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "version", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "version", "true"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "use", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "use", "true"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "author", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "author", "true"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "splitindex", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "splitindex", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "windowtitle", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "windowtitle", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "nodeprecated", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "nodeprecated", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "nodeprecatedlist", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "nodeprecatedlist", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "notree", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "notree", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "noindex", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "noindex", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "nohelp", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "nohelp", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "nonavbar", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "nonavbar", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "serialwarn", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "serialwarn", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "helpfile", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "helpfile", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "stylesheetfile", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "stylesheetfile", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "charset", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "charset", "ISO-8859-1"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "docencoding", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "docencoding", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "excludepackagenames", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "excludepackagenames", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "source", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "source", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "linksource", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "linksource", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "breakiterator", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "breakiterator", "false"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "noqualifier", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "noqualifier", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "maxmemory", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "maxmemory", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "additionalparam", AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "additionalparam", null), 3);
        String doctitle = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "doctitle", null);
        if (doctitle != null) {
            writer.startElement("doctitle");
            writer.writeText("<![CDATA[" + doctitle + "]]>");
            writer.endElement();
        }
        if ((header = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "header", null)) != null) {
            writer.startElement("header");
            writer.writeText("<![CDATA[" + header + "]]>");
            writer.endElement();
        }
        if ((footer = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "footer", null)) != null) {
            writer.startElement("footer");
            writer.writeText("<![CDATA[" + footer + "]]>");
            writer.endElement();
        }
        if ((bottom = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "bottom", null)) != null) {
            writer.startElement("bottom");
            writer.writeText("<![CDATA[" + bottom + "]]>");
            writer.endElement();
        }
        if ((links = AntBuildWriterUtil.getMavenJavadocPluginOptions(project, "links", null)) != null) {
            for (int i = 0; i < links.length; ++i) {
                writer.startElement("link");
                writer.addAttribute("href", (String)links[i].get("link"));
                writer.endElement();
            }
        }
        if ((offlineLinks = AntBuildWriterUtil.getMavenJavadocPluginOptions(project, "offlineLinks", null)) != null) {
            for (int i = 0; i < offlineLinks.length; ++i) {
                writer.startElement("link");
                writer.addAttribute("href", (String)offlineLinks[i].get("url"));
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "offline", "true", 4);
                writer.endElement();
            }
        }
        if ((groups = AntBuildWriterUtil.getMavenJavadocPluginOptions(project, "groups", null)) != null) {
            for (int i = 0; i < groups.length; ++i) {
                Map group = (Map)groups[i].get("group");
                writer.startElement("group");
                writer.addAttribute("title", (String)group.get("title"));
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "package", (String)group.get("package"), 4);
                writer.endElement();
            }
        }
        if ((doclet = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "doclet", null)) != null) {
            String docletpath = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "docletpath", null);
            if (StringUtils.isNotEmpty((String)docletpath)) {
                writer.startElement("doclet");
                writer.addAttribute("name", doclet);
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "path", docletpath, 4);
                writer.endElement();
            } else {
                Map docletArtifact = AntBuildWriterUtil.getMavenJavadocPluginOption(project, "docletArtifact", null);
                String path = wrapper.getArtifactAbsolutePath((String)docletArtifact.get("groupId"), (String)docletArtifact.get("artifactId"), (String)docletArtifact.get("version"));
                path = StringUtils.replace((String)path, (String)wrapper.getLocalRepository().getBasedir(), (String)"${maven.repo.local}");
                writer.startElement("doclet");
                writer.addAttribute("name", doclet);
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "path", path, 4);
                writer.endElement();
            }
        }
        if ((taglet = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "taglet", null)) != null) {
            String tagletpath = AntBuildWriterUtil.getMavenJavadocPluginBasicOption(project, "tagletpath", null);
            if (StringUtils.isNotEmpty((String)tagletpath)) {
                writer.startElement("taglet");
                writer.addAttribute("name", taglet);
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "path", tagletpath, 4);
                writer.endElement();
            } else {
                Map tagletArtifact = AntBuildWriterUtil.getMavenJavadocPluginOption(project, "tagletArtifact", null);
                String path = wrapper.getArtifactAbsolutePath((String)tagletArtifact.get("groupId"), (String)tagletArtifact.get("artifactId"), (String)tagletArtifact.get("version"));
                path = StringUtils.replace((String)path, (String)wrapper.getLocalRepository().getBasedir(), (String)"${maven.repo.local}");
                writer.startElement("taglet");
                writer.addAttribute("name", taglet);
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "path", path, 4);
                writer.endElement();
            }
        }
        if ((tags = AntBuildWriterUtil.getMavenJavadocPluginOptions(project, "tags", null)) != null) {
            for (int i = 0; i < tags.length; ++i) {
                Map props = (Map)tags[i].get("tag");
                writer.startElement("tag");
                writer.addAttribute("name", (String)props.get("name"));
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "scope", (String)props.get("placement"), 4);
                AntBuildWriterUtil.addWrapAttribute(writer, "javadoc", "description", (String)props.get("head"), 4);
                writer.endElement();
            }
        }
        writer.endElement();
    }

    public static void writeJarTask(XMLWriter writer, MavenProject project) throws IOException {
        writer.startElement("jar");
        writer.addAttribute("jarfile", "${maven.build.dir}/${maven.build.finalName}.jar");
        AntBuildWriterUtil.addWrapAttribute(writer, "jar", "compress", AntBuildWriterUtil.getMavenJarPluginBasicOption(project, "archive//compress", "true"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "jar", "index", AntBuildWriterUtil.getMavenJarPluginBasicOption(project, "archive//index", "false"), 3);
        if (AntBuildWriterUtil.getMavenJarPluginBasicOption(project, "archive//manifestFile", null) != null) {
            AntBuildWriterUtil.addWrapAttribute(writer, "jar", "manifest", AntBuildWriterUtil.getMavenJarPluginBasicOption(project, "archive//manifestFile", null), 3);
        }
        AntBuildWriterUtil.addWrapAttribute(writer, "jar", "basedir", "${maven.build.outputDir}", 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "jar", "excludes", "**/package.html", 3);
        if (AntBuildWriterUtil.getMavenPluginOption(project, "maven-jar-plugin", "archive//manifest", null) != null) {
            writer.startElement("manifest");
            writer.startElement("attribute");
            writer.addAttribute("name", "Main-Class");
            AntBuildWriterUtil.addWrapAttribute(writer, "attribute", "value", AntBuildWriterUtil.getMavenJarPluginBasicOption(project, "archive//manifest//mainClass", null), 5);
            writer.endElement();
            writer.endElement();
        }
        writer.endElement();
    }

    public static void writeEarTask(XMLWriter writer, MavenProject project, ArtifactResolverWrapper artifactResolverWrapper) throws IOException {
        AntBuildWriterUtil.writeCopyLib(writer, project, artifactResolverWrapper, "${maven.build.dir}/${maven.build.finalName}");
        writer.startElement("ear");
        writer.addAttribute("destfile", "${maven.build.dir}/${maven.build.finalName}.ear");
        AntBuildWriterUtil.addWrapAttribute(writer, "ear", "basedir", "${maven.build.dir}/${maven.build.finalName}", 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "ear", "compress", AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "archive//compress", "true"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "ear", "includes ", AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "includes", null), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "ear", "excludes", AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "excludes", null), 3);
        if (AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "applicationXml", null) != null) {
            AntBuildWriterUtil.addWrapAttribute(writer, "ear", "appxml", AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "applicationXml", null), 3);
        } else {
            AntBuildWriterUtil.addWrapAttribute(writer, "ear", "appxml", "${maven.build.dir}/application.xml", 3);
        }
        if (AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "manifestFile", null) != null) {
            AntBuildWriterUtil.addWrapAttribute(writer, "ear", "manifest", AntBuildWriterUtil.getMavenEarPluginBasicOption(project, "manifestFile", null), 3);
        }
        writer.endElement();
    }

    public static void writeWarTask(XMLWriter writer, MavenProject project, ArtifactResolverWrapper artifactResolverWrapper) throws IOException {
        String webXml = AntBuildWriterUtil.getMavenWarPluginBasicOption(project, "webXml", "${basedir}/src/main/webapp/WEB-INF/web.xml");
        if (webXml.startsWith("${basedir}/")) {
            webXml = webXml.substring("${basedir}/".length());
        }
        AntBuildWriterUtil.writeCopyLib(writer, project, artifactResolverWrapper, "${maven.build.dir}/${maven.build.finalName}/WEB-INF/lib");
        writer.startElement("war");
        writer.addAttribute("destfile", "${maven.build.dir}/${maven.build.finalName}.war");
        AntBuildWriterUtil.addWrapAttribute(writer, "war", "compress", AntBuildWriterUtil.getMavenWarPluginBasicOption(project, "archive//compress", "true"), 3);
        AntBuildWriterUtil.addWrapAttribute(writer, "war", "webxml", webXml, 3);
        if (AntBuildWriterUtil.getMavenWarPluginBasicOption(project, "manifestFile", null) != null) {
            AntBuildWriterUtil.addWrapAttribute(writer, "war", "manifest", AntBuildWriterUtil.getMavenWarPluginBasicOption(project, "manifestFile", null), 3);
        }
        writer.startElement("lib");
        writer.addAttribute("dir", "${maven.build.dir}/${maven.build.finalName}/WEB-INF/lib");
        writer.endElement();
        writer.startElement("classes");
        writer.addAttribute("dir", "${maven.build.outputDir}");
        writer.endElement();
        writer.startElement("fileset");
        writer.addAttribute("dir", "src/main/webapp");
        AntBuildWriterUtil.addWrapAttribute(writer, "fileset", "excludes", "WEB-INF/web.xml", 4);
        writer.endElement();
        writer.endElement();
    }

    public static void addWrapAttribute(XMLWriter writer, String tag, String name, String value, int indent) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        if (indent < 0) {
            writer.addAttribute(name, value);
        } else {
            writer.addAttribute("\n" + StringUtils.repeat((String)" ", (int)((StringUtils.isEmpty((String)tag) ? 0 : tag.length()) + indent * 2)) + name, value);
        }
    }

    public static boolean isPomPackaging(MavenProject mavenProject) {
        return mavenProject.getPackaging().toLowerCase().equals("pom");
    }

    public static boolean isJarPackaging(MavenProject mavenProject) {
        return mavenProject.getPackaging().toLowerCase().equals("jar") || mavenProject.getPackaging().toLowerCase().equals("ejb") || mavenProject.getPackaging().toLowerCase().equals("maven-plugin");
    }

    public static boolean isEarPackaging(MavenProject mavenProject) {
        return mavenProject.getPackaging().toLowerCase().equals("ear");
    }

    public static boolean isWarPackaging(MavenProject mavenProject) {
        return mavenProject.getPackaging().toLowerCase().equals("war");
    }

    public static String getMavenCompilerPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginBasicOption(project, "maven-compiler-plugin", optionName, defaultValue);
    }

    public static Map getMavenCompilerPluginOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginOption(project, "maven-compiler-plugin", optionName, defaultValue);
    }

    public static Map[] getMavenCompilerPluginOptions(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginOptions(project, "maven-compiler-plugin", optionName, defaultValue);
    }

    public static String getMavenSurefirePluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginBasicOption(project, "maven-surefire-plugin", optionName, defaultValue);
    }

    public static Map getMavenSurefirePluginOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginOption(project, "maven-surefire-plugin", optionName, defaultValue);
    }

    public static Map[] getMavenSurefirePluginOptions(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginOptions(project, "maven-surefire-plugin", optionName, defaultValue);
    }

    public static String getMavenJavadocPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginBasicOption(project, "maven-javadoc-plugin", optionName, defaultValue);
    }

    public static Map getMavenJavadocPluginOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginOption(project, "maven-javadoc-plugin", optionName, defaultValue);
    }

    public static Map[] getMavenJavadocPluginOptions(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginOptions(project, "maven-javadoc-plugin", optionName, defaultValue);
    }

    public static String getMavenJarPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginBasicOption(project, "maven-jar-plugin", optionName, defaultValue);
    }

    public static String getMavenEarPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginBasicOption(project, "maven-ear-plugin", optionName, defaultValue);
    }

    public static String getMavenWarPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        return AntBuildWriterUtil.getMavenPluginBasicOption(project, "maven-war-plugin", optionName, defaultValue);
    }

    private static String getMavenPluginBasicOption(MavenProject project, String pluginArtifactId, String optionName, String defaultValue) throws IOException {
        return (String)AntBuildWriterUtil.getMavenPluginConfigurationsImpl(project, pluginArtifactId, optionName, defaultValue).get(optionName);
    }

    private static Map getMavenPluginOption(MavenProject project, String pluginArtifactId, String optionName, String defaultValue) throws IOException {
        return (Map)AntBuildWriterUtil.getMavenPluginConfigurationsImpl(project, pluginArtifactId, optionName, defaultValue).get(optionName);
    }

    private static Map[] getMavenPluginOptions(MavenProject project, String pluginArtifactId, String optionName, String defaultValue) throws IOException {
        return (Map[])AntBuildWriterUtil.getMavenPluginConfigurationsImpl(project, pluginArtifactId, optionName, defaultValue).get(optionName);
    }

    private static Map getMavenPluginConfigurationsImpl(MavenProject project, String pluginArtifactId, String optionName, String defaultValue) throws IOException {
        ArrayList plugins = new ArrayList();
        Iterator it = project.getModel().getReporting().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        if (project.getBuild().getPluginManagement() != null) {
            it = project.getBuild().getPluginManagement().getPlugins().iterator();
            while (it.hasNext()) {
                plugins.add(it.next());
            }
        }
        it = plugins.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            Object pluginConf = null;
            if (next instanceof Plugin) {
                Plugin plugin = (Plugin)next;
                if (!plugin.getGroupId().equals("org.apache.maven.plugins") || !plugin.getArtifactId().equals(pluginArtifactId)) continue;
                pluginConf = plugin.getConfiguration();
            }
            if (next instanceof ReportPlugin) {
                ReportPlugin reportPlugin = (ReportPlugin)next;
                if (!reportPlugin.getGroupId().equals("org.apache.maven.plugins") || !reportPlugin.getArtifactId().equals(pluginArtifactId)) continue;
                pluginConf = reportPlugin.getConfiguration();
            }
            if (pluginConf == null) continue;
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(pluginConf.toString().getBytes("UTF-8")));
                NodeList nodeList = XPathAPI.eval((Node)doc, (String)("//configuration/" + optionName)).nodelist();
                if (nodeList.getLength() <= 0) continue;
                Node optionNode = nodeList.item(0);
                if (AntBuildWriterUtil.isList(optionNode)) {
                    HashMap<String, Map[]> options = new HashMap<String, Map[]>();
                    ArrayList optionNames = new ArrayList();
                    NodeList childs = optionNode.getChildNodes();
                    for (int i = 0; i < childs.getLength(); ++i) {
                        Node child = childs.item(i);
                        if (child.getNodeType() != 1) continue;
                        HashMap<String, Object> option = new HashMap<String, Object>();
                        if (AntBuildWriterUtil.isElementContent(child)) {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            NodeList childs2 = child.getChildNodes();
                            if (childs2.getLength() > 0) {
                                for (int j = 0; j < childs2.getLength(); ++j) {
                                    Node child2 = childs2.item(j);
                                    if (child2.getNodeType() != 1) continue;
                                    properties.put(child2.getNodeName(), AntBuildWriterUtil.getTextContent(child2));
                                }
                                option.put(child.getNodeName(), properties);
                            }
                        } else {
                            option.put(child.getNodeName(), AntBuildWriterUtil.getTextContent(child));
                        }
                        optionNames.add(option);
                    }
                    options.put(optionName, optionNames.toArray(new Map[0]));
                    return options;
                }
                if (AntBuildWriterUtil.isElementContent(optionNode)) {
                    HashMap option = new HashMap();
                    NodeList childs = optionNode.getChildNodes();
                    if (childs.getLength() > 1) {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        for (int i = 0; i < childs.getLength(); ++i) {
                            Node child = childs.item(i);
                            if (child.getNodeType() != 1) continue;
                            parameters.put(child.getNodeName(), AntBuildWriterUtil.getTextContent(child));
                        }
                        option.put(optionName, parameters);
                    }
                    return option;
                }
                HashMap<String, String> option = new HashMap<String, String>();
                option.put(optionName, AntBuildWriterUtil.getTextContent(optionNode));
                return option;
            }
            catch (Exception e) {
                throw new IOException("Exception occured: " + e.getMessage());
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(optionName, defaultValue);
        return properties;
    }

    private static void writeCopyLib(XMLWriter writer, MavenProject project, ArtifactResolverWrapper artifactResolverWrapper, String outputDir) {
        writer.startElement("mkdir");
        writer.addAttribute("dir", outputDir);
        writer.endElement();
        if (!project.getDependencyArtifacts().isEmpty()) {
            Iterator i = project.getDependencyArtifacts().iterator();
            while (i.hasNext()) {
                Artifact artifact = (Artifact)i.next();
                if (artifact.getScope().equals("provided") || artifact.getScope().equals("test")) continue;
                String path = artifactResolverWrapper.getLocalArtifactPath(artifact);
                if (!new File(path).isAbsolute()) {
                    path = "${maven.repo.local}/" + path;
                }
                writer.startElement("copy");
                writer.addAttribute("file", path);
                AntBuildWriterUtil.addWrapAttribute(writer, "copy", "todir", outputDir, 3);
                writer.endElement();
            }
        }
    }

    private static boolean isList(Node node) {
        if (node == null) {
            return false;
        }
        NodeList children = node.getChildNodes();
        boolean isList = false;
        String lastNodeName = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            isList = isList || child.getNodeName().equals(lastNodeName);
            lastNodeName = child.getNodeName();
        }
        if (StringUtils.isNotEmpty(lastNodeName)) {
            isList = isList || lastNodeName.equals(AntBuildWriterUtil.getSingularForm(node.getNodeName()));
        }
        return isList;
    }

    private static boolean isElementContent(Node node) {
        if (node == null) {
            return false;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static String getTextContent(Node node) {
        StringBuffer buffer = new StringBuffer();
        if (node != null) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                buffer.append(child.getNodeValue());
            }
        }
        return buffer.toString();
    }

    static String getSingularForm(String pluralForm) {
        String singularForm = "";
        if (StringUtils.isNotEmpty((String)pluralForm)) {
            if (pluralForm.endsWith("ies")) {
                singularForm = pluralForm.substring(0, pluralForm.length() - 3) + 'y';
            } else if (pluralForm.endsWith("ches")) {
                singularForm = pluralForm.substring(0, pluralForm.length() - 2);
            } else if (pluralForm.endsWith("s") && pluralForm.length() > 1) {
                singularForm = pluralForm.substring(0, pluralForm.length() - 1);
            }
        }
        return singularForm;
    }

    static String toRelative(File basedir, String path) {
        String result = null;
        if (new File(path).isAbsolute()) {
            String pathNormalized = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            result = PathTool.getRelativeFilePath((String)basedir.getAbsolutePath(), (String)pathNormalized);
        }
        if (result == null) {
            result = path;
        }
        if ((result = result.replace('\\', '/')).length() <= 0 || "/".equals(result)) {
            result = '.' + result;
        }
        return result;
    }
}

