/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.AbstractScriptedMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.ExtractionException;

public class BeanshellMojoDescriptorExtractor
extends AbstractScriptedMojoDescriptorExtractor {
    protected String getScriptFileExtension(PluginToolsRequest request) {
        return ".bsh";
    }

    protected List extractMojoDescriptors(Map scriptFilesKeyedByBasedir, PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        Iterator mapIterator = scriptFilesKeyedByBasedir.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = mapIterator.next();
            String basedir = (String)entry.getKey();
            Set metadataFiles = (Set)entry.getValue();
            Iterator it = metadataFiles.iterator();
            while (it.hasNext()) {
                File scriptFile = (File)it.next();
                String relativePath = null;
                if (basedir.endsWith("/")) {
                    basedir = basedir.substring(0, basedir.length() - 2);
                }
                relativePath = scriptFile.getPath().substring(basedir.length());
                relativePath = relativePath.replace('\\', '/');
                MojoDescriptor mojoDescriptor = this.createMojoDescriptor(basedir, relativePath, request);
                descriptors.add(mojoDescriptor);
            }
        }
        return descriptors;
    }

    private MojoDescriptor createMojoDescriptor(String basedir, String resource, PluginToolsRequest request) throws InvalidPluginDescriptorException {
        MojoDescriptor mojoDescriptor = new MojoDescriptor();
        mojoDescriptor.setPluginDescriptor(request.getPluginDescriptor());
        mojoDescriptor.setLanguage("bsh");
        mojoDescriptor.setComponentConfigurator("bsh");
        mojoDescriptor.setImplementation(resource);
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("file", (Object)new File(basedir, resource));
            interpreter.set("mojoDescriptor", (Object)mojoDescriptor);
            interpreter.eval((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/extractor.bsh"), "UTF-8"));
        }
        catch (EvalError evalError) {
            throw new InvalidPluginDescriptorException("Error scanning beanshell script", (Throwable)evalError);
        }
        catch (UnsupportedEncodingException uee) {
            throw new InvalidPluginDescriptorException("Unsupported encoding while reading beanshell script", (Throwable)uee);
        }
        return mojoDescriptor;
    }
}

