/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.w3c.tidy.Tidy;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static String[] findSources(String basedir, String include) {
        return PluginUtils.findSources(basedir, include, null);
    }

    public static String[] findSources(String basedir, String include, String exclude) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(new String[]{include});
        if (!StringUtils.isEmpty((String)exclude)) {
            scanner.setExcludes(new String[]{exclude, StringUtils.join((Object[])FileUtils.getDefaultExcludes(), (String)",")});
        } else {
            scanner.setExcludes(FileUtils.getDefaultExcludes());
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static void writeDependencies(XMLWriter w, PluginDescriptor pluginDescriptor) {
        w.startElement("dependencies");
        Iterator it = pluginDescriptor.getDependencies().iterator();
        while (it.hasNext()) {
            ComponentDependency dep = (ComponentDependency)it.next();
            w.startElement("dependency");
            PluginUtils.element(w, "groupId", dep.getGroupId());
            PluginUtils.element(w, "artifactId", dep.getArtifactId());
            PluginUtils.element(w, "type", dep.getType());
            PluginUtils.element(w, "version", dep.getVersion());
            w.endElement();
        }
        w.endElement();
    }

    public static List toComponentDependencies(List dependencies) {
        LinkedList<ComponentDependency> componentDeps = new LinkedList<ComponentDependency>();
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(dependency.getArtifactId());
            cd.setGroupId(dependency.getGroupId());
            cd.setVersion(dependency.getVersion());
            cd.setType(dependency.getType());
            componentDeps.add(cd);
        }
        return componentDeps;
    }

    public static void element(XMLWriter w, String name, String value) {
        w.startElement(name);
        if (value == null) {
            value = "";
        }
        w.writeText(value);
        w.endElement();
    }

    public static boolean isMavenReport(String impl, MavenProject project) {
        if (impl == null) {
            throw new IllegalArgumentException("mojo implementation should be declared");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (project != null) {
            List classPathStrings;
            try {
                classPathStrings = project.getCompileClasspathElements();
                if (project.getExecutionProject() != null) {
                    classPathStrings.addAll(project.getExecutionProject().getCompileClasspathElements());
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw (RuntimeException)new IllegalArgumentException().initCause(e);
            }
            ArrayList<URL> urls = new ArrayList<URL>(classPathStrings.size());
            Iterator it = classPathStrings.iterator();
            while (it.hasNext()) {
                try {
                    urls.add(new File((String)it.next()).toURL());
                }
                catch (MalformedURLException e) {
                    throw (RuntimeException)new IllegalArgumentException().initCause(e);
                }
            }
            classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(impl, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return MavenReport.class.isAssignableFrom(clazz);
    }

    public static String makeHtmlValid(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        StringOutputStream out = new StringOutputStream();
        Tidy tidy = new Tidy();
        tidy.setDocType("loose");
        tidy.setXHTML(true);
        tidy.setXmlOut(true);
        tidy.setMakeClean(true);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.parse((InputStream)new StringInputStream(PluginUtils.decodeJavadocTags(description)), (OutputStream)out);
        String LS = System.getProperty("line.separator");
        String commentCleaned = out.toString();
        if (StringUtils.isEmpty((String)commentCleaned)) {
            return "";
        }
        int startPos = commentCleaned.indexOf("<body>" + LS) + 6 + LS.length();
        int endPos = commentCleaned.indexOf(LS + "</body>");
        return commentCleaned.substring(startPos, endPos);
    }

    static String decodeJavadocTags(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        StringBuffer decoded = new StringBuffer(description.length() + 1024);
        Matcher matcher = Pattern.compile("\\{@(\\w+)\\s*([^\\}]*)\\}").matcher(description);
        while (matcher.find()) {
            String tag = matcher.group(1);
            String text = matcher.group(2);
            text = StringUtils.replace((String)text, (String)"&", (String)"&amp;");
            text = StringUtils.replace((String)text, (String)"<", (String)"&lt;");
            text = StringUtils.replace((String)text, (String)">", (String)"&gt;");
            if ("code".equals(tag)) {
                text = "<code>" + text + "</code>";
            } else if ("link".equals(tag) || "linkplain".equals(tag) || "value".equals(tag)) {
                String pattern = "(([^#\\.\\s]+\\.)*([^#\\.\\s]+))?(#([^\\(\\s]*)(\\([^\\)]*\\))?\\s*(\\S.*)?)?";
                int LABEL = 7;
                int CLASS = 3;
                int MEMBER = 5;
                int ARGS = 6;
                Matcher link = Pattern.compile(pattern).matcher(text);
                if (link.matches() && StringUtils.isEmpty((String)(text = link.group(7)))) {
                    text = link.group(3);
                    if (StringUtils.isEmpty((String)text)) {
                        text = "";
                    }
                    if (StringUtils.isNotEmpty((String)link.group(5))) {
                        if (StringUtils.isNotEmpty((String)text)) {
                            text = text + '.';
                        }
                        text = text + link.group(5);
                        if (StringUtils.isNotEmpty((String)link.group(6))) {
                            text = text + "()";
                        }
                    }
                }
                if (!"linkplain".equals(tag)) {
                    text = "<code>" + text + "</code>";
                }
            }
            matcher.appendReplacement(decoded, text != null ? PluginUtils.quoteReplacement(text) : "");
        }
        matcher.appendTail(decoded);
        return decoded.toString();
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

