/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginXdocGenerator
implements Generator {
    private final Locale locale;
    private final MavenProject project;

    public PluginXdocGenerator() {
        this.project = null;
        this.locale = Locale.ENGLISH;
    }

    public PluginXdocGenerator(MavenProject project) {
        this.project = project;
        this.locale = Locale.ENGLISH;
    }

    public PluginXdocGenerator(MavenProject project, Locale locale) {
        this.project = project;
        this.locale = locale == null ? Locale.ENGLISH : locale;
    }

    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        Iterator it = pluginDescriptor.getMojos().iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processMojoDescriptor(descriptor, destinationDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, File destinationDirectory) throws IOException {
        File outputFile = new File(destinationDirectory, this.getMojoFilename(mojoDescriptor, "xml"));
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.writeBody(writer, mojoDescriptor);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private String getMojoFilename(MojoDescriptor mojo, String ext) {
        return mojo.getGoal() + "-mojo." + ext;
    }

    private void writeBody(OutputStreamWriter writer, MojoDescriptor mojoDescriptor) {
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(new PrintWriter(writer), writer.getEncoding(), null);
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(mojoDescriptor.getPluginDescriptor().getArtifactId() + " - " + mojoDescriptor.getFullGoalName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", mojoDescriptor.getFullGoalName());
        this.writeReportNotice(mojoDescriptor, (XMLWriter)w);
        w.startElement("p");
        w.writeMarkup("<strong>" + this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.fullname") + "</strong>:");
        w.endElement();
        w.startElement("p");
        w.writeMarkup(mojoDescriptor.getPluginDescriptor().getGroupId() + ":" + mojoDescriptor.getPluginDescriptor().getArtifactId() + ":" + mojoDescriptor.getPluginDescriptor().getVersion() + ":" + mojoDescriptor.getGoal());
        w.endElement();
        w.startElement("p");
        w.writeMarkup("<strong>" + this.getBundle(this.locale).getString("pluginxdoc.description") + "</strong>:");
        w.endElement();
        w.startElement("p");
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDescription())) {
            w.writeMarkup(PluginUtils.makeHtmlValid(mojoDescriptor.getDescription()));
        } else {
            w.writeText(this.getBundle(this.locale).getString("pluginxdoc.nodescription"));
        }
        w.endElement();
        this.writeGoalAttributes(mojoDescriptor, (XMLWriter)w);
        this.writeGoalParameterTable(mojoDescriptor, (XMLWriter)w);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeReportNotice(MojoDescriptor mojoDescriptor, XMLWriter w) {
        if (PluginUtils.isMavenReport(mojoDescriptor.getImplementation(), this.project)) {
            w.startElement("p");
            w.writeMarkup("<strong>" + this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.notice.note") + "</strong>: ");
            w.writeText(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.notice.isMavenReport"));
            w.endElement();
        }
    }

    private void writeGoalAttributes(MojoDescriptor mojoDescriptor, XMLWriter w) {
        w.startElement("p");
        w.writeMarkup("<strong>" + this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.attributes") + "</strong>:");
        w.endElement();
        w.startElement("ul");
        String value = mojoDescriptor.getDeprecated();
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.deprecated") + ": " + value + ".");
            w.endElement();
        }
        if (mojoDescriptor.isProjectRequired()) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.projectRequired") + ".");
            w.endElement();
        }
        if (mojoDescriptor.isAggregator()) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.aggregator") + ".");
            w.endElement();
        }
        if (mojoDescriptor.isDirectInvocationOnly()) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.directInvocationOnly") + ".");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.isDependencyResolutionRequired()))) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.dependencyResolutionRequired") + ": <code>" + value + "</code>.");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getSince()))) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.since") + ": <code>" + value + "</code>.");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getPhase()))) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.phase") + ": <code>" + value + "</code>.");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecutePhase()))) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.executePhase1") + " <code>" + value + "</code> " + this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.executePhase2") + ".");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteGoal()))) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.executeGoal1") + " <code>" + value + "</code> " + this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.executeGoal2") + ".");
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteLifecycle()))) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.executeLifecycle") + ": <code>" + value + "</code>.");
            w.endElement();
        }
        if (mojoDescriptor.isOnlineRequired()) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.onlineRequired") + ".");
            w.endElement();
        }
        if (!mojoDescriptor.isInheritedByDefault()) {
            w.startElement("li");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.inheritedByDefault") + ".");
            w.endElement();
        }
        w.endElement();
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, XMLWriter w) {
        List parameterList = mojoDescriptor.getParameters();
        List list = this.filterParameters(parameterList);
        if (list != null && list.size() > 0) {
            this.writeParameterSummary(mojoDescriptor, list, w);
            this.writeParameterDetails(mojoDescriptor, list, w);
        } else {
            w.startElement("subsection");
            w.addAttribute("name", this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameters"));
            w.startElement("p");
            w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.noParameter"));
            w.endElement();
            w.endElement();
        }
    }

    private List filterParameters(List parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        if (parameterList != null) {
            Iterator parameters = parameterList.iterator();
            while (parameters.hasNext()) {
                String expression;
                Parameter parameter = (Parameter)parameters.next();
                if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
                filtered.add(parameter);
            }
        }
        return filtered;
    }

    private void writeParameterDetails(MojoDescriptor mojoDescriptor, List parameterList, XMLWriter w) {
        w.startElement("subsection");
        w.addAttribute("name", this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.details"));
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            w.startElement("p");
            w.writeMarkup("<strong><a name=\"" + parameter.getName() + "\">" + parameter.getName() + "</a>:</strong>");
            w.endElement();
            String description = parameter.getDescription();
            description = StringUtils.isEmpty((String)description) ? this.getBundle(this.locale).getString("pluginxdoc.nodescription") : PluginUtils.makeHtmlValid(description);
            w.startElement("p");
            w.writeMarkup(description);
            w.endElement();
            w.startElement("ul");
            this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.deprecated"), parameter.getDeprecated(), w);
            this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.type"), parameter.getType(), w);
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.since"), parameter.getSince(), w);
            } else if (StringUtils.isNotEmpty((String)mojoDescriptor.getSince())) {
                this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.since"), mojoDescriptor.getSince(), w);
            }
            if (parameter.isRequired()) {
                this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.required"), this.getBundle(this.locale).getString("pluginxdoc.yes"), w);
            } else {
                this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.required"), this.getBundle(this.locale).getString("pluginxdoc.no"), w);
            }
            this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.expression"), parameter.getExpression(), w);
            this.writeDetail(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.default"), parameter.getDefaultValue(), w);
            w.endElement();
            if (!parameters.hasNext()) continue;
            w.writeMarkup("<hr/>");
        }
        w.endElement();
    }

    private void writeDetail(String param, String value, XMLWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement("li");
            w.writeMarkup("<strong>" + param + "</strong>: <code>");
            w.writeText(value);
            w.writeMarkup("</code>");
            w.endElement();
        }
    }

    private void writeParameterSummary(MojoDescriptor mojoDescriptor, List parameterList, XMLWriter w) {
        List optionalParams;
        List requiredParams = this.getParametersByRequired(true, parameterList);
        if (requiredParams.size() > 0) {
            this.writeParameterList(mojoDescriptor, this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.requiredParameters"), requiredParams, w);
        }
        if ((optionalParams = this.getParametersByRequired(false, parameterList)).size() > 0) {
            this.writeParameterList(mojoDescriptor, this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.optionalParameters"), optionalParams, w);
        }
    }

    private void writeParameterList(MojoDescriptor mojoDescriptor, String title, List parameterList, XMLWriter w) {
        w.startElement("subsection");
        w.addAttribute("name", title);
        w.startElement("table");
        w.addAttribute("border", "0");
        w.addAttribute("align", "left");
        w.startElement("tr");
        w.startElement("th");
        w.writeText(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.name"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.type"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.since"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.description"));
        w.endElement();
        w.endElement();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            w.startElement("tr");
            w.startElement("td");
            w.writeMarkup("<strong><a href=\"#" + parameter.getName() + "\">" + parameter.getName() + "</a></strong>");
            w.endElement();
            w.startElement("td");
            int index = parameter.getType().lastIndexOf(".");
            w.writeMarkup("<code>" + parameter.getType().substring(index + 1) + "</code>");
            w.endElement();
            w.startElement("td");
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                w.writeMarkup("<code>" + parameter.getSince() + "</code>");
            } else if (StringUtils.isNotEmpty((String)mojoDescriptor.getSince())) {
                w.writeMarkup("<code>" + mojoDescriptor.getSince() + "</code>");
            } else {
                w.writeMarkup("<code>-</code>");
            }
            w.endElement();
            w.startElement("td");
            String description = parameter.getDescription();
            description = StringUtils.isEmpty((String)description) ? this.getBundle(this.locale).getString("pluginxdoc.nodescription") : PluginUtils.makeHtmlValid(description);
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                description = "<strong>" + this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.deprecated") + "</strong>. " + description;
            }
            w.writeMarkup(description + " ");
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.writeMarkup(this.getBundle(this.locale).getString("pluginxdoc.mojodescriptor.parameter.defaultValue") + ": <code>");
                w.writeText(parameter.getDefaultValue());
                w.writeMarkup("</code>.");
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
        w.endElement();
    }

    private List getParametersByRequired(boolean required, List parameterList) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pluginxdoc", locale, this.getClass().getClassLoader());
    }
}

