/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.annotations.scanner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.tools.plugin.annotations.datamodel.ComponentAnnotationContent;
import org.apache.maven.tools.plugin.annotations.datamodel.ExecuteAnnotationContent;
import org.apache.maven.tools.plugin.annotations.datamodel.MojoAnnotationContent;
import org.apache.maven.tools.plugin.annotations.datamodel.ParameterAnnotationContent;
import org.apache.maven.tools.plugin.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.annotations.scanner.MojoAnnotationsScannerRequest;
import org.apache.maven.tools.plugin.annotations.scanner.visitors.MojoAnnotationVisitor;
import org.apache.maven.tools.plugin.annotations.scanner.visitors.MojoClassVisitor;
import org.apache.maven.tools.plugin.annotations.scanner.visitors.MojoFieldVisitor;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.reflection.Reflector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MojoAnnotationsScanner.class)
public class DefaultMojoAnnotationsScanner
extends AbstractLogEnabled
implements MojoAnnotationsScanner {
    private Reflector reflector = new Reflector();

    @Override
    public Map<String, MojoAnnotatedClass> scan(MojoAnnotationsScannerRequest request) throws ExtractionException {
        HashMap<String, MojoAnnotatedClass> mojoAnnotatedClasses = new HashMap<String, MojoAnnotatedClass>();
        try {
            for (Artifact dependency : request.getDependencies()) {
                File dependencyFile = dependency.getFile();
                if (dependencyFile == null || !dependencyFile.exists()) continue;
                if (dependencyFile.isDirectory()) {
                    mojoAnnotatedClasses.putAll(this.scanDirectory(dependencyFile, request.getIncludePatterns(), dependency, true));
                    continue;
                }
                mojoAnnotatedClasses.putAll(this.scanFile(dependencyFile, request.getIncludePatterns(), dependency, true));
            }
            for (File classDirectory : request.getClassesDirectories()) {
                if (!classDirectory.exists() || !classDirectory.isDirectory()) continue;
                mojoAnnotatedClasses.putAll(this.scanDirectory(classDirectory, request.getIncludePatterns(), request.getProject().getArtifact(), false));
            }
            return mojoAnnotatedClasses;
        }
        catch (IOException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, MojoAnnotatedClass> scanFile(File archiveFile, List<String> includePatterns, Artifact artifact, boolean excludeMojo) throws IOException, ExtractionException {
        if (!archiveFile.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, MojoAnnotatedClass> mojoAnnotatedClasses = new HashMap<String, MojoAnnotatedClass>();
        ZipInputStream archiveStream = new ZipInputStream(new FileInputStream(archiveFile));
        try {
            ZipEntry zipEntry = archiveStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().endsWith(".class")) {
                    MojoClassVisitor mojoClassVisitor = new MojoClassVisitor(this.getLogger());
                    ClassReader rdr = new ClassReader((InputStream)archiveStream);
                    rdr.accept((ClassVisitor)mojoClassVisitor, 7);
                    this.analyzeVisitors(mojoClassVisitor);
                    if (excludeMojo) {
                        mojoClassVisitor.getMojoAnnotatedClass().setMojo(null);
                    }
                    if (this.isStoreClass(mojoClassVisitor.getMojoAnnotatedClass()) != null) {
                        this.getLogger().debug("found MojoAnnotatedClass:" + mojoClassVisitor.getMojoAnnotatedClass().getClassName() + ":" + mojoClassVisitor.getMojoAnnotatedClass());
                        mojoClassVisitor.getMojoAnnotatedClass().setArtifact(artifact);
                        mojoAnnotatedClasses.put(mojoClassVisitor.getMojoAnnotatedClass().getClassName(), mojoClassVisitor.getMojoAnnotatedClass());
                    }
                }
                zipEntry = archiveStream.getNextEntry();
            }
        }
        finally {
            IOUtil.close((InputStream)archiveStream);
        }
        return mojoAnnotatedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, MojoAnnotatedClass> scanDirectory(File classDirectory, List<String> includePatterns, Artifact artifact, boolean excludeMojo) throws IOException, ExtractionException {
        String[] classFiles;
        if (!classDirectory.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, MojoAnnotatedClass> mojoAnnotatedClasses = new HashMap<String, MojoAnnotatedClass>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classDirectory);
        scanner.addDefaultExcludes();
        if (includePatterns != null) {
            scanner.setIncludes(includePatterns.toArray(new String[includePatterns.size()]));
        }
        scanner.scan();
        for (String classFile : classFiles = scanner.getIncludedFiles()) {
            if (!classFile.endsWith(".class")) continue;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(classDirectory, classFile)));
            try {
                MojoClassVisitor mojoClassVisitor = new MojoClassVisitor(this.getLogger());
                ClassReader rdr = new ClassReader((InputStream)is);
                rdr.accept((ClassVisitor)mojoClassVisitor, 7);
                this.analyzeVisitors(mojoClassVisitor);
                MojoAnnotatedClass mojoAnnotatedClass = mojoClassVisitor.getMojoAnnotatedClass();
                if (excludeMojo) {
                    mojoAnnotatedClass.setMojo(null);
                }
                if (this.isStoreClass(mojoAnnotatedClass) == null) continue;
                this.getLogger().debug("found MojoAnnotatedClass:" + mojoAnnotatedClass.getClassName() + ":" + mojoAnnotatedClass);
                mojoAnnotatedClass.setArtifact(artifact);
                mojoAnnotatedClasses.put(mojoAnnotatedClass.getClassName(), mojoAnnotatedClass);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        }
        return mojoAnnotatedClasses;
    }

    private MojoAnnotatedClass isStoreClass(MojoAnnotatedClass mojoAnnotatedClass) {
        if (mojoAnnotatedClass == null) {
            return null;
        }
        return mojoAnnotatedClass;
    }

    protected void analyzeVisitors(MojoClassVisitor mojoClassVisitor) throws ExtractionException {
        try {
            MojoAnnotationVisitor mojoAnnotationVisitor = mojoClassVisitor.getAnnotationVisitorMap().get(Mojo.class.getName());
            if (mojoAnnotationVisitor != null) {
                MojoAnnotationContent mojoAnnotationContent = new MojoAnnotationContent();
                for (Map.Entry<String, Object> entry : mojoAnnotationVisitor.getAnnotationValues().entrySet()) {
                    this.reflector.invoke((Object)mojoAnnotationContent, entry.getKey(), new Object[]{entry.getValue()});
                }
                mojoClassVisitor.getMojoAnnotatedClass().setMojo(mojoAnnotationContent);
            }
            if ((mojoAnnotationVisitor = mojoClassVisitor.getAnnotationVisitorMap().get(Execute.class.getName())) != null) {
                ExecuteAnnotationContent executeAnnotationContent = new ExecuteAnnotationContent();
                for (Map.Entry entry : mojoAnnotationVisitor.getAnnotationValues().entrySet()) {
                    this.reflector.invoke((Object)executeAnnotationContent, (String)entry.getKey(), new Object[]{entry.getValue()});
                }
                mojoClassVisitor.getMojoAnnotatedClass().setExecute(executeAnnotationContent);
            }
            List<MojoFieldVisitor> mojoFieldVisitors = mojoClassVisitor.findFieldWithAnnotationClass(Parameter.class.getName());
            for (MojoFieldVisitor mojoFieldVisitor : mojoFieldVisitors) {
                ParameterAnnotationContent parameterAnnotationContent = new ParameterAnnotationContent(mojoFieldVisitor.getFieldName(), mojoFieldVisitor.getClassName());
                if (mojoFieldVisitor.getMojoAnnotationVisitor() != null) {
                    for (Map.Entry<String, Object> entry : mojoFieldVisitor.getMojoAnnotationVisitor().getAnnotationValues().entrySet()) {
                        this.reflector.invoke((Object)parameterAnnotationContent, entry.getKey(), new Object[]{entry.getValue()});
                    }
                }
                mojoClassVisitor.getMojoAnnotatedClass().getParameters().put(parameterAnnotationContent.getFieldName(), parameterAnnotationContent);
            }
            mojoFieldVisitors = mojoClassVisitor.findFieldWithAnnotationClass(org.apache.maven.plugins.annotations.Component.class.getName());
            for (MojoFieldVisitor mojoFieldVisitor : mojoFieldVisitors) {
                ComponentAnnotationContent componentAnnotationContent = new ComponentAnnotationContent(mojoFieldVisitor.getFieldName());
                if (mojoFieldVisitor.getMojoAnnotationVisitor() != null) {
                    for (Map.Entry<String, Object> entry : mojoFieldVisitor.getMojoAnnotationVisitor().getAnnotationValues().entrySet()) {
                        String methodName = entry.getKey();
                        if (StringUtils.equals((String)"role", (String)methodName)) {
                            Type type = (Type)entry.getValue();
                            componentAnnotationContent.setRoleClassName(type.getClassName());
                            continue;
                        }
                        this.reflector.invoke((Object)componentAnnotationContent, entry.getKey(), new Object[]{entry.getValue()});
                    }
                    if (StringUtils.isEmpty((String)componentAnnotationContent.getRoleClassName())) {
                        componentAnnotationContent.setRoleClassName(mojoFieldVisitor.getClassName());
                    }
                }
                mojoClassVisitor.getMojoAnnotatedClass().getComponents().put(componentAnnotationContent.getFieldName(), componentAnnotationContent);
            }
        }
        catch (Exception e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
    }
}

