/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeWriter;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.SerializerXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class XmlNodeImpl
implements Serializable,
XmlNode {
    private static final long serialVersionUID = 2567894443061173996L;
    protected final String name;
    protected final String value;
    protected final Map<String, String> attributes;
    protected final List<XmlNode> children;
    protected final Object location;

    public XmlNodeImpl(String name) {
        this(name, null, null, null, null);
    }

    public XmlNodeImpl(String name, String value) {
        this(name, value, null, null, null);
    }

    public XmlNodeImpl(XmlNode from, String name) {
        this(name, from.getValue(), from.getAttributes(), from.getChildren(), from.getInputLocation());
    }

    public XmlNodeImpl(String name, String value, Map<String, String> attributes, List<XmlNode> children, Object location) {
        this.name = Objects.requireNonNull(name);
        this.value = value;
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : Collections.emptyMap();
        this.children = children != null ? Collections.unmodifiableList(new ArrayList<XmlNode>(children)) : Collections.emptyList();
        this.location = location;
    }

    public XmlNode merge(XmlNode source, Boolean childMergeOverride) {
        return XmlNodeImpl.merge(this, source, childMergeOverride);
    }

    public XmlNode clone() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public XmlNode getChild(String name) {
        if (name != null) {
            ListIterator<XmlNode> it = this.children.listIterator(this.children.size());
            while (it.hasPrevious()) {
                XmlNode child = it.previous();
                if (!name.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    public List<XmlNode> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Object getInputLocation() {
        return this.location;
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer) throws IOException {
        SerializerXMLWriter xmlWriter = new SerializerXMLWriter(namespace, serializer);
        XmlNodeWriter.write((XMLWriter)xmlWriter, (XmlNode)this);
        if (xmlWriter.getExceptions().size() > 0) {
            throw (IOException)xmlWriter.getExceptions().get(0);
        }
    }

    public static XmlNode merge(XmlNode dominant, XmlNode recessive, Boolean childMergeOverride) {
        if (recessive == null) {
            return dominant;
        }
        if (dominant == null) {
            return recessive;
        }
        boolean mergeSelf = true;
        String selfMergeMode = dominant.getAttribute("combine.self");
        if ("override".equals(selfMergeMode)) {
            mergeSelf = false;
        }
        if (mergeSelf) {
            String value = dominant.getValue();
            Object location = dominant.getInputLocation();
            HashMap<String, String> attrs = null;
            ArrayList<XmlNode> children = null;
            for (Map.Entry attr : recessive.getAttributes().entrySet()) {
                String key = (String)attr.getKey();
                if (!XmlNodeImpl.isEmpty(dominant.getAttribute(key))) continue;
                if (attrs == null) {
                    attrs = new HashMap();
                }
                attrs.put(key, (String)attr.getValue());
            }
            if (recessive.getChildren().size() > 0) {
                boolean mergeChildren = true;
                if (childMergeOverride != null) {
                    mergeChildren = childMergeOverride;
                } else {
                    String childMergeMode = dominant.getAttribute("combine.children");
                    if ("append".equals(childMergeMode)) {
                        mergeChildren = false;
                    }
                }
                HashMap<String, Iterator> commonChildren = new HashMap<String, Iterator>();
                Set names = recessive.getChildren().stream().map(XmlNode::getName).collect(Collectors.toSet());
                for (String name : names) {
                    List dominantChildren = dominant.getChildren().stream().filter(n -> n.getName().equals(name)).collect(Collectors.toList());
                    if (dominantChildren.size() <= 0) continue;
                    commonChildren.put(name, dominantChildren.iterator());
                }
                String keysValue = recessive.getAttribute("combine.keys");
                for (XmlNode recessiveChild : recessive.getChildren()) {
                    String idValue = recessiveChild.getAttribute("combine.id");
                    XmlNode childDom = null;
                    if (XmlNodeImpl.isNotEmpty(idValue)) {
                        for (XmlNode dominantChild : dominant.getChildren()) {
                            if (!idValue.equals(dominantChild.getAttribute("combine.id"))) continue;
                            childDom = dominantChild;
                            mergeChildren = true;
                        }
                    } else if (XmlNodeImpl.isNotEmpty(keysValue)) {
                        String[] keys = keysValue.split(",");
                        Map<String, Optional> recessiveKeyValues = Stream.of(keys).collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(recessiveChild.getAttribute(k))));
                        for (XmlNode dominantChild : dominant.getChildren()) {
                            Map<String, Optional> dominantKeyValues = Stream.of(keys).collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(dominantChild.getAttribute(k))));
                            if (!recessiveKeyValues.equals(dominantKeyValues)) continue;
                            childDom = dominantChild;
                            mergeChildren = true;
                        }
                    } else {
                        childDom = dominant.getChild(recessiveChild.getName());
                    }
                    if (mergeChildren && childDom != null) {
                        String name = recessiveChild.getName();
                        Iterator it = commonChildren.computeIfAbsent(name, n1 -> Stream.of(dominant.getChildren().stream().filter(n2 -> n2.getName().equals(n1)).collect(Collectors.toList())).filter(l -> !l.isEmpty()).map(List::iterator).findFirst().orElse(null));
                        if (it == null) {
                            if (children == null) {
                                children = new ArrayList(dominant.getChildren());
                            }
                            children.add(recessiveChild);
                            continue;
                        }
                        if (!it.hasNext()) continue;
                        XmlNode dominantChild = (XmlNode)it.next();
                        String dominantChildCombinationMode = dominantChild.getAttribute("combine.self");
                        if ("remove".equals(dominantChildCombinationMode)) {
                            if (children == null) {
                                children = new ArrayList(dominant.getChildren());
                            }
                            children.remove(dominantChild);
                            continue;
                        }
                        int idx = dominant.getChildren().indexOf(dominantChild);
                        XmlNode merged = XmlNodeImpl.merge(dominantChild, recessiveChild, childMergeOverride);
                        if (merged == dominantChild) continue;
                        if (children == null) {
                            children = new ArrayList(dominant.getChildren());
                        }
                        children.set(idx, merged);
                        continue;
                    }
                    if (children == null) {
                        children = new ArrayList<XmlNode>(dominant.getChildren());
                    }
                    int idx = mergeChildren ? children.size() : recessive.getChildren().indexOf(recessiveChild);
                    children.add(idx, recessiveChild);
                }
            }
            if (value != null || attrs != null || children != null) {
                if (attrs != null) {
                    HashMap<String, String> nattrs = attrs;
                    attrs = new HashMap<String, String>(dominant.getAttributes());
                    attrs.putAll(nattrs);
                } else {
                    attrs = dominant.getAttributes();
                }
                if (children == null) {
                    children = dominant.getChildren();
                }
                return new XmlNodeImpl(dominant.getName(), value != null ? value : dominant.getValue(), attrs, (List<XmlNode>)children, location);
            }
        }
        return dominant;
    }

    public static XmlNode merge(XmlNode dominant, XmlNode recessive) {
        return XmlNodeImpl.merge(dominant, recessive, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlNodeImpl that = (XmlNodeImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.attributes, this.children);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        XmlNodeWriter.write(writer, (XmlNode)this);
        return writer.toString();
    }

    public String toUnescapedString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)writer);
        XmlNodeWriter.write((XMLWriter)xmlWriter, this, false);
        return writer.toString();
    }

    private static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

