/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static String[] findSources(String basedir, String include) {
        return PluginUtils.findSources(basedir, include, null);
    }

    public static String[] findSources(String basedir, String include, String exclude) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(new String[]{include});
        if (!StringUtils.isEmpty((String)exclude)) {
            scanner.setExcludes(new String[]{exclude, "**/.svn/**"});
        } else {
            scanner.setExcludes(new String[]{"**/.svn/**"});
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static void writeDependencies(XMLWriter w, PluginDescriptor pluginDescriptor) {
        w.startElement("dependencies");
        Iterator it = pluginDescriptor.getDependencies().iterator();
        while (it.hasNext()) {
            ComponentDependency dep = (ComponentDependency)it.next();
            w.startElement("dependency");
            PluginUtils.element(w, "groupId", dep.getGroupId());
            PluginUtils.element(w, "artifactId", dep.getArtifactId());
            PluginUtils.element(w, "type", dep.getType());
            PluginUtils.element(w, "version", dep.getVersion());
            w.endElement();
        }
        w.endElement();
    }

    public static List toComponentDependencies(List dependencies) {
        LinkedList<ComponentDependency> componentDeps = new LinkedList<ComponentDependency>();
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(dependency.getArtifactId());
            cd.setGroupId(dependency.getGroupId());
            cd.setVersion(dependency.getVersion());
            cd.setType(dependency.getType());
            componentDeps.add(cd);
        }
        return componentDeps;
    }

    private static void element(XMLWriter w, String name, String value) {
        w.startElement(name);
        if (value == null) {
            value = "";
        }
        w.writeText(value);
        w.endElement();
    }
}

